/*    */ package org.jboss.aspects.security;
/*    */ 
/*    */ import javax.naming.InitialContext;
/*    */ import javax.naming.NamingException;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.InstanceAdvisor;
/*    */ import org.jboss.aop.advice.AspectFactory;
/*    */ import org.jboss.aop.joinpoint.Joinpoint;
/*    */ import org.jboss.aop.metadata.SimpleMetaData;
/*    */ import org.jboss.security.AuthenticationManager;
/*    */ 
/*    */ public class AuthenticationInterceptorFactory
/*    */   implements AspectFactory
/*    */ {
/*    */   public Object createPerVM()
/*    */   {
/* 43 */     throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
/*    */   }
/*    */ 
/*    */   public Object createPerClass(Advisor advisor)
/*    */   {
/* 48 */     AuthenticationManager manager = (AuthenticationManager)advisor.getDefaultMetaData().getMetaData("security", "authentication-manager");
/* 49 */     if (manager == null)
/*    */     {
/* 51 */       SecurityDomain domain = (SecurityDomain)advisor.resolveAnnotation(SecurityDomain.class);
/* 52 */       if (domain == null) throw new RuntimeException("Unable to determine security domain");
/*    */       try
/*    */       {
/* 55 */         manager = (AuthenticationManager)new InitialContext().lookup("java:/jaas/" + domain.value());
/*    */       }
/*    */       catch (NamingException e)
/*    */       {
/* 59 */         throw new RuntimeException(e);
/*    */       }
/*    */     }
/* 62 */     if (manager == null) throw new RuntimeException("Unable to find Security Domain");
/* 63 */     return new AuthenticationInterceptor(manager);
/*    */   }
/*    */ 
/*    */   public Object createPerInstance(Advisor advisor, InstanceAdvisor instanceAdvisor)
/*    */   {
/* 68 */     throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
/*    */   }
/*    */ 
/*    */   public Object createPerJoinpoint(Advisor advisor, Joinpoint jp)
/*    */   {
/* 73 */     throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
/*    */   }
/*    */ 
/*    */   public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp)
/*    */   {
/* 78 */     throw new RuntimeException("PER_VM not supported for this interceptor factory, only PER_CLASS");
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 83 */     return getClass().getName();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.security.AuthenticationInterceptorFactory
 * JD-Core Version:    0.6.0
 */