/*    */ package org.jboss.aspects.remoting;
/*    */ 
/*    */ import java.io.ObjectStreamException;
/*    */ import java.io.Serializable;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.joinpoint.InvocationResponse;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.remoting.Client;
/*    */ import org.jboss.remoting.InvokerLocator;
/*    */ 
/*    */ public class InvokeRemoteInterceptor
/*    */   implements Interceptor, Serializable
/*    */ {
/* 37 */   private static final Logger log = Logger.getLogger(InvokeRemoteInterceptor.class);
/*    */   private static final long serialVersionUID = -145166951731929406L;
/* 41 */   public static final InvokeRemoteInterceptor singleton = new InvokeRemoteInterceptor();
/*    */   public static final String REMOTING = "REMOTING";
/*    */   public static final String INVOKER_LOCATOR = "INVOKER_LOCATOR";
/*    */   public static final String SUBSYSTEM = "SUBSYSTEM";
/*    */ 
/*    */   public String getName()
/*    */   {
/* 46 */     return "InvokeRemoteInterceptor";
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable {
/* 50 */     InvokerLocator locator = (InvokerLocator)invocation.getMetaData("REMOTING", "INVOKER_LOCATOR");
/* 51 */     if (locator == null)
/*    */     {
/* 53 */       throw new RuntimeException("No InvokerLocator supplied.  Can't invoke remotely!");
/*    */     }
/* 55 */     String subsystem = (String)invocation.getMetaData("REMOTING", "SUBSYSTEM");
/* 56 */     if (subsystem == null) subsystem = "AOP";
/* 57 */     Client client = new Client(locator, subsystem);
/*    */     try
/*    */     {
/* 61 */       client.connect();
/* 62 */       InvocationResponse response = (InvocationResponse)client.invoke(invocation, null);
/* 63 */       invocation.setResponseContextInfo(response.getContextInfo());
/* 64 */       Object localObject1 = response.getResponse();
/*    */       return localObject1;
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/*    */       StackTraceElement[] serverStackTrace;
/*    */       StackTraceElement[] serverStackTrace;
/* 69 */       if (e.getCause() != null)
/* 70 */         serverStackTrace = e.getCause().getStackTrace();
/*    */       else {
/* 72 */         serverStackTrace = e.getStackTrace();
/*    */       }
/* 74 */       Exception clientException = new Exception();
/* 75 */       StackTraceElement[] clientStackTrace = clientException.getStackTrace();
/* 76 */       StackTraceElement[] completeStackTrace = new StackTraceElement[serverStackTrace.length + clientStackTrace.length];
/* 77 */       System.arraycopy(serverStackTrace, 0, completeStackTrace, 0, serverStackTrace.length);
/* 78 */       System.arraycopy(clientStackTrace, 0, completeStackTrace, serverStackTrace.length, clientStackTrace.length);
/*    */ 
/* 80 */       if (e.getCause() != null)
/* 81 */         e.getCause().setStackTrace(completeStackTrace);
/*    */       else {
/* 83 */         e.setStackTrace(completeStackTrace);
/*    */       }
/* 85 */       throw e;
/*    */     }
/*    */     finally
/*    */     {
/* 89 */       client.disconnect(); } throw localObject2;
/*    */   }
/*    */ 
/*    */   Object readResolve() throws ObjectStreamException
/*    */   {
/* 94 */     return singleton;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.remoting.InvokeRemoteInterceptor
 * JD-Core Version:    0.6.0
 */