/*    */ package org.jboss.aspects.remoting;
/*    */ 
/*    */ import java.lang.reflect.InvocationTargetException;
/*    */ import java.lang.reflect.Method;
/*    */ import java.util.HashMap;
/*    */ import org.jboss.aop.advice.Interceptor;
/*    */ import org.jboss.aop.joinpoint.Invocation;
/*    */ import org.jboss.aop.joinpoint.MethodInvocation;
/*    */ import org.jboss.aop.proxy.ClassProxyFactory;
/*    */ import org.jboss.aop.util.reference.MethodPersistentReference;
/*    */ 
/*    */ public class ForwardingInterceptor
/*    */   implements Interceptor, ClusterConstants
/*    */ {
/*    */   private final Object obj;
/*    */ 
/*    */   public ForwardingInterceptor(Object obj)
/*    */   {
/* 42 */     this.obj = obj;
/*    */   }
/*    */   public String getName() {
/* 45 */     return "ForwardingInterceptor";
/*    */   }
/*    */ 
/*    */   public Object invoke(Invocation invocation) throws Throwable {
/* 49 */     if ((invocation instanceof MethodInvocation))
/*    */     {
/* 52 */       MethodInvocation methodInvocation = (MethodInvocation)invocation;
/* 53 */       long methodHash = methodInvocation.getMethodHash();
/* 54 */       HashMap methodMap = ClassProxyFactory.getMethodMap(this.obj.getClass());
/* 55 */       MethodPersistentReference ref = (MethodPersistentReference)methodMap.get(new Long(methodHash));
/* 56 */       Method method = (Method)ref.get();
/* 57 */       Object[] args = methodInvocation.getArguments();
/*    */       try
/*    */       {
/* 60 */         return method.invoke(this.obj, args);
/*    */       }
/*    */       catch (InvocationTargetException ex)
/*    */       {
/* 64 */         throw ex.getTargetException();
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/* 69 */     throw new RuntimeException("field invocations not implemented");
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.remoting.ForwardingInterceptor
 * JD-Core Version:    0.6.0
 */