/*    */ package org.jboss.aspects.asynch;
/*    */ 
/*    */ import java.io.Externalizable;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInput;
/*    */ import java.io.ObjectOutput;
/*    */ 
/*    */ public class AsynchMixin
/*    */   implements FutureHolder, AsynchProvider, Externalizable
/*    */ {
/*    */   private static final long serialVersionUID = 3408652015381364191L;
/* 39 */   private transient ThreadLocal currentFuture = new ThreadLocal();
/*    */ 
/*    */   public void setFuture(Future future)
/*    */   {
/* 47 */     Future oldFuture = (Future)this.currentFuture.get();
/*    */     try
/*    */     {
/* 50 */       if (oldFuture != null) oldFuture.release();
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/*    */     }
/*    */ 
/* 56 */     this.currentFuture.set(future);
/*    */   }
/*    */ 
/*    */   public Future getFuture()
/*    */   {
/* 61 */     Future future = (Future)this.currentFuture.get();
/* 62 */     this.currentFuture.set(null);
/* 63 */     return future;
/*    */   }
/*    */ 
/*    */   public void writeExternal(ObjectOutput out)
/*    */     throws IOException
/*    */   {
/*    */   }
/*    */ 
/*    */   public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException
/*    */   {
/* 73 */     this.currentFuture = new ThreadLocal();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.asynch.AsynchMixin
 * JD-Core Version:    0.6.0
 */