/*     */ package org.jboss.aspects.asynch;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.Dispatcher;
/*     */ import org.jboss.aop.InstanceAdvised;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.aop.proxy.ProxyFactory;
/*     */ import org.jboss.aspects.NullOrZero;
/*     */ import org.jboss.aspects.remoting.Remoting;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class AsynchAspect
/*     */ {
/*     */   public static final String FUTURE = "ASYNCH_FUTURE";
/*  47 */   private static GUID futureClassGUID = new GUID();
/*  48 */   private static Class[] futureIntf = { Future.class };
/*  49 */   private static Class[] futureDynamicIntf = { Future.class, Serializable.class, InstanceAdvised.class };
/*     */   private Advisor advisor;
/*     */   protected ExecutorAbstraction executor;
/*  52 */   private boolean generateFutureProxy = true;
/*     */ 
/*     */   public Advisor getAdvisor()
/*     */   {
/*  56 */     return this.advisor;
/*     */   }
/*     */ 
/*     */   public void setAdvisor(Advisor advisor)
/*     */   {
/*  61 */     this.advisor = advisor;
/*  62 */     Class executorClass = null;
/*  63 */     AsynchExecutor executorAnnotation = (AsynchExecutor)advisor.resolveAnnotation(AsynchExecutor.class);
/*  64 */     if (executorAnnotation == null)
/*     */     {
/*  66 */       executorClass = ThreadPoolExecutor.class;
/*     */     }
/*     */     else
/*     */     {
/*  70 */       executorClass = executorAnnotation.value();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  75 */       this.executor = ((ExecutorAbstraction)executorClass.newInstance());
/*     */     }
/*     */     catch (InstantiationException e)
/*     */     {
/*  79 */       throw new RuntimeException(e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/*  83 */       throw new RuntimeException(e);
/*     */     }
/*  85 */     this.executor.setAdvisor(advisor);
/*     */   }
/*     */ 
/*     */   public void setGenerateDynamicProxy(boolean gen)
/*     */   {
/*  91 */     this.generateFutureProxy = gen;
/*     */   }
/*     */ 
/*     */   public Object execute(MethodInvocation invocation) throws Throwable
/*     */   {
/*  96 */     RemotableFuture future = this.executor.execute(invocation);
/*     */ 
/*  98 */     InvokerLocator locator = (InvokerLocator)invocation.getMetaData("REMOTING", "INVOKER_LOCATOR");
/*     */ 
/* 101 */     if (locator != null)
/*     */     {
/* 103 */       setupRemoteFuture(invocation, future, locator);
/*     */     }
/*     */     else
/*     */     {
/* 107 */       setupLocalFuture(invocation, future);
/*     */     }
/*     */ 
/* 110 */     return NullOrZero.nullOrZero(invocation.getMethod().getReturnType());
/*     */   }
/*     */ 
/*     */   protected void setupRemoteFuture(MethodInvocation invocation, RemotableFuture future, InvokerLocator locator) throws Exception
/*     */   {
/* 115 */     GUID futureGUID = new GUID();
/* 116 */     Dispatcher.singleton.registerTarget(futureGUID, future);
/* 117 */     InstanceAdvised ia = generateProxy() ? ProxyFactory.createInterfaceProxy(futureClassGUID, Future.class.getClassLoader(), futureIntf) : (InstanceAdvised)FutureInvocationHandler.createFutureProxy(futureClassGUID, Future.class.getClassLoader(), futureDynamicIntf);
/*     */ 
/* 120 */     Remoting.makeRemotable(ia, locator, futureGUID);
/* 121 */     future.setRemoteObjectID(futureGUID);
/* 122 */     invocation.addResponseAttachment("ASYNCH_FUTURE", ia);
/*     */   }
/*     */ 
/*     */   protected boolean generateProxy()
/*     */   {
/* 131 */     return this.generateFutureProxy;
/*     */   }
/*     */ 
/*     */   protected void setupLocalFuture(MethodInvocation invocation, Future future)
/*     */   {
/* 136 */     FutureHolder provider = (FutureHolder)invocation.getTargetObject();
/* 137 */     provider.setFuture(future);
/* 138 */     invocation.addResponseAttachment("ASYNCH_FUTURE", future);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aspects.asynch.AsynchAspect
 * JD-Core Version:    0.6.0
 */