/*     */ package org.jboss.aop.util.logging;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import org.jboss.logging.LoggerPlugin;
/*     */ 
/*     */ public class SystemOutLoggerPlugin
/*     */   implements LoggerPlugin
/*     */ {
/*     */   String name;
/*     */ 
/*     */   public void debug(Object message)
/*     */   {
/*  36 */     print("[aop-debug]", message, null);
/*     */   }
/*     */ 
/*     */   public void debug(Object message, Throwable t)
/*     */   {
/*  41 */     print("[aop-debug]", message, t);
/*     */   }
/*     */ 
/*     */   public void error(Object message)
/*     */   {
/*  46 */     print("[aop-error]", message, null);
/*     */   }
/*     */ 
/*     */   public void error(Object message, Throwable t)
/*     */   {
/*  51 */     print("[aop-error]", message, t);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message)
/*     */   {
/*  56 */     print("[aop-fatal]", message, null);
/*     */   }
/*     */ 
/*     */   public void fatal(Object message, Throwable t)
/*     */   {
/*  61 */     print("[aop-debug]", message, t);
/*     */   }
/*     */ 
/*     */   public void info(Object message)
/*     */   {
/*  66 */     print("[aop-info]", message, null);
/*     */   }
/*     */ 
/*     */   public void info(Object message, Throwable t)
/*     */   {
/*  71 */     print("[aop-info]", message, t);
/*     */   }
/*     */ 
/*     */   public void init(String name)
/*     */   {
/*  76 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public boolean isDebugEnabled()
/*     */   {
/*  81 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isInfoEnabled()
/*     */   {
/*  86 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isTraceEnabled()
/*     */   {
/*  91 */     return true;
/*     */   }
/*     */ 
/*     */   public void trace(Object message)
/*     */   {
/*  96 */     print("[aop-trace]", message, null);
/*     */   }
/*     */ 
/*     */   public void trace(Object message, Throwable t)
/*     */   {
/* 101 */     print("[aop-trace]", message, null);
/*     */   }
/*     */ 
/*     */   public void warn(Object message)
/*     */   {
/* 106 */     print("[aop-warn]", message, null);
/*     */   }
/*     */ 
/*     */   public void warn(Object message, Throwable t)
/*     */   {
/* 111 */     print("[aop-warn]", message, null);
/*     */   }
/*     */ 
/*     */   private void print(String prefix, Object message, Throwable t)
/*     */   {
/* 116 */     System.out.println(prefix + " " + this.name + " " + message);
/* 117 */     if (t != null)
/*     */     {
/* 119 */       t.printStackTrace(System.out);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.logging.SystemOutLoggerPlugin
 * JD-Core Version:    0.6.0
 */