/*     */ package org.jboss.aop.util;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import org.w3c.dom.Element;
/*     */ import org.w3c.dom.Node;
/*     */ import org.w3c.dom.NodeList;
/*     */ 
/*     */ public class XmlHelper
/*     */ {
/*     */   public static Iterator getChildrenByTagName(Element element, String tagName)
/*     */   {
/*  50 */     if (element == null) return null;
/*     */ 
/*  54 */     NodeList children = element.getChildNodes();
/*  55 */     ArrayList goodChildren = new ArrayList();
/*  56 */     for (int i = 0; i < children.getLength(); i++) {
/*  57 */       Node currentChild = children.item(i);
/*  58 */       if ((currentChild.getNodeType() != 1) || (!((Element)currentChild).getTagName().equals(tagName)))
/*     */         continue;
/*  60 */       goodChildren.add(currentChild);
/*     */     }
/*     */ 
/*  63 */     return goodChildren.iterator();
/*     */   }
/*     */ 
/*     */   public static Element getUniqueChild(Element element, String tagName)
/*     */     throws Exception
/*     */   {
/*  80 */     Iterator goodChildren = getChildrenByTagName(element, tagName);
/*     */ 
/*  82 */     if ((goodChildren != null) && (goodChildren.hasNext())) {
/*  83 */       Element child = (Element)goodChildren.next();
/*  84 */       if (goodChildren.hasNext()) {
/*  85 */         throw new Exception("expected only one " + tagName + " tag");
/*     */       }
/*     */ 
/*  88 */       return child;
/*     */     }
/*  90 */     throw new Exception("expected one " + tagName + " tag");
/*     */   }
/*     */ 
/*     */   public static Element getOptionalChild(Element element, String tagName)
/*     */     throws Exception
/*     */   {
/* 107 */     return getOptionalChild(element, tagName, null);
/*     */   }
/*     */ 
/*     */   public static Element getOptionalChild(Element element, String tagName, Element defaultElement)
/*     */     throws Exception
/*     */   {
/* 126 */     Iterator goodChildren = getChildrenByTagName(element, tagName);
/*     */ 
/* 128 */     if ((goodChildren != null) && (goodChildren.hasNext())) {
/* 129 */       Element child = (Element)goodChildren.next();
/* 130 */       if (goodChildren.hasNext()) {
/* 131 */         throw new Exception("expected only one " + tagName + " tag");
/*     */       }
/*     */ 
/* 134 */       return child;
/*     */     }
/* 136 */     return defaultElement;
/*     */   }
/*     */ 
/*     */   public static String getElementContent(Element element)
/*     */     throws Exception
/*     */   {
/* 149 */     return getElementContent(element, null);
/*     */   }
/*     */ 
/*     */   public static String getElementContent(Element element, String defaultStr)
/*     */     throws Exception
/*     */   {
/* 162 */     if (element == null) {
/* 163 */       return defaultStr;
/*     */     }
/* 165 */     NodeList children = element.getChildNodes();
/* 166 */     String result = "";
/* 167 */     for (int i = 0; i < children.getLength(); i++)
/*     */     {
/* 169 */       if ((children.item(i).getNodeType() == 3) || (children.item(i).getNodeType() == 4))
/*     */       {
/* 172 */         result = result + children.item(i).getNodeValue();
/*     */       }
/* 174 */       else if (children.item(i).getNodeType() != 8)
/*     */         {
/*     */           continue;
/*     */         }
/*     */     }
/* 179 */     return result.trim();
/*     */   }
/*     */ 
/*     */   public static String getUniqueChildContent(Element element, String tagName)
/*     */     throws Exception
/*     */   {
/* 193 */     return getElementContent(getUniqueChild(element, tagName));
/*     */   }
/*     */ 
/*     */   public static String getOptionalChildContent(Element element, String tagName)
/*     */     throws Exception
/*     */   {
/* 207 */     return getElementContent(getOptionalChild(element, tagName));
/*     */   }
/*     */ 
/*     */   public static boolean getOptionalChildBooleanContent(Element element, String name) throws Exception
/*     */   {
/* 212 */     Element child = getOptionalChild(element, name);
/* 213 */     if (child != null)
/*     */     {
/* 215 */       String value = getElementContent(child).toLowerCase();
/* 216 */       return (value.equals("true")) || (value.equals("yes"));
/*     */     }
/*     */ 
/* 219 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.XmlHelper
 * JD-Core Version:    0.6.0
 */