/*    */ package org.jboss.aop.util;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.io.ObjectStreamClass;
/*    */ import java.lang.reflect.Proxy;
/*    */ 
/*    */ public class MarshalledValueInputStream extends ObjectInputStream
/*    */ {
/*    */   public MarshalledValueInputStream(InputStream is)
/*    */     throws IOException
/*    */   {
/* 45 */     super(is);
/*    */   }
/*    */ 
/*    */   protected Class resolveClass(ObjectStreamClass v)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 56 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 57 */     String className = v.getName();
/* 58 */     return loader.loadClass(className);
/*    */   }
/*    */ 
/*    */   protected Class resolveProxyClass(String[] interfaces)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 65 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/* 66 */     Class[] ifaceClasses = new Class[interfaces.length];
/* 67 */     for (int i = 0; i < interfaces.length; i++)
/*    */     {
/* 69 */       ifaceClasses[i] = loader.loadClass(interfaces[i]);
/*    */     }
/*    */ 
/* 72 */     return Proxy.getProxyClass(loader, ifaceClasses);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.MarshalledValueInputStream
 * JD-Core Version:    0.6.0
 */