/*     */ package org.jboss.aop.util;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ 
/*     */ public class JavassistUtils
/*     */ {
/*  37 */   public static CtClass[] EMPTY_CTCLASS_ARRAY = new CtClass[0];
/*     */ 
/*     */   public static CtMethod[] getMethodsWithName(CtClass clazz, String name)
/*     */   {
/*  41 */     CtMethod[] methods = clazz.getMethods();
/*  42 */     return getMethodsWithName(methods, name);
/*     */   }
/*     */ 
/*     */   public static CtMethod[] getDeclaredMethodsWithName(CtClass clazz, String name)
/*     */   {
/*  47 */     CtMethod[] methods = clazz.getDeclaredMethods();
/*  48 */     return getMethodsWithName(methods, name);
/*     */   }
/*     */ 
/*     */   private static CtMethod[] getMethodsWithName(CtMethod[] methods, String name)
/*     */   {
/*  53 */     ArrayList foundMethods = new ArrayList();
/*  54 */     for (int i = 0; i < methods.length; i++)
/*     */     {
/*  56 */       if (!methods[i].getName().equals(name))
/*     */         continue;
/*  58 */       foundMethods.add(methods[i]);
/*     */     }
/*     */ 
/*  61 */     return (CtMethod[])(CtMethod[])foundMethods.toArray(new CtMethod[foundMethods.size()]);
/*     */   }
/*     */ 
/*     */   public static boolean isSubclassOrImplements(CtClass clazz, CtClass lookingFor) throws NotFoundException
/*     */   {
/*  66 */     if (clazz == null) return false;
/*  67 */     if (clazz.equals(lookingFor)) return true;
/*  68 */     if (clazz.getName().equals("java.lang.Object")) return false;
/*     */ 
/*  70 */     if (clazz.isPrimitive()) return false;
/*     */ 
/*  72 */     CtClass[] interfaces = clazz.getInterfaces();
/*  73 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/*  75 */       if (isSubclassOrImplements(interfaces[i], lookingFor)) return true;
/*     */     }
/*     */ 
/*  78 */     return isSubclassOrImplements(clazz.getSuperclass(), lookingFor);
/*     */   }
/*     */ 
/*     */   public static String getNullOrZeroInitialiser(CtClass clazz)
/*     */   {
/*  85 */     if (clazz.isPrimitive())
/*     */     {
/*  87 */       if (clazz.equals(CtClass.booleanType)) return "false";
/*  88 */       if (clazz.equals(CtClass.charType)) return "'\\0'";
/*  89 */       if (clazz.equals(CtClass.byteType)) return "(byte)0";
/*  90 */       if (clazz.equals(CtClass.shortType)) return "(short)0";
/*  91 */       if (clazz.equals(CtClass.intType)) return "(int)0";
/*  92 */       if (clazz.equals(CtClass.longType)) return "0L";
/*  93 */       if (clazz.equals(CtClass.floatType)) return "0.0f";
/*  94 */       if (clazz.equals(CtClass.doubleType)) return "0.0d";
/*     */     }
/*     */     else
/*     */     {
/*  98 */       return "null";
/*     */     }
/* 100 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.JavassistUtils
 * JD-Core Version:    0.6.0
 */