/*     */ package org.jboss.aop.util;
/*     */ 
/*     */ import javassist.CtBehavior;
/*     */ import javassist.CtClass;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.AspectManager;
/*     */ 
/*     */ public class JavassistToReflect
/*     */ {
/*     */   public static String getParameterClassArrayString(String arrayName, CtBehavior behavior)
/*     */     throws NotFoundException
/*     */   {
/*  40 */     CtClass[] params = behavior.getParameterTypes();
/*  41 */     return getParameterClassArrayString(params, arrayName);
/*     */   }
/*     */ 
/*     */   public static String getParameterClassArrayString(CtClass[] params, String arrayName) throws NotFoundException
/*     */   {
/*  46 */     StringBuffer arr = new StringBuffer(" new java.lang.Class[" + params.length + "];");
/*     */ 
/*  48 */     for (int i = 0; i < params.length; i++)
/*     */     {
/*  50 */       arr.append(arrayName + "[" + i + "] = ");
/*     */ 
/*  52 */       if (params[i].isArray())
/*     */       {
/*  54 */         arr.append(getClassObjectString(params[i], true));
/*     */       }
/*     */       else
/*     */       {
/*  58 */         arr.append(getClassObjectString(params[i]));
/*     */       }
/*  60 */       arr.append(";");
/*     */     }
/*  62 */     return arr.toString();
/*     */   }
/*     */ 
/*     */   public static String getClassObjectString(CtClass clazz)
/*     */   {
/*  70 */     return getClassObjectString(clazz, false);
/*     */   }
/*     */ 
/*     */   public static String getClassObjectString(CtClass clazz, boolean isArray)
/*     */   {
/*  79 */     if (!isArray)
/*     */     {
/*  81 */       if (clazz.isPrimitive())
/*     */       {
/*  83 */         return getClassName(clazz);
/*     */       }
/*     */ 
/*  87 */       return "java.lang.Class.forName(\"" + getClassName(clazz) + "\")";
/*     */     }
/*     */ 
/*  93 */     if (AspectManager.debugClasses)
/*     */     {
/*  95 */       return "new " + getArrayClassName(clazz) + "[0].getClass()";
/*     */     }
/*     */ 
/*  99 */     return getArrayClassName(clazz) + "[].class";
/*     */   }
/*     */ 
/*     */   public static String getArrayClassName(CtClass clazz)
/*     */   {
/* 106 */     String name = clazz.getName();
/* 107 */     int ind = name.indexOf("[");
/* 108 */     return name.substring(0, ind);
/*     */   }
/*     */ 
/*     */   public static String getClassName(CtClass clazz)
/*     */   {
/* 113 */     if (!clazz.isPrimitive())
/*     */     {
/* 115 */       return clazz.getName();
/*     */     }
/*     */ 
/* 119 */     if (clazz == CtClass.booleanType) return "java.lang.Boolean.TYPE";
/* 120 */     if (clazz == CtClass.byteType) return "java.lang.Byte.TYPE";
/* 121 */     if (clazz == CtClass.charType) return "java.lang.Character.TYPE";
/* 122 */     if (clazz == CtClass.doubleType) return "java.lang.Double.TYPE";
/* 123 */     if (clazz == CtClass.floatType) return "java.lang.Float.TYPE";
/* 124 */     if (clazz == CtClass.intType) return "java.lang.Integer.TYPE";
/* 125 */     if (clazz == CtClass.longType) return "java.lang.Long.TYPE";
/* 126 */     if (clazz == CtClass.shortType) return "java.lang.Short.TYPE";
/* 127 */     throw new RuntimeException("Unsupported type " + clazz.getName());
/*     */   }
/*     */ 
/*     */   public static String castInvocationValueToTypeString(CtClass type)
/*     */   {
/* 133 */     return castInvocationValueToTypeString(type, "value");
/*     */   }
/*     */ 
/*     */   public static String castInvocationValueToTypeString(CtClass type, String valueName)
/*     */   {
/* 138 */     String cast = null;
/* 139 */     if (type.isPrimitive())
/*     */     {
/* 141 */       if (type.equals(CtClass.booleanType))
/*     */       {
/* 143 */         cast = "((Boolean)" + valueName + ").booleanValue()";
/*     */       }
/* 145 */       else if (type.equals(CtClass.byteType))
/*     */       {
/* 147 */         cast = "((Byte)" + valueName + ").byteValue()";
/*     */       }
/* 149 */       else if (type.equals(CtClass.charType))
/*     */       {
/* 151 */         cast = "((Character)" + valueName + ").charValue()";
/*     */       }
/* 153 */       else if (type.equals(CtClass.doubleType))
/*     */       {
/* 155 */         cast = "((Double)" + valueName + ").doubleValue()";
/*     */       }
/* 157 */       else if (type.equals(CtClass.floatType))
/*     */       {
/* 159 */         cast = "((Float)" + valueName + ").floatValue()";
/*     */       }
/* 161 */       else if (type.equals(CtClass.intType))
/*     */       {
/* 163 */         cast = "((Integer)" + valueName + ").intValue()";
/*     */       }
/* 165 */       else if (type.equals(CtClass.longType))
/*     */       {
/* 167 */         cast = "((Long)" + valueName + ").longValue()";
/*     */       }
/* 169 */       else if (type.equals(CtClass.shortType))
/*     */       {
/* 171 */         cast = "((Short)" + valueName + ").shortValue()";
/*     */       }
/*     */     }
/* 174 */     else if (type.isArray())
/*     */     {
/* 176 */       cast = "(" + type.getName() + ")" + valueName;
/*     */     }
/*     */     else
/*     */     {
/* 180 */       cast = "(" + type.getName() + ")" + valueName;
/*     */     }
/*     */ 
/* 183 */     return cast;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.JavassistToReflect
 * JD-Core Version:    0.6.0
 */