/*     */ package org.jboss.aop.util;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.security.DigestOutputStream;
/*     */ import java.security.MessageDigest;
/*     */ import java.util.HashMap;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtMethod;
/*     */ import javassist.Modifier;
/*     */ 
/*     */ public class JavassistMethodHashing
/*     */ {
/*     */   public static long methodHash(CtMethod method)
/*     */   {
/*     */     try
/*     */     {
/*  51 */       CtClass[] parameterTypes = method.getParameterTypes();
/*  52 */       String methodDesc = method.getName() + "(";
/*  53 */       for (int j = 0; j < parameterTypes.length; j++)
/*     */       {
/*  55 */         methodDesc = methodDesc + getTypeString(parameterTypes[j]);
/*     */       }
/*  57 */       methodDesc = methodDesc + ")" + getTypeString(method.getReturnType());
/*     */ 
/*  59 */       long hash = 0L;
/*  60 */       ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/*  61 */       MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/*  62 */       DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/*  63 */       dataoutputstream.writeUTF(methodDesc);
/*  64 */       dataoutputstream.flush();
/*  65 */       byte[] abyte0 = messagedigest.digest();
/*  66 */       for (int j = 0; j < Math.min(8, abyte0.length); j++)
/*  67 */         hash += ((abyte0[j] & 0xFF) << j * 8);
/*  68 */       return hash;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  72 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public static long constructorHash(CtConstructor method)
/*     */   {
/*     */     try
/*     */     {
/*  80 */       CtClass[] parameterTypes = method.getParameterTypes();
/*  81 */       String methodDesc = method.getDeclaringClass().getName() + "(";
/*  82 */       for (int j = 0; j < parameterTypes.length; j++)
/*     */       {
/*  84 */         methodDesc = methodDesc + getTypeString(parameterTypes[j]);
/*     */       }
/*  86 */       methodDesc = methodDesc + ")";
/*     */ 
/*  88 */       long hash = 0L;
/*  89 */       ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/*  90 */       MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/*  91 */       DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/*  92 */       dataoutputstream.writeUTF(methodDesc);
/*  93 */       dataoutputstream.flush();
/*  94 */       byte[] abyte0 = messagedigest.digest();
/*  95 */       for (int j = 0; j < Math.min(8, abyte0.length); j++)
/*  96 */         hash += ((abyte0[j] & 0xFF) << j * 8);
/*  97 */       return hash;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 101 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   static String getTypeString(CtClass cl)
/*     */     throws Exception
/*     */   {
/* 108 */     if (cl.equals(CtClass.byteType))
/*     */     {
/* 110 */       return "B";
/* 111 */     }if (cl.equals(CtClass.charType))
/*     */     {
/* 113 */       return "C";
/* 114 */     }if (cl.equals(CtClass.doubleType))
/*     */     {
/* 116 */       return "D";
/* 117 */     }if (cl.equals(CtClass.floatType))
/*     */     {
/* 119 */       return "F";
/* 120 */     }if (cl.equals(CtClass.intType))
/*     */     {
/* 122 */       return "I";
/* 123 */     }if (cl.equals(CtClass.longType))
/*     */     {
/* 125 */       return "J";
/* 126 */     }if (cl.equals(CtClass.shortType))
/*     */     {
/* 128 */       return "S";
/* 129 */     }if (cl.equals(CtClass.booleanType))
/*     */     {
/* 131 */       return "Z";
/* 132 */     }if (cl.equals(CtClass.voidType))
/*     */     {
/* 134 */       return "V";
/* 135 */     }if (cl.isArray())
/*     */     {
/* 137 */       return "[" + getTypeString(cl.getComponentType());
/*     */     }
/*     */ 
/* 140 */     return "L" + cl.getName().replace('.', '/') + ";";
/*     */   }
/*     */ 
/*     */   private static void addDeclaredMethods(HashMap advised, CtClass superclass)
/*     */     throws Exception
/*     */   {
/* 146 */     CtMethod[] declaredMethods = superclass.getDeclaredMethods();
/* 147 */     for (int i = 0; i < declaredMethods.length; i++)
/*     */     {
/* 149 */       if ((!superclass.isInterface()) && (!Advisable.isAdvisable(declaredMethods[i])))
/*     */         continue;
/* 151 */       Long hash = Long.valueOf(methodHash(declaredMethods[i]));
/* 152 */       if (Modifier.isVolatile(declaredMethods[i].getModifiers()))
/*     */       {
/* 154 */         advised.remove(hash);
/*     */       }
/*     */       else
/*     */       {
/* 158 */         advised.put(new Long(hash.longValue()), declaredMethods[i]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void populateMethodTables(HashMap advised, CtClass superclass)
/*     */     throws Exception
/*     */   {
/* 166 */     if (superclass == null) return;
/* 167 */     if (superclass.getName().equals("java.lang.Object")) return;
/* 168 */     if (superclass.isInterface())
/*     */     {
/* 170 */       CtClass[] ifs = superclass.getInterfaces();
/* 171 */       for (int i = 0; i < ifs.length; i++)
/*     */       {
/* 173 */         populateMethodTables(advised, ifs[i]);
/*     */       }
/* 175 */       addDeclaredMethods(advised, superclass);
/*     */     }
/*     */     else
/*     */     {
/* 179 */       populateMethodTables(advised, superclass.getSuperclass());
/* 180 */       addDeclaredMethods(advised, superclass);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static HashMap getMethodMap(CtClass clazz) throws Exception
/*     */   {
/* 186 */     HashMap map = new HashMap();
/* 187 */     populateMethodTables(map, clazz);
/* 188 */     return map;
/*     */   }
/*     */ 
/*     */   public static HashMap getDeclaredMethodMap(CtClass clazz) throws Exception
/*     */   {
/* 193 */     HashMap map = new HashMap();
/* 194 */     addDeclaredMethods(map, clazz);
/* 195 */     return map;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.JavassistMethodHashing
 * JD-Core Version:    0.6.0
 */