/*    */ package org.jboss.aop.util;
/*    */ 
/*    */ import java.util.Comparator;
/*    */ import javassist.CtClass;
/*    */ import javassist.CtConstructor;
/*    */ import javassist.bytecode.Descriptor;
/*    */ 
/*    */ public class CtConstructorComparator
/*    */   implements Comparator
/*    */ {
/* 39 */   public static final Comparator INSTANCE = new CtConstructorComparator();
/*    */ 
/*    */   private int compare(CtConstructor m1, CtConstructor m2) {
/*    */     try {
/* 43 */       CtClass[] args1 = m1.getParameterTypes();
/* 44 */       CtClass[] args2 = m2.getParameterTypes();
/* 45 */       if (args1.length < args2.length) return -1;
/* 46 */       if (args1.length > args2.length) return 1;
/* 47 */       for (int i = 0; i < args1.length; i++) {
/* 48 */         String name1 = Descriptor.toJavaName(Descriptor.toJvmName(args1[i]));
/*    */ 
/* 50 */         String name2 = Descriptor.toJavaName(Descriptor.toJvmName(args2[i]));
/*    */ 
/* 52 */         int result = name1.compareTo(name2);
/* 53 */         if (result != 0) return result; 
/*    */       }
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 57 */       throw new RuntimeException(e);
/*    */     }
/*    */ 
/* 61 */     throw new Error();
/*    */   }
/*    */ 
/*    */   public int compare(Object o1, Object o2) {
/* 65 */     return compare((CtConstructor)o1, (CtConstructor)o2);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.CtConstructorComparator
 * JD-Core Version:    0.6.0
 */