/*     */ package org.jboss.aop.util;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.security.DigestOutputStream;
/*     */ import java.security.MessageDigest;
/*     */ import java.util.HashMap;
/*     */ import org.jboss.reflect.spi.ArrayInfo;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ import org.jboss.reflect.spi.ConstructorInfo;
/*     */ import org.jboss.reflect.spi.MethodInfo;
/*     */ import org.jboss.reflect.spi.PrimitiveInfo;
/*     */ import org.jboss.reflect.spi.TypeInfo;
/*     */ 
/*     */ public class ClassInfoMethodHashing
/*     */ {
/*     */   public static long methodHash(MethodInfo methodInfo)
/*     */   {
/*     */     try
/*     */     {
/*  49 */       TypeInfo[] parameterTypes = methodInfo.getParameterTypes();
/*  50 */       String methodDesc = methodInfo.getName() + "(";
/*  51 */       for (int j = 0; j < parameterTypes.length; j++)
/*     */       {
/*  53 */         methodDesc = methodDesc + getTypeString(parameterTypes[j]);
/*     */       }
/*  55 */       methodDesc = methodDesc + ")" + getTypeString(methodInfo.getReturnType());
/*     */ 
/*  57 */       long hash = 0L;
/*  58 */       ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/*  59 */       MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/*  60 */       DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/*  61 */       dataoutputstream.writeUTF(methodDesc);
/*  62 */       dataoutputstream.flush();
/*  63 */       byte[] abyte0 = messagedigest.digest();
/*  64 */       for (int j = 0; j < Math.min(8, abyte0.length); j++)
/*  65 */         hash += ((abyte0[j] & 0xFF) << j * 8);
/*  66 */       return hash;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  70 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public static long constructorHash(ConstructorInfo constructorInfo)
/*     */   {
/*     */     try
/*     */     {
/*  78 */       TypeInfo[] parameterTypes = constructorInfo.getParameterTypes();
/*  79 */       String methodDesc = constructorInfo.getDeclaringClass().getName() + "(";
/*  80 */       for (int j = 0; j < parameterTypes.length; j++)
/*     */       {
/*  82 */         methodDesc = methodDesc + getTypeString(parameterTypes[j]);
/*     */       }
/*  84 */       methodDesc = methodDesc + ")";
/*     */ 
/*  86 */       long hash = 0L;
/*  87 */       ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
/*  88 */       MessageDigest messagedigest = MessageDigest.getInstance("SHA");
/*  89 */       DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
/*  90 */       dataoutputstream.writeUTF(methodDesc);
/*  91 */       dataoutputstream.flush();
/*  92 */       byte[] abyte0 = messagedigest.digest();
/*  93 */       for (int j = 0; j < Math.min(8, abyte0.length); j++)
/*  94 */         hash += ((abyte0[j] & 0xFF) << j * 8);
/*  95 */       return hash;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  99 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   static String getTypeString(TypeInfo cl)
/*     */     throws Exception
/*     */   {
/* 106 */     if (cl.getClass().equals(PrimitiveInfo.class))
/*     */     {
/* 108 */       if (cl.equals(PrimitiveInfo.BYTE))
/*     */       {
/* 110 */         return "B";
/*     */       }
/* 112 */       if (cl.equals(PrimitiveInfo.CHAR))
/*     */       {
/* 114 */         return "C";
/*     */       }
/* 116 */       if (cl.equals(PrimitiveInfo.DOUBLE))
/*     */       {
/* 118 */         return "D";
/*     */       }
/* 120 */       if (cl.equals(PrimitiveInfo.FLOAT))
/*     */       {
/* 122 */         return "F";
/*     */       }
/* 124 */       if (cl.equals(PrimitiveInfo.INT))
/*     */       {
/* 126 */         return "I";
/*     */       }
/* 128 */       if (cl.equals(PrimitiveInfo.LONG))
/*     */       {
/* 130 */         return "J";
/*     */       }
/* 132 */       if (cl.equals(PrimitiveInfo.SHORT))
/*     */       {
/* 134 */         return "S";
/*     */       }
/* 136 */       if (cl.equals(PrimitiveInfo.BOOLEAN))
/*     */       {
/* 138 */         return "Z";
/*     */       }
/* 140 */       if (cl.equals(PrimitiveInfo.VOID))
/*     */       {
/* 142 */         return "V";
/*     */       }
/*     */ 
/* 146 */       throw new RuntimeException("Invalid primitive info " + cl);
/*     */     }
/*     */ 
/* 149 */     if (cl.isArray())
/*     */     {
/* 151 */       TypeInfo arrayType = ((ArrayInfo)cl).getComponentType();
/* 152 */       return "[" + getTypeString(arrayType);
/*     */     }
/*     */ 
/* 156 */     return "L" + cl.getName().replace('.', '/') + ";";
/*     */   }
/*     */ 
/*     */   private static void addDeclaredMethods(HashMap advised, ClassInfo superclass)
/*     */     throws Exception
/*     */   {
/* 162 */     MethodInfo[] declaredMethods = superclass.getDeclaredMethods();
/* 163 */     if (declaredMethods != null)
/*     */     {
/* 165 */       for (int i = 0; i < declaredMethods.length; i++)
/*     */       {
/* 167 */         if ((!superclass.isInterface()) && (!Advisable.isAdvisableMethod(declaredMethods[i].getModifiers(), declaredMethods[i].getName())))
/*     */           continue;
/* 169 */         long hash = methodHash(declaredMethods[i]);
/* 170 */         advised.put(new Long(hash), declaredMethods[i]);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void populateMethodTables(HashMap advised, ClassInfo superclass)
/*     */     throws Exception
/*     */   {
/* 178 */     if (superclass == null) return;
/* 179 */     if (superclass.getName().equals("java.lang.Object")) return;
/*     */ 
/* 181 */     populateMethodTables(advised, superclass.getSuperclass());
/* 182 */     addDeclaredMethods(advised, superclass);
/*     */   }
/*     */ 
/*     */   public static HashMap getMethodMap(ClassInfo clazz) throws Exception
/*     */   {
/* 187 */     HashMap map = new HashMap();
/* 188 */     populateMethodTables(map, clazz);
/* 189 */     return map;
/*     */   }
/*     */ 
/*     */   public static HashMap getDeclaredMethodMap(ClassInfo clazz) throws Exception
/*     */   {
/* 194 */     HashMap map = new HashMap();
/* 195 */     addDeclaredMethods(map, clazz);
/* 196 */     return map;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.util.ClassInfoMethodHashing
 * JD-Core Version:    0.6.0
 */