/*     */ package org.jboss.aop.standalone;
/*     */ 
/*     */ import gnu.trove.TLongObjectHashMap;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ import java.io.Writer;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.CallerConstructorInfo;
/*     */ import org.jboss.aop.CallerMethodInfo;
/*     */ import org.jboss.aop.ClassAdvisor;
/*     */ import org.jboss.aop.ConstructorInfo;
/*     */ import org.jboss.aop.FieldInfo;
/*     */ import org.jboss.aop.MethodInfo;
/*     */ import org.jboss.aop.advice.AbstractAdvice;
/*     */ import org.jboss.aop.advice.AdviceBinding;
/*     */ import org.jboss.aop.advice.CFlowInterceptor;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction;
/*     */ import org.jboss.aop.introduction.InterfaceIntroduction.Mixin;
/*     */ import org.jboss.aop.metadata.ConstructorMetaData;
/*     */ import org.jboss.aop.metadata.FieldMetaData;
/*     */ import org.jboss.aop.metadata.MethodMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData.MetaDataValue;
/*     */ import org.jboss.aop.pointcut.Pointcut;
/*     */ 
/*     */ public class XmlReport
/*     */ {
/*     */   public static String toXml()
/*     */   {
/*  63 */     Package root = Package.aopClassMap();
/*  64 */     StringWriter writer = new StringWriter();
/*  65 */     PrintWriter pw = new PrintWriter(writer);
/*  66 */     pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
/*  67 */     pw.println("<aop-report>");
/*  68 */     outputPackage(1, pw, root);
/*  69 */     outputUnboundBindings(1, pw);
/*  70 */     pw.println("</aop-report>");
/*  71 */     pw.flush();
/*  72 */     return writer.toString();
/*     */   }
/*     */ 
/*     */   private static String getIndent(int indent)
/*     */   {
/*  77 */     StringBuffer sb = new StringBuffer();
/*  78 */     for (int i = 0; i < indent; i++)
/*     */     {
/*  80 */       sb.append(" ");
/*     */     }
/*     */ 
/*  83 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public static void indenter(Writer w, int indent)
/*     */   {
/*     */     try
/*     */     {
/*  90 */       w.write(getIndent(indent));
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/*  94 */       throw new RuntimeException("IOException in indent", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected static String simpleType(Class type)
/*     */   {
/* 100 */     Class ret = type;
/* 101 */     if (ret.isArray())
/*     */     {
/* 103 */       Class arr = ret;
/* 104 */       String array = "";
/* 105 */       while (arr.isArray())
/*     */       {
/* 107 */         array = array + "[]";
/* 108 */         arr = arr.getComponentType();
/*     */       }
/* 110 */       return arr.getName();
/*     */     }
/* 112 */     return ret.getName();
/*     */   }
/*     */ 
/*     */   public static void outputPackage(int indent, PrintWriter pw, Package root)
/*     */   {
/* 117 */     Iterator it = root.packages.entrySet().iterator();
/* 118 */     while (it.hasNext())
/*     */     {
/* 120 */       Map.Entry entry = (Map.Entry)it.next();
/* 121 */       String pkgName = (String)entry.getKey();
/* 122 */       indenter(pw, indent);
/* 123 */       pw.println("<package name=\"" + pkgName + "\">");
/* 124 */       Package p = (Package)entry.getValue();
/* 125 */       outputPackage(indent + 1, pw, p);
/* 126 */       indenter(pw, indent);
/* 127 */       pw.println("</package>");
/*     */     }
/* 129 */     it = root.advisors.entrySet().iterator();
/* 130 */     while (it.hasNext())
/*     */     {
/* 132 */       Map.Entry entry = (Map.Entry)it.next();
/* 133 */       String classname = (String)entry.getKey();
/* 134 */       indenter(pw, indent);
/* 135 */       pw.println("<class name=\"" + classname + "\">");
/* 136 */       ClassAdvisor advisor = (ClassAdvisor)entry.getValue();
/* 137 */       outputAdvisor(indent + 1, pw, advisor, classname);
/* 138 */       indenter(pw, indent);
/* 139 */       pw.println("</class>");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void outputAdvisor(int indent, PrintWriter pw, ClassAdvisor advisor, String baseName)
/*     */   {
/* 145 */     ArrayList introductions = advisor.getInterfaceIntroductions();
/* 146 */     if ((introductions != null) && (introductions.size() > 0))
/*     */     {
/* 148 */       indenter(pw, indent);
/* 149 */       pw.println("<introductions>");
/* 150 */       indent++;
/* 151 */       for (int i = 0; i < introductions.size(); i++)
/*     */       {
/* 153 */         InterfaceIntroduction pointcut = (InterfaceIntroduction)introductions.get(i);
/* 154 */         indenter(pw, indent);
/* 155 */         pw.println("<introduction classExpr=\"" + pointcut.getClassExpr() + "\">");
/* 156 */         indent++;
/* 157 */         String[] intfs = pointcut.getInterfaces();
/* 158 */         ArrayList mixins = pointcut.getMixins();
/*     */ 
/* 160 */         if ((intfs != null) && (intfs.length > 0))
/*     */         {
/* 163 */           for (int j = 0; j < intfs.length; j++)
/*     */           {
/* 165 */             indenter(pw, indent);
/* 166 */             pw.println("<interface class=\"" + intfs[j] + "\"/>");
/*     */           }
/*     */         }
/* 169 */         else if ((mixins != null) && (mixins.size() > 0))
/*     */         {
/* 172 */           for (int j = 0; j < mixins.size(); j++)
/*     */           {
/* 174 */             InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)mixins.get(j);
/* 175 */             String[] mixifs = mixin.getInterfaces();
/*     */ 
/* 177 */             for (int k = 0; k < mixifs.length; k++)
/*     */             {
/* 179 */               indenter(pw, indent);
/* 180 */               pw.println("<interface class=\"" + mixifs[j] + "\"/>");
/*     */             }
/* 182 */             indenter(pw, indent);
/* 183 */             pw.println("<mixin class=\"" + mixin.getClassName() + "\"/>");
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 188 */         indent--;
/* 189 */         indenter(pw, indent);
/* 190 */         pw.println("</introduction>");
/*     */       }
/* 192 */       indent--;
/* 193 */       indenter(pw, indent);
/* 194 */       pw.println("</introductions>");
/*     */     }
/* 196 */     indenter(pw, indent);
/* 197 */     pw.println("<constructors>");
/* 198 */     indent++;
/* 199 */     for (int i = 0; i < advisor.getConstructors().length; i++)
/*     */     {
/* 201 */       Constructor con = advisor.getConstructors()[i];
/* 202 */       Interceptor[] chain = advisor.getConstructorInfos()[i].getInterceptors();
/* 203 */       HashMap methodCallers = advisor.getMethodCalledByConInterceptors()[i];
/* 204 */       HashMap conCallers = advisor.getConCalledByConInterceptors()[i];
/*     */ 
/* 206 */       if (((chain == null) || (chain.length <= 0)) && (methodCallers == null) && (conCallers == null))
/*     */         continue;
/* 208 */       indenter(pw, indent);
/* 209 */       pw.println("<constructor signature=\"" + con.toString() + "\">");
/* 210 */       if ((chain != null) && (chain.length > 0))
/*     */       {
/* 212 */         outputChain(indent + 1, pw, chain);
/*     */       }
/* 214 */       if (methodCallers != null)
/*     */       {
/* 216 */         outputMethodCallers(indent + 1, pw, methodCallers);
/*     */       }
/* 218 */       if (conCallers != null)
/*     */       {
/* 220 */         outputConCallers(indent + 1, pw, conCallers);
/*     */       }
/* 222 */       indenter(pw, indent);
/* 223 */       pw.println("</constructor>");
/*     */     }
/*     */ 
/* 227 */     indent--;
/* 228 */     indenter(pw, indent);
/* 229 */     pw.println("</constructors>");
/* 230 */     indenter(pw, indent);
/* 231 */     pw.println("<fields-read>");
/* 232 */     indent++;
/* 233 */     for (int i = 0; i < advisor.getAdvisedFields().length; i++)
/*     */     {
/* 235 */       Field f = advisor.getAdvisedFields()[i];
/* 236 */       Interceptor[] chain = advisor.getFieldReadInfos()[i].getInterceptors();
/* 237 */       if ((chain == null) || (chain.length <= 0))
/*     */         continue;
/* 239 */       indenter(pw, indent);
/* 240 */       pw.println("<field name=\"" + f.getName() + "\">");
/* 241 */       outputChain(indent + 1, pw, chain);
/* 242 */       indenter(pw, indent);
/* 243 */       pw.println("</field>");
/*     */     }
/*     */ 
/* 247 */     indent--;
/* 248 */     indenter(pw, indent);
/* 249 */     pw.println("</fields-read>");
/* 250 */     indenter(pw, indent);
/* 251 */     pw.println("<fields-write>");
/* 252 */     indent++;
/* 253 */     for (int i = 0; i < advisor.getAdvisedFields().length; i++)
/*     */     {
/* 255 */       Field f = advisor.getAdvisedFields()[i];
/* 256 */       Interceptor[] chain = advisor.getFieldReadInfos()[i].getInterceptors();
/* 257 */       if ((chain == null) || (chain.length <= 0))
/*     */         continue;
/* 259 */       indenter(pw, indent);
/* 260 */       pw.println("<field name=\"" + f.getName() + "\">");
/* 261 */       outputChain(indent + 1, pw, chain);
/* 262 */       indenter(pw, indent);
/* 263 */       pw.println("</field>");
/*     */     }
/*     */ 
/* 267 */     indent--;
/* 268 */     indenter(pw, indent);
/* 269 */     pw.println("</fields-write>");
/* 270 */     indenter(pw, indent);
/* 271 */     pw.println("<methods>");
/* 272 */     indent++;
/* 273 */     long[] keys = advisor.getMethodInterceptors().keys();
/* 274 */     for (int i = 0; i < keys.length; i++)
/*     */     {
/* 276 */       long key = keys[i];
/* 277 */       MethodInfo method = (MethodInfo)advisor.getMethodInterceptors().get(key);
/* 278 */       HashMap methodCallers = (HashMap)advisor.getMethodCalledByMethodInterceptors().get(key);
/* 279 */       HashMap conCallers = (HashMap)advisor.getConCalledByMethodInterceptors().get(key);
/* 280 */       if (((method == null) && (methodCallers == null)) || (
/* 281 */         (method != null) && (methodCallers == null) && ((method.getInterceptors() == null) || (method.getInterceptors().length < 1)))) continue;
/* 282 */       indenter(pw, indent);
/* 283 */       pw.println("<method signature=\"" + method.getMethod().toString() + "\">");
/* 284 */       if (method != null)
/*     */       {
/* 286 */         Interceptor[] chain = method.getInterceptors();
/* 287 */         if ((chain != null) && (chain.length > 0))
/*     */         {
/* 289 */           outputChain(indent + 1, pw, chain);
/*     */         }
/*     */       }
/* 292 */       if (methodCallers != null)
/*     */       {
/* 294 */         outputMethodCallers(indent + 1, pw, methodCallers);
/*     */       }
/* 296 */       if (conCallers != null)
/*     */       {
/* 298 */         outputConCallers(indent + 1, pw, conCallers);
/*     */       }
/* 300 */       indenter(pw, indent);
/* 301 */       pw.println("</method>");
/*     */     }
/*     */ 
/* 304 */     indent--;
/* 305 */     indenter(pw, indent);
/* 306 */     pw.println("</methods>");
/*     */ 
/* 308 */     outputMetadata(indent, pw, advisor);
/*     */   }
/*     */ 
/*     */   public static void outputMethodCallers(int indent, PrintWriter pw, HashMap called)
/*     */   {
/* 314 */     indenter(pw, indent);
/* 315 */     pw.println("<method-callers>");
/* 316 */     indent++;
/* 317 */     Iterator it = called.values().iterator();
/* 318 */     while (it.hasNext())
/*     */     {
/* 320 */       TLongObjectHashMap map = (TLongObjectHashMap)it.next();
/* 321 */       Object[] values = map.getValues();
/* 322 */       for (int i = 0; i < values.length; i++)
/*     */       {
/* 324 */         CallerMethodInfo caller = (CallerMethodInfo)values[i];
/* 325 */         indenter(pw, indent);
/* 326 */         if (caller.getInterceptors() != null)
/*     */         {
/* 328 */           pw.println("<called-method signature=\"" + caller.getMethod() + "\">");
/* 329 */           outputChain(indent + 1, pw, caller.getInterceptors());
/* 330 */           indenter(pw, indent);
/* 331 */           pw.println("</called-method>");
/*     */         }
/*     */         else
/*     */         {
/* 335 */           pw.println("<called-method signature=\"" + caller.getMethod() + "\"/>");
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 340 */     indent--;
/* 341 */     indenter(pw, indent);
/* 342 */     pw.println("</method-callers>");
/*     */   }
/*     */ 
/*     */   public static void outputConCallers(int indent, PrintWriter pw, HashMap called)
/*     */   {
/* 347 */     indenter(pw, indent);
/* 348 */     pw.println("<constructor-callers>");
/* 349 */     indent++;
/* 350 */     Iterator it = called.values().iterator();
/* 351 */     while (it.hasNext())
/*     */     {
/* 353 */       TLongObjectHashMap map = (TLongObjectHashMap)it.next();
/* 354 */       Object[] values = map.getValues();
/* 355 */       for (int i = 0; i < values.length; i++)
/*     */       {
/* 357 */         CallerConstructorInfo caller = (CallerConstructorInfo)values[i];
/* 358 */         indenter(pw, indent);
/* 359 */         if (caller.getInterceptors() != null)
/*     */         {
/* 361 */           pw.println("<called-constructor signature=\"" + caller.getConstructor() + "\">");
/* 362 */           outputChain(indent + 1, pw, caller.getInterceptors());
/* 363 */           indenter(pw, indent);
/* 364 */           pw.println("</called-constructor>");
/*     */         }
/*     */         else
/*     */         {
/* 368 */           pw.println("<called-constructor signature=\"" + caller.getConstructor() + "\"/>");
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 373 */     indent--;
/* 374 */     indenter(pw, indent);
/* 375 */     pw.println("</constructor-callers>");
/*     */   }
/*     */ 
/*     */   public static void outputChain(int indent, PrintWriter pw, Interceptor[] chain)
/*     */   {
/* 380 */     indenter(pw, indent);
/* 381 */     pw.println("<interceptors>");
/* 382 */     indent++;
/* 383 */     for (int i = 0; i < chain.length; i++)
/*     */     {
/* 385 */       if ((chain[i] instanceof AbstractAdvice))
/*     */       {
/* 387 */         indenter(pw, indent);
/* 388 */         pw.println("<advice name=\"" + chain[i].getName() + "\"/>");
/*     */       }
/* 390 */       else if ((chain[i] instanceof CFlowInterceptor))
/*     */       {
/* 392 */         indenter(pw, indent);
/* 393 */         pw.println("<cflow expr=\"" + ((CFlowInterceptor)chain[i]).getCFlowString() + "\"/>");
/*     */       }
/*     */       else
/*     */       {
/* 397 */         indenter(pw, indent);
/* 398 */         pw.println("<interceptor class=\"" + chain[i].getClass().getName() + "\"/>");
/*     */       }
/*     */     }
/* 401 */     indent--;
/* 402 */     indenter(pw, indent);
/* 403 */     pw.println("</interceptors>");
/*     */   }
/*     */ 
/*     */   public static void outputUnboundBindings(int indent, PrintWriter pw)
/*     */   {
/* 408 */     boolean first = true;
/* 409 */     Iterator it = AspectManager.instance().getBindings().values().iterator();
/* 410 */     while (it.hasNext())
/*     */     {
/* 412 */       AdviceBinding binding = (AdviceBinding)it.next();
/* 413 */       if (!binding.hasAdvisors())
/*     */       {
/* 415 */         if (first)
/*     */         {
/* 417 */           first = false;
/* 418 */           indenter(pw, indent);
/* 419 */           pw.println("<unbound-bindings>");
/* 420 */           indent++;
/*     */         }
/* 422 */         indenter(pw, indent);
/* 423 */         pw.print("<binding pointcut=\"" + binding.getPointcut().getExpr() + "\"");
/* 424 */         if (binding.getCFlowString() != null)
/*     */         {
/* 426 */           pw.print(" cflow=\"" + binding.getCFlowString() + "\"");
/*     */         }
/* 428 */         pw.println(" />");
/*     */       }
/*     */     }
/* 431 */     if (!first)
/*     */     {
/* 433 */       indent--;
/* 434 */       indenter(pw, indent);
/* 435 */       pw.println("</unbound-bindings>");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void outputMetadata(int indent, PrintWriter pw, ClassAdvisor advisor)
/*     */   {
/* 441 */     StringWriter sw = new StringWriter();
/* 442 */     PrintWriter metaWriter = new PrintWriter(sw);
/*     */ 
/* 444 */     StringBuffer sb = new StringBuffer();
/* 445 */     sb.append(getDefaultMetadataXml(indent, metaWriter, advisor));
/* 446 */     sb.append(getClassMetadataXml(indent, metaWriter, advisor));
/* 447 */     sb.append(getConstructorMetadataXml(indent, pw, advisor));
/* 448 */     sb.append(getMethodMetadataXml(indent, pw, advisor));
/* 449 */     sb.append(getFieldMetadataXml(indent, pw, advisor));
/*     */ 
/* 452 */     if (sb.length() > 0)
/*     */     {
/* 454 */       indenter(pw, indent);
/* 455 */       pw.println("<metadata>");
/* 456 */       pw.print(sb.toString());
/* 457 */       indenter(pw, indent);
/* 458 */       pw.println("</metadata>");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static String getDefaultMetadataXml(int indent, PrintWriter pw, ClassAdvisor advisor)
/*     */   {
/* 464 */     SimpleMetaData metadata = advisor.getDefaultMetaData();
/*     */ 
/* 466 */     indent++;
/* 467 */     StringBuffer xml = getMetadataXml(indent, advisor, metadata);
/*     */ 
/* 469 */     if (xml != null)
/*     */     {
/* 471 */       xml.insert(0, getIndent(indent) + "<default>\r\n");
/* 472 */       xml.append(getIndent(indent) + "</default>\r\n");
/* 473 */       return xml.toString();
/*     */     }
/* 475 */     indent--;
/*     */ 
/* 477 */     return "";
/*     */   }
/*     */ 
/*     */   public static String getClassMetadataXml(int indent, PrintWriter pw, ClassAdvisor advisor)
/*     */   {
/* 482 */     SimpleMetaData metadata = advisor.getClassMetaData();
/*     */ 
/* 484 */     indent++;
/* 485 */     StringBuffer xml = getMetadataXml(indent, advisor, metadata);
/*     */ 
/* 487 */     if (xml != null)
/*     */     {
/* 489 */       xml.insert(0, getIndent(indent) + "<class>\r\n");
/* 490 */       xml.append(getIndent(indent) + "</class>\r\n");
/* 491 */       return xml.toString();
/*     */     }
/* 493 */     indent--;
/*     */ 
/* 495 */     return "";
/*     */   }
/*     */ 
/*     */   public static String getFieldMetadataXml(int indent, PrintWriter pw, ClassAdvisor advisor)
/*     */   {
/* 500 */     FieldMetaData fieldMetaData = advisor.getFieldMetaData();
/*     */ 
/* 502 */     StringBuffer xml = new StringBuffer();
/* 503 */     indent++;
/* 504 */     for (Iterator it = fieldMetaData.getFields(); it.hasNext(); )
/*     */     {
/* 506 */       String field = (String)it.next();
/* 507 */       SimpleMetaData fieldData = fieldMetaData.getFieldMetaData(field);
/* 508 */       indent++;
/* 509 */       indent++;
/* 510 */       StringBuffer sb = getMetadataXml(indent, advisor, fieldData);
/* 511 */       indent--;
/* 512 */       indent--;
/*     */ 
/* 514 */       if (sb != null)
/*     */       {
/* 516 */         indent++;
/* 517 */         xml.append(getIndent(indent) + "<field name=\"" + field + "\">" + "\r\n");
/* 518 */         xml.append(sb);
/* 519 */         xml.append(getIndent(indent) + "</field>" + "\r\n");
/* 520 */         indent--;
/*     */       }
/*     */     }
/*     */ 
/* 524 */     if (xml.length() > 0)
/*     */     {
/* 526 */       xml.insert(0, getIndent(indent) + "<fields>" + "\r\n");
/* 527 */       xml.append(getIndent(indent) + "</fields>" + "\r\n");
/*     */     }
/* 529 */     indent--;
/*     */ 
/* 531 */     return xml.toString();
/*     */   }
/*     */ 
/*     */   public static String getConstructorMetadataXml(int indent, PrintWriter pw, ClassAdvisor advisor)
/*     */   {
/* 536 */     ConstructorMetaData constructorMetaData = advisor.getConstructorMetaData();
/*     */ 
/* 538 */     StringBuffer xml = new StringBuffer();
/* 539 */     indent++;
/* 540 */     for (Iterator it = constructorMetaData.getConstructors(); it.hasNext(); )
/*     */     {
/* 542 */       String constructor = (String)it.next();
/* 543 */       SimpleMetaData constructorData = constructorMetaData.getConstructorMetaData(constructor);
/* 544 */       indent++;
/* 545 */       indent++;
/* 546 */       StringBuffer sb = getMetadataXml(indent, advisor, constructorData);
/* 547 */       indent--;
/* 548 */       indent--;
/*     */ 
/* 550 */       if (sb != null)
/*     */       {
/* 552 */         indent++;
/* 553 */         xml.append(getIndent(indent) + "<constructor name=\"" + constructor + "\">" + "\r\n");
/* 554 */         xml.append(sb);
/* 555 */         xml.append(getIndent(indent) + "</constructor>" + "\r\n");
/* 556 */         indent--;
/*     */       }
/*     */     }
/*     */ 
/* 560 */     if (xml.length() > 0)
/*     */     {
/* 562 */       xml.insert(0, getIndent(indent) + "<constructors>" + "\r\n");
/* 563 */       xml.append(getIndent(indent) + "</constructors>" + "\r\n");
/*     */     }
/* 565 */     indent--;
/*     */ 
/* 567 */     return xml.toString();
/*     */   }
/*     */ 
/*     */   public static String getMethodMetadataXml(int indent, PrintWriter pw, ClassAdvisor advisor)
/*     */   {
/* 572 */     MethodMetaData methodMetaData = advisor.getMethodMetaData();
/*     */ 
/* 574 */     StringBuffer xml = new StringBuffer();
/* 575 */     indent++;
/* 576 */     for (Iterator it = methodMetaData.getMethods(); it.hasNext(); )
/*     */     {
/* 578 */       String method = (String)it.next();
/* 579 */       SimpleMetaData methodData = methodMetaData.getMethodMetaData(method);
/* 580 */       indent++;
/* 581 */       indent++;
/* 582 */       StringBuffer sb = getMetadataXml(indent, advisor, methodData);
/* 583 */       indent--;
/* 584 */       indent--;
/*     */ 
/* 586 */       if (sb != null)
/*     */       {
/* 588 */         indent++;
/* 589 */         xml.append(getIndent(indent) + "<method name=\"" + method + "\">" + "\r\n");
/* 590 */         xml.append(sb);
/* 591 */         xml.append(getIndent(indent) + "</method>" + "\r\n");
/* 592 */         indent--;
/*     */       }
/*     */     }
/*     */ 
/* 596 */     if (xml.length() > 0)
/*     */     {
/* 598 */       xml.insert(0, getIndent(indent) + "<methods>" + "\r\n");
/* 599 */       xml.append(getIndent(indent) + "</methods>" + "\r\n");
/*     */     }
/* 601 */     indent--;
/*     */ 
/* 603 */     return xml.toString();
/*     */   }
/*     */ 
/*     */   public static StringBuffer getMetadataXml(int indent, ClassAdvisor advisor, SimpleMetaData metadata)
/*     */   {
/* 608 */     StringWriter sw = new StringWriter();
/* 609 */     HashSet tags = metadata.tags();
/* 610 */     if (tags.size() == 0)
/*     */     {
/* 612 */       return null;
/*     */     }
/*     */ 
/* 615 */     for (Iterator tagsIt = tags.iterator(); tagsIt.hasNext(); )
/*     */     {
/* 617 */       String tag = (String)tagsIt.next();
/* 618 */       HashMap groupAttrs = metadata.tag(tag);
/*     */ 
/* 620 */       indent++;
/* 621 */       indenter(sw, indent);
/* 622 */       sw.write("<tag name=\"" + tag + "\">" + "\r\n");
/* 623 */       indent++;
/*     */ 
/* 625 */       if (groupAttrs == null)
/*     */       {
/*     */         continue;
/*     */       }
/*     */ 
/* 630 */       boolean hasValues = false;
/* 631 */       for (Iterator attrsIt = groupAttrs.entrySet().iterator(); attrsIt.hasNext(); )
/*     */       {
/* 633 */         Map.Entry entry = (Map.Entry)attrsIt.next();
/* 634 */         String attr = (String)entry.getKey();
/* 635 */         if (!attr.equals("$tagged$"))
/*     */         {
/* 637 */           hasValues = true;
/* 638 */           SimpleMetaData.MetaDataValue value = (SimpleMetaData.MetaDataValue)entry.getValue();
/*     */ 
/* 640 */           indenter(sw, indent);
/* 641 */           sw.write("<attribute name=\"" + attr + "\">" + "\r\n");
/*     */ 
/* 643 */           indent++;
/* 644 */           indenter(sw, indent);
/* 645 */           sw.write("<type>" + value.value.getClass().getName() + "</type>" + "\r\n");
/* 646 */           indenter(sw, indent);
/* 647 */           sw.write("<value-as-string>" + value.value.toString() + "</value-as-string>" + "\r\n");
/* 648 */           indenter(sw, indent);
/* 649 */           sw.write("<serialization>" + value.type + "</serialization>" + "\r\n");
/* 650 */           indent--;
/*     */ 
/* 652 */           indenter(sw, indent);
/* 653 */           sw.write("</attribute>\r\n");
/*     */         }
/*     */       }
/*     */ 
/* 657 */       if (!hasValues)
/*     */       {
/* 659 */         indenter(sw, indent);
/* 660 */         sw.write("<empty/>\r\n");
/*     */       }
/*     */ 
/* 663 */       indent--;
/* 664 */       indenter(sw, indent);
/* 665 */       sw.write("</tag>\r\n");
/* 666 */       indent--;
/*     */     }
/*     */ 
/* 669 */     return sw.getBuffer();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.standalone.XmlReport
 * JD-Core Version:    0.6.0
 */