/*     */ package org.jboss.aop.standalone;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.CodeSource;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.security.PrivilegedActionException;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.security.cert.Certificate;
/*     */ import java.util.Enumeration;
/*     */ 
/*     */ public class SystemClassLoader extends ClassLoader
/*     */ {
/*     */   private static final int NOT_INSTALLED = 0;
/*     */   private static final int INSTALLED = 1;
/*     */   private static final int INITIALIZING = 2;
/*     */   private static final int INITIALIZED = 3;
/*  94 */   private int state = 0;
/*     */ 
/*  99 */   ClassLoader parent = null;
/*     */   Method deployXML;
/*     */   Method transform;
/*     */   Method instance;
/*     */   Object aspectManager;
/*     */ 
/*     */   public SystemClassLoader(ClassLoader parent)
/*     */   {
/* 132 */     super(parent);
/* 133 */     install();
/*     */   }
/*     */ 
/*     */   public synchronized Class loadClass(String name, boolean resolve)
/*     */     throws ClassNotFoundException
/*     */   {
/* 149 */     Class clazz = findLoadedClass(name);
/* 150 */     if (clazz != null)
/*     */     {
/* 152 */       if (resolve) resolveClass(clazz);
/* 153 */       return clazz;
/*     */     }
/*     */ 
/* 157 */     clazz = loadClassByDelegation(name);
/* 158 */     if (clazz != null)
/*     */     {
/* 160 */       if (resolve) resolveClass(clazz);
/* 161 */       return clazz;
/*     */     }
/*     */ 
/* 165 */     initialize();
/*     */     try
/*     */     {
/* 170 */       ClassBytes origBytes = loadClassBytes(name);
/* 171 */       ClassBytes classBytes = new ClassBytes(null);
/*     */ 
/* 174 */       if (this.state == 3)
/*     */       {
/* 176 */         Object[] args = { this, name, null, null, origBytes.bytes };
/* 177 */         if (!name.startsWith("org.jboss.aop"))
/*     */         {
/* 179 */           classBytes.bytes = ((byte[])(byte[])this.transform.invoke(this.aspectManager, args));
/* 180 */           classBytes.protectionDomain = origBytes.protectionDomain;
/*     */         }
/*     */       }
/* 183 */       if (classBytes.bytes == null) {
/* 184 */         classBytes = origBytes;
/*     */       }
/*     */ 
/* 187 */       return defineClassFromBytes(name, classBytes, resolve);
/*     */     }
/*     */     catch (IOException ioe)
/*     */     {
/* 191 */       throw new ClassNotFoundException("Unable to load " + name, ioe);
/*     */     }
/*     */     catch (IllegalAccessException iae)
/*     */     {
/* 195 */       throw new Error(iae);
/*     */     }
/*     */     catch (InvocationTargetException ite) {
/*     */     }
/* 199 */     throw new Error("Error transforming the class " + name, ite.getCause());
/*     */   }
/*     */ 
/*     */   protected ClassBytes loadClassBytes(String name)
/*     */     throws ClassNotFoundException, IOException
/*     */   {
/* 209 */     String classFileName = name.replace('.', '/') + ".class";
/* 210 */     URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(classFileName)
/*     */     {
/*     */       public Object run()
/*     */       {
/* 214 */         return SystemClassLoader.this.getParent().getResource(this.val$classFileName);
/*     */       }
/*     */     });
/* 217 */     ProtectionDomain protectionDomain = null;
/* 218 */     InputStream in = null;
/* 219 */     if (url != null)
/*     */     {
/*     */       try
/*     */       {
/* 223 */         in = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(url)
/*     */         {
/*     */           public Object run() throws Exception
/*     */           {
/* 227 */             return this.val$url.openStream();
/*     */           }
/*     */         });
/*     */       }
/*     */       catch (PrivilegedActionException e) {
/* 233 */         throw new ClassNotFoundException(name, e);
/*     */       }
/* 235 */       String urlstring = url.toExternalForm();
/* 236 */       URL urlCS = url;
/* 237 */       if (urlstring.startsWith("jar:"))
/*     */       {
/* 239 */         int i = urlstring.indexOf('!');
/* 240 */         String cs = urlstring.substring(4, i);
/* 241 */         urlCS = new URL(cs);
/*     */       }
/*     */       else
/*     */       {
/* 245 */         int i = urlstring.indexOf(classFileName);
/* 246 */         if (i != -1)
/*     */         {
/* 248 */           String cs = urlstring.substring(0, i);
/* 249 */           urlCS = new URL(cs);
/*     */         }
/*     */       }
/* 252 */       CodeSource codeSource = new CodeSource(urlCS, (Certificate[])null);
/* 253 */       protectionDomain = new ProtectionDomain(codeSource, null, this, null);
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 262 */         in = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(classFileName)
/*     */         {
/*     */           public Object run() throws Exception
/*     */           {
/* 266 */             String tmpdir = System.getProperty("java.io.tmpdir");
/* 267 */             File aopdynclasses = new File(tmpdir, "aopdynclasses");
/* 268 */             File classFile = new File(aopdynclasses, this.val$classFileName);
/* 269 */             return new FileInputStream(classFile);
/*     */           }
/*     */         });
/*     */       }
/*     */       catch (PrivilegedActionException e) {
/* 275 */         throw new ClassNotFoundException(name, e);
/*     */       }
/*     */     }
/*     */ 
/* 279 */     byte[][] bufs = new byte[8][];
/* 280 */     int bufsize = 4096;
/*     */ 
/* 282 */     for (int i = 0; i < 8; i++)
/*     */     {
/* 284 */       bufs[i] = new byte[bufsize];
/* 285 */       int size = 0;
/* 286 */       int len = 0;
/*     */       do
/*     */       {
/* 289 */         len = in.read(bufs[i], size, bufsize - size);
/* 290 */         if (len >= 0) {
/* 291 */           size += len;
/*     */         }
/*     */         else {
/* 294 */           byte[] result = new byte[bufsize - 4096 + size];
/* 295 */           int s = 0;
/* 296 */           for (int j = 0; j < i; j++)
/*     */           {
/* 298 */             System.arraycopy(bufs[j], 0, result, s, s + 4096);
/* 299 */             s = s + s + 4096;
/*     */           }
/*     */ 
/* 302 */           System.arraycopy(bufs[i], 0, result, s, size);
/* 303 */           ClassBytes classBytes = new ClassBytes(null);
/* 304 */           classBytes.bytes = result;
/* 305 */           classBytes.protectionDomain = protectionDomain;
/* 306 */           return classBytes;
/*     */         }
/*     */       }
/* 309 */       while (size < bufsize);
/* 310 */       bufsize *= 2;
/*     */     }
/*     */ 
/* 313 */     throw new IOException("too much data loading class " + name);
/*     */   }
/*     */ 
/*     */   protected Class defineClassFromBytes(String name, ClassBytes bytes, boolean resolve)
/*     */   {
/* 326 */     definePackage(name);
/* 327 */     byte[] b = bytes.bytes;
/* 328 */     Class clazz = defineClass(name, b, 0, b.length, bytes.protectionDomain);
/* 329 */     if (resolve) resolveClass(clazz);
/* 330 */     return clazz;
/*     */   }
/*     */ 
/*     */   protected void definePackage(String className)
/*     */   {
/* 341 */     int i = className.lastIndexOf('.');
/* 342 */     if (i == -1) {
/* 343 */       return;
/*     */     }
/*     */     try
/*     */     {
/* 347 */       definePackage(className.substring(0, i), null, null, null, null, null, null, null);
/*     */     }
/*     */     catch (IllegalArgumentException alreadyDone)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Class loadClassLocally(String name)
/*     */     throws ClassNotFoundException
/*     */   {
/*     */     try
/*     */     {
/* 366 */       ClassBytes bytes = loadClassBytes(name);
/* 367 */       return defineClassFromBytes(name, bytes, true);
/*     */     }
/*     */     catch (Throwable ex) {
/*     */     }
/* 371 */     throw new ClassNotFoundException(name, ex);
/*     */   }
/*     */ 
/*     */   protected Class loadClassByDelegation(String name)
/*     */     throws ClassNotFoundException
/*     */   {
/* 386 */     if ((name.startsWith("java.")) || (name.startsWith("javax.")) || (name.startsWith("sun.")) || (name.startsWith("com.sun.")) || (name.startsWith("org.apache.xerces.")) || (name.startsWith("org.xml.sax.")) || (name.startsWith("org.w3c.dom.")))
/*     */     {
/* 390 */       return getParent().loadClass(name);
/*     */     }
/* 392 */     return null;
/*     */   }
/*     */ 
/*     */   protected synchronized void install()
/*     */   {
/*     */     try
/*     */     {
/* 404 */       Class clazz = loadClassLocally("org.jboss.aop.AspectManager");
/* 405 */       Class[] transformSig = { ClassLoader.class, String.class, Class.class, ProtectionDomain.class, [B.class };
/*     */ 
/* 407 */       this.transform = clazz.getMethod("transform", transformSig);
/* 408 */       this.instance = clazz.getMethod("instance", new Class[0]);
/*     */ 
/* 411 */       clazz = loadClassLocally("org.jboss.aop.AspectXmlLoader");
/* 412 */       this.deployXML = clazz.getMethod("deployXML", new Class[] { URL.class });
/*     */ 
/* 484 */       this.state = 1;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 488 */       t.printStackTrace();
/* 489 */       throw new Error("Error initializing system classloader", t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected synchronized void initialize()
/*     */   {
/* 499 */     if (this.state != 1)
/* 500 */       return;
/* 501 */     this.state = 2;
/*     */ 
/* 504 */     Thread.currentThread().setContextClassLoader(this);
/*     */     try
/*     */     {
/*     */       try
/*     */       {
/* 512 */         System.setProperty("jboss.aop.optimized", "false");
/* 513 */         this.aspectManager = this.instance.invoke(null, new Object[0]);
/*     */       }
/*     */       catch (InvocationTargetException ite)
/*     */       {
/* 517 */         throw ite.getCause();
/*     */       }
/* 519 */       this.state = 3;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 523 */       t.printStackTrace();
/* 524 */       throw new Error("Error installing aspect manager", t);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 530 */       Enumeration enumeration = getParent().getResources("META-INF/jboss-aop.xml");
/* 531 */       while (enumeration.hasMoreElements())
/*     */       {
/* 533 */         URL url = (URL)enumeration.nextElement();
/* 534 */         this.deployXML.invoke(null, new Object[] { url });
/*     */       }
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 539 */       t.printStackTrace();
/* 540 */       throw new Error("Error deploying aop configrations", t);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class ClassBytes
/*     */   {
/*     */     public ProtectionDomain protectionDomain;
/*     */     public byte[] bytes;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.standalone.SystemClassLoader
 * JD-Core Version:    0.6.0
 */