/*    */ package org.jboss.aop.standalone;
/*    */ 
/*    */ import java.lang.instrument.ClassFileTransformer;
/*    */ import java.lang.instrument.IllegalClassFormatException;
/*    */ import java.security.ProtectionDomain;
/*    */ import org.jboss.aop.AspectManager;
/*    */ 
/*    */ public class AOPTransformer
/*    */   implements ClassFileTransformer
/*    */ {
/*    */   public boolean isNonAdvisableClassName(String classname)
/*    */   {
/* 40 */     return (classname.startsWith("org.jboss.aop")) || (classname.endsWith("$aop")) || (classname.startsWith("javassist")) || (classname.startsWith("org.jboss.util.")) || (classname.startsWith("gnu.trove.")) || (classname.startsWith("EDU.oswego.cs.dl.util.concurrent.")) || (classname.startsWith("org.apache.crimson")) || (classname.startsWith("org.apache.xalan")) || (classname.startsWith("org.apache.xml")) || (classname.startsWith("org.apache.xpath")) || (classname.startsWith("org.ietf.")) || (classname.startsWith("org.omg.")) || (classname.startsWith("org.w3c.")) || (classname.startsWith("org.xml.sax.")) || (classname.startsWith("sunw.")) || (classname.startsWith("sun.")) || (classname.startsWith("java.")) || (classname.startsWith("javax.")) || (classname.startsWith("com.sun.")) || (classname.startsWith("$Proxy"));
/*    */   }
/*    */ 
/*    */   public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer)
/*    */     throws IllegalClassFormatException
/*    */   {
/* 66 */     className = className.replace('/', '.');
/*    */     try
/*    */     {
/* 69 */       if ((classBeingRedefined != null) || (isNonAdvisableClassName(className)))
/*    */       {
/* 71 */         arrayOfByte = null;
/*    */         return arrayOfByte;
/*    */       }
/* 73 */       byte[] arrayOfByte = aspectTransform(className, loader, classBeingRedefined, protectionDomain, classfileBuffer);
/*    */       return arrayOfByte;
/*    */     } finally {
/*    */     }
/* 76 */     throw localObject;
/*    */   }
/*    */ 
/*    */   private byte[] aspectTransform(String className, ClassLoader loader, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer)
/*    */   {
/*    */     try
/*    */     {
/* 85 */       return AspectManager.instance(loader).transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
/*    */     }
/*    */     catch (Exception e) {
/*    */     }
/* 89 */     throw new RuntimeException(e);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.standalone.AOPTransformer
 * JD-Core Version:    0.6.0
 */