/*      */ package org.jboss.aop.reflection;
/*      */ 
/*      */ import gnu.trove.TLongObjectHashMap;
/*      */ import java.lang.reflect.Constructor;
/*      */ import java.lang.reflect.Field;
/*      */ import java.lang.reflect.Method;
/*      */ import java.lang.reflect.Modifier;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.security.PrivilegedActionException;
/*      */ import java.security.PrivilegedExceptionAction;
/*      */ import java.util.ArrayList;
/*      */ import java.util.HashMap;
/*      */ import java.util.Iterator;
/*      */ import java.util.regex.Matcher;
/*      */ import java.util.regex.Pattern;
/*      */ import org.jboss.aop.Advised;
/*      */ import org.jboss.aop.AspectManager;
/*      */ import org.jboss.aop.ClassAdvisor;
/*      */ import org.jboss.aop.ConByConInfo;
/*      */ import org.jboss.aop.ConByMethodInfo;
/*      */ import org.jboss.aop.ConstructorInfo;
/*      */ import org.jboss.aop.FieldInfo;
/*      */ import org.jboss.aop.MethodByConInfo;
/*      */ import org.jboss.aop.MethodByMethodInfo;
/*      */ import org.jboss.aop.instrument.Untransformable;
/*      */ import org.jboss.aop.joinpoint.Invocation;
/*      */ import org.jboss.aop.joinpoint.MethodCalledByConstructorInvocation;
/*      */ import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
/*      */ import org.jboss.aop.util.MethodHashing;
/*      */ 
/*      */ public class ReflectionAspect
/*      */ {
/*   78 */   private static Pattern fieldGetPattern = Pattern.compile("get(|Boolean|Byte|Char|Double|Float|Int|Long|Short)?");
/*      */ 
/*   81 */   private static Pattern fieldSetPattern = Pattern.compile("set(|Boolean|Byte|Char|Double|Float|Int|Long|Short)?");
/*      */ 
/*   84 */   private static Pattern accessMethodPattern = Pattern.compile("access[$](\\d)+");
/*      */ 
/*      */   public Object interceptNewInstance(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  106 */     Method reflectionMethod = invocation.getCalledMethod();
/*  107 */     Object targetObject = invocation.getTargetObject();
/*  108 */     Object[] args = invocation.getArguments();
/*      */ 
/*  110 */     return interceptNewInstance(invocation, reflectionMethod, targetObject, args);
/*      */   }
/*      */ 
/*      */   public Object interceptNewInstance(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  125 */     Method reflectionMethod = invocation.getCalledMethod();
/*  126 */     Object targetObject = invocation.getTargetObject();
/*  127 */     Object[] args = invocation.getArguments();
/*      */ 
/*  129 */     return interceptNewInstance(invocation, reflectionMethod, targetObject, args);
/*      */   }
/*      */ 
/*      */   public Object interceptMethodInvoke(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  145 */     Method reflectionMethod = invocation.getCalledMethod();
/*  146 */     Object targetObject = invocation.getTargetObject();
/*  147 */     Object[] args = invocation.getArguments();
/*      */ 
/*  149 */     return interceptMethodInvoke(invocation, reflectionMethod, targetObject, args);
/*      */   }
/*      */ 
/*      */   public Object interceptMethodInvoke(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  164 */     Method reflectionMethod = invocation.getCalledMethod();
/*  165 */     Object targetObject = invocation.getTargetObject();
/*  166 */     Object[] args = invocation.getArguments();
/*      */ 
/*  168 */     return interceptMethodInvoke(invocation, reflectionMethod, targetObject, args);
/*      */   }
/*      */ 
/*      */   public Object interceptFieldSet(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  184 */     Method reflectionMethod = invocation.getCalledMethod();
/*  185 */     Object targetObject = invocation.getTargetObject();
/*  186 */     Object[] args = invocation.getArguments();
/*      */ 
/*  188 */     return interceptFieldSet(invocation, reflectionMethod, targetObject, args);
/*      */   }
/*      */ 
/*      */   public Object interceptFieldSet(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  203 */     Method reflectionMethod = invocation.getCalledMethod();
/*  204 */     Object targetObject = invocation.getTargetObject();
/*  205 */     Object[] args = invocation.getArguments();
/*      */ 
/*  207 */     return interceptFieldSet(invocation, reflectionMethod, targetObject, args);
/*      */   }
/*      */ 
/*      */   public Object interceptFieldGet(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  222 */     Method reflectionMethod = invocation.getCalledMethod();
/*  223 */     Object targetObject = invocation.getTargetObject();
/*  224 */     Object[] args = invocation.getArguments();
/*      */ 
/*  226 */     return interceptFieldGet(invocation, reflectionMethod, targetObject, args);
/*      */   }
/*      */ 
/*      */   public Object interceptFieldGet(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  243 */     Method reflectionMethod = invocation.getCalledMethod();
/*  244 */     Object targetObject = invocation.getTargetObject();
/*  245 */     Object[] args = invocation.getArguments();
/*      */ 
/*  247 */     return interceptFieldGet(invocation, reflectionMethod, targetObject, args);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredMethods(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  264 */     Object targetObject = invocation.getTargetObject();
/*  265 */     return interceptGetDeclaredMethods((Class)targetObject);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredMethods(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  281 */     Object targetObject = invocation.getTargetObject();
/*  282 */     return interceptGetDeclaredMethods((Class)targetObject);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredMethod(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  298 */     Object targetObject = invocation.getTargetObject();
/*  299 */     Object[] args = invocation.getArguments();
/*  300 */     return interceptGetDeclaredMethod((Class)targetObject, args);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredMethod(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  316 */     Object targetObject = invocation.getTargetObject();
/*  317 */     Object[] args = invocation.getArguments();
/*  318 */     return interceptGetDeclaredMethod((Class)targetObject, args);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetMethods(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  334 */     Object targetObject = invocation.getTargetObject();
/*  335 */     return interceptGetMethods((Class)targetObject);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetMethods(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  351 */     Object targetObject = invocation.getTargetObject();
/*  352 */     return interceptGetMethods((Class)targetObject);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetMethod(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  368 */     Object targetObject = invocation.getTargetObject();
/*  369 */     Object[] args = invocation.getArguments();
/*  370 */     return interceptGetMethod((Class)targetObject, args);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetMethod(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  386 */     Object targetObject = invocation.getTargetObject();
/*  387 */     Object[] args = invocation.getArguments();
/*  388 */     return interceptGetMethod((Class)targetObject, args);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetInterfaces(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  404 */     Object targetObject = invocation.getTargetObject();
/*  405 */     return interceptGetInterfaces((Class)targetObject);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetInterfaces(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  421 */     Object targetObject = invocation.getTargetObject();
/*  422 */     return interceptGetInterfaces((Class)targetObject);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredClasses(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  437 */     Object targetObject = invocation.getTargetObject();
/*  438 */     return interceptGetDeclaredClasses((Class)targetObject);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredClasses(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  453 */     Object targetObject = invocation.getTargetObject();
/*  454 */     return interceptGetDeclaredClasses((Class)targetObject);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetClasses(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  470 */     Object targetObject = invocation.getTargetObject();
/*  471 */     return interceptGetClasses((Class)targetObject);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetClasses(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  486 */     Object targetObject = invocation.getTargetObject();
/*  487 */     return interceptGetClasses((Class)targetObject);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredFields(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  502 */     Object targetObject = invocation.getTargetObject();
/*  503 */     return interceptGetDeclaredFields((Class)targetObject);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredFields(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  518 */     Object targetObject = invocation.getTargetObject();
/*  519 */     return interceptGetDeclaredFields((Class)targetObject);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredField(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  534 */     Object targetObject = invocation.getTargetObject();
/*  535 */     Object[] args = invocation.getArguments();
/*  536 */     return interceptGetDeclaredField((Class)targetObject, args);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredField(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  550 */     Object targetObject = invocation.getTargetObject();
/*  551 */     Object[] args = invocation.getArguments();
/*  552 */     return interceptGetDeclaredField((Class)targetObject, args);
/*      */   }
/*      */ 
/*      */   public final Object interceptGetFields(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  568 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   public final Object interceptGetFields(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  584 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredConstructors(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  600 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredConstructors(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  616 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredConstructor(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  632 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   public final Object interceptGetDeclaredConstructor(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  648 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   public final Object interceptGetConstructors(MethodCalledByConstructorInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  664 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   public final Object interceptGetConstructors(MethodCalledByMethodInvocation invocation)
/*      */     throws Throwable
/*      */   {
/*  680 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   protected Object interceptConstructor(Invocation invocation, Constructor constructor, Object[] args)
/*      */     throws Throwable
/*      */   {
/*  707 */     return invokeOriginalChainIfExists(invocation, constructor, args);
/*      */   }
/*      */ 
/*      */   protected Object interceptFieldRead(Invocation invocation, Field field, Object instance)
/*      */     throws Throwable
/*      */   {
/*  723 */     return invokeOriginalChainIfExists(invocation, field, instance);
/*      */   }
/*      */ 
/*      */   protected Object interceptFieldWrite(Invocation invocation, Field field, Object instance, Object arg)
/*      */     throws Throwable
/*      */   {
/*  740 */     return invokeOriginalChainIfExists(invocation, field, instance, arg);
/*      */   }
/*      */ 
/*      */   protected Object interceptMethod(Invocation invocation, Method method, Object instance, Object[] args)
/*      */     throws Throwable
/*      */   {
/*  758 */     return invokeOriginalChainIfExists(invocation, method, instance, args);
/*      */   }
/*      */ 
/*      */   private Object interceptNewInstance(Invocation invocation, Method reflectionMethod, Object targetObject, Object[] args)
/*      */     throws Throwable
/*      */   {
/*  769 */     Class reflectionClass = targetObject.getClass();
/*      */ 
/*  771 */     if (reflectionClass.equals(Class.class))
/*      */     {
/*  775 */       Constructor constructor = ((Class)targetObject).getConstructor(new Class[0]);
/*  776 */       return interceptConstructor(invocation, constructor, args);
/*      */     }
/*  778 */     if (reflectionClass.equals(Constructor.class))
/*      */     {
/*  781 */       if (reflectionMethod.getName().equals("newInstance"))
/*      */       {
/*  787 */         int length = args.length;
/*      */         Object[] constructorArgs;
/*      */         Object[] constructorArgs;
/*  789 */         if (length < 1)
/*      */         {
/*  791 */           constructorArgs = new Object[0];
/*      */         }
/*      */         else
/*      */         {
/*  795 */           constructorArgs = (Object[])(Object[])args[0];
/*      */         }
/*      */ 
/*  798 */         Constructor constructor = (Constructor)targetObject;
/*  799 */         return interceptConstructor(invocation, constructor, constructorArgs);
/*      */       }
/*      */     }
/*      */ 
/*  803 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   private Object interceptMethodInvoke(Invocation invocation, Method reflectionMethod, Object targetObject, Object[] args)
/*      */     throws Throwable
/*      */   {
/*  811 */     Method method = (Method)invocation.getTargetObject();
/*  812 */     if (reflectionMethod.getName().equals("invoke"))
/*      */     {
/*  814 */       Object instance = args[0];
/*  815 */       return interceptMethod(invocation, method, instance, (Object[])(Object[])args[1]);
/*      */     }
/*  817 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   private Class[] interceptGetInterfaces(Class clazz)
/*      */   {
/*  822 */     Class[] interfaces = clazz.getInterfaces();
/*  823 */     ArrayList cleanedInterfaces = new ArrayList(interfaces.length);
/*      */ 
/*  825 */     for (int i = 0; i < interfaces.length; i++)
/*      */     {
/*  827 */       if (interfaces[i].equals(Advised.class))
/*      */         continue;
/*  829 */       cleanedInterfaces.add(interfaces[i]);
/*      */     }
/*      */ 
/*  833 */     return (Class[])(Class[])cleanedInterfaces.toArray(new Class[cleanedInterfaces.size()]);
/*      */   }
/*      */ 
/*      */   private Object interceptFieldSet(Invocation invocation, Method reflectionMethod, Object targetObject, Object[] args) throws Throwable
/*      */   {
/*  838 */     Field field = (Field)invocation.getTargetObject();
/*  839 */     Matcher m = fieldSetPattern.matcher(reflectionMethod.getName());
/*  840 */     if (m.matches())
/*      */     {
/*  842 */       Object instance = args[0];
/*  843 */       return interceptFieldWrite(invocation, field, instance, args[1]);
/*      */     }
/*  845 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   private Object interceptFieldGet(Invocation invocation, Method reflectionMethod, Object targetObject, Object[] args) throws Throwable
/*      */   {
/*  850 */     Field field = (Field)invocation.getTargetObject();
/*  851 */     Matcher m = fieldGetPattern.matcher(reflectionMethod.getName());
/*  852 */     if (m.matches())
/*      */     {
/*  854 */       Object instance = args[0];
/*  855 */       return interceptFieldRead(invocation, field, instance);
/*      */     }
/*  857 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   private Method[] interceptGetDeclaredMethods(Class clazz)
/*      */   {
/*  862 */     ClassAdvisor advisor = AspectManager.instance().getAdvisorIfAdvised(clazz);
/*      */ 
/*  864 */     if (advisor == null)
/*      */     {
/*  866 */       return getDeclaredMethods(clazz);
/*      */     }
/*      */ 
/*  870 */     Object[] advisedMethods = advisor.getAdvisedMethods().getValues();
/*      */ 
/*  872 */     ArrayList methods = new ArrayList(advisedMethods.length);
/*      */ 
/*  874 */     for (int i = 0; i < advisedMethods.length; i++)
/*      */     {
/*  876 */       Method m = (Method)advisedMethods[i];
/*  877 */       if ((!clazz.equals(m.getDeclaringClass())) || (!isNotAccessMethod(m)) || (!isNotJavassistWrappedMethod(m)))
/*      */         continue;
/*  879 */       methods.add(m);
/*      */     }
/*      */ 
/*  883 */     return (Method[])(Method[])methods.toArray(new Method[methods.size()]);
/*      */   }
/*      */ 
/*      */   private Method interceptGetDeclaredMethod(Class clazz, Object[] args)
/*      */     throws NoSuchMethodException
/*      */   {
/*  890 */     ClassAdvisor advisor = AspectManager.instance().getAdvisorIfAdvised(clazz);
/*  891 */     Method method = getDeclaredMethod(clazz, (String)args[0], (Class[])(Class[])args[1]);
/*      */ 
/*  893 */     if (advisor == null)
/*      */     {
/*  895 */       return method;
/*      */     }
/*      */ 
/*  899 */     Object[] advisedMethods = advisor.getAdvisedMethods().getValues();
/*      */ 
/*  901 */     for (int i = 0; i < advisedMethods.length; i++)
/*      */     {
/*  903 */       Method m = (Method)advisedMethods[i];
/*  904 */       if ((m.equals(method)) && (isNotAccessMethod(m)) && (isNotJavassistWrappedMethod(m)))
/*      */       {
/*  906 */         return method;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  911 */     throw new NoSuchMethodException();
/*      */   }
/*      */ 
/*      */   private boolean isNotAccessMethod(Method m)
/*      */   {
/*  926 */     if (Modifier.isStatic(m.getModifiers()))
/*      */     {
/*  928 */       Matcher match = accessMethodPattern.matcher(m.getName());
/*  929 */       if (match.matches())
/*      */       {
/*  931 */         return false;
/*      */       }
/*      */     }
/*      */ 
/*  935 */     return true;
/*      */   }
/*      */ 
/*      */   private boolean isNotJavassistWrappedMethod(Method m)
/*      */   {
/*  940 */     if ((Modifier.isPrivate(m.getModifiers())) && (!Modifier.isStatic(m.getModifiers())))
/*      */     {
/*  942 */       if (m.getName().startsWith("_added_m$"))
/*      */       {
/*  944 */         return false;
/*      */       }
/*      */     }
/*      */ 
/*  948 */     return true;
/*      */   }
/*      */ 
/*      */   private Method[] interceptGetMethods(Class clazz)
/*      */   {
/*  954 */     ArrayList methods = new ArrayList();
/*      */ 
/*  959 */     GetMethodsAlreadyFound methodsFound = new GetMethodsAlreadyFound();
/*      */ 
/*  961 */     while (clazz != null)
/*      */     {
/*  963 */       ClassAdvisor advisor = AspectManager.instance().getAdvisorIfAdvised(clazz);
/*      */       Object[] foundMethods;
/*      */       Object[] foundMethods;
/*  966 */       if (advisor == null)
/*      */       {
/*  968 */         foundMethods = getDeclaredMethods(clazz);
/*      */       }
/*      */       else
/*      */       {
/*  972 */         foundMethods = advisor.getAdvisedMethods().getValues();
/*      */       }
/*      */ 
/*  975 */       for (int i = 0; i < foundMethods.length; i++)
/*      */       {
/*  977 */         Method m = (Method)foundMethods[i];
/*  978 */         if ((!clazz.equals(m.getDeclaringClass())) || (!Modifier.isPublic(m.getModifiers()))) {
/*      */           continue;
/*      */         }
/*  981 */         if (methodsFound.existsMethod(m))
/*      */           continue;
/*  983 */         methods.add(m);
/*  984 */         methodsFound.addMethod(m);
/*      */       }
/*      */ 
/*  989 */       clazz = clazz.getSuperclass();
/*      */     }
/*      */ 
/*  992 */     return (Method[])(Method[])methods.toArray(new Method[methods.size()]);
/*      */   }
/*      */ 
/*      */   private Method interceptGetMethod(Class clazz, Object[] args) throws NoSuchMethodException
/*      */   {
/*  997 */     Method method = clazz.getMethod((String)args[0], (Class[])(Class[])args[1]);
/*  998 */     Class declaringClass = method.getDeclaringClass();
/*      */ 
/* 1000 */     while (clazz != null)
/*      */     {
/* 1003 */       if (clazz.equals(declaringClass))
/*      */       {
/* 1005 */         ClassAdvisor advisor = AspectManager.instance().getAdvisorIfAdvised(clazz);
/*      */ 
/* 1007 */         if (advisor == null)
/*      */         {
/* 1009 */           return method;
/*      */         }
/*      */ 
/* 1013 */         Object[] methods = advisor.getAdvisedMethods().getValues();
/*      */ 
/* 1015 */         for (int i = 0; i < methods.length; i++)
/*      */         {
/* 1017 */           Method m = (Method)methods[i];
/* 1018 */           if (m.equals(method))
/*      */           {
/* 1020 */             return method;
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1026 */       clazz = clazz.getSuperclass();
/*      */     }
/*      */ 
/* 1029 */     throw new NoSuchMethodException();
/*      */   }
/*      */ 
/*      */   private Field[] interceptGetDeclaredFields(Class clazz)
/*      */   {
/* 1035 */     ClassAdvisor advisor = AspectManager.instance().getAdvisorIfAdvised(clazz);
/*      */ 
/* 1037 */     if (advisor == null)
/*      */     {
/* 1039 */       return getDeclaredFields(clazz);
/*      */     }
/*      */ 
/* 1043 */     Field[] advisedFields = advisor.getAdvisedFields();
/*      */ 
/* 1045 */     ArrayList fields = new ArrayList(advisedFields.length);
/*      */ 
/* 1047 */     for (int i = 0; i < advisedFields.length; i++)
/*      */     {
/* 1049 */       Field f = advisedFields[i];
/* 1050 */       if (!clazz.equals(f.getDeclaringClass()))
/*      */         continue;
/* 1052 */       fields.add(f);
/*      */     }
/*      */ 
/* 1056 */     return (Field[])(Field[])fields.toArray(new Field[fields.size()]);
/*      */   }
/*      */ 
/*      */   private Class[] interceptGetClasses(Class clazz)
/*      */     throws Throwable
/*      */   {
/* 1067 */     Class[] classes = clazz.getClasses();
/* 1068 */     return cleanClasses(classes);
/*      */   }
/*      */ 
/*      */   private Class[] interceptGetDeclaredClasses(Class clazz) throws Throwable
/*      */   {
/* 1073 */     Class[] classes = getDeclaredClasses(clazz);
/* 1074 */     return cleanClasses(classes);
/*      */   }
/*      */ 
/*      */   private Class[] cleanClasses(Class[] classes)
/*      */   {
/* 1079 */     ArrayList clazzes = new ArrayList();
/*      */ 
/* 1081 */     for (int i = 0; i < classes.length; i++)
/*      */     {
/* 1083 */       Class innerClass = classes[i];
/*      */ 
/* 1086 */       Class[] interfaces = classes[i].getInterfaces();
/* 1087 */       boolean implUntransformable = false;
/*      */ 
/* 1089 */       for (int j = 0; j < interfaces.length; j++)
/*      */       {
/* 1091 */         if (!interfaces[j].equals(Untransformable.class))
/*      */           continue;
/* 1093 */         implUntransformable = true;
/* 1094 */         break;
/*      */       }
/*      */ 
/* 1098 */       if (implUntransformable) {
/*      */         continue;
/*      */       }
/* 1101 */       boolean isInvocationImpl = false;
/* 1102 */       Class superclass = innerClass.getSuperclass();
/* 1103 */       while (superclass != null)
/*      */       {
/* 1106 */         interfaces = classes[i].getInterfaces();
/*      */ 
/* 1108 */         for (int j = 0; j < interfaces.length; j++)
/*      */         {
/* 1110 */           if (!interfaces[j].equals(Invocation.class))
/*      */             continue;
/* 1112 */           isInvocationImpl = true;
/* 1113 */           break;
/*      */         }
/*      */ 
/* 1116 */         superclass = superclass.getSuperclass();
/*      */       }
/*      */ 
/* 1119 */       if (isInvocationImpl)
/*      */         continue;
/* 1121 */       clazzes.add(innerClass);
/*      */     }
/*      */ 
/* 1126 */     return (Class[])(Class[])clazzes.toArray(new Class[clazzes.size()]);
/*      */   }
/*      */ 
/*      */   private Field interceptGetDeclaredField(Class clazz, Object[] args)
/*      */     throws NoSuchFieldException
/*      */   {
/* 1132 */     ClassAdvisor advisor = AspectManager.instance().getAdvisorIfAdvised(clazz);
/* 1133 */     Field field = getDeclaredField(clazz, (String)args[0]);
/*      */ 
/* 1135 */     if (advisor == null)
/*      */     {
/* 1137 */       return field;
/*      */     }
/*      */ 
/* 1141 */     Field[] advisedFields = advisor.getAdvisedFields();
/*      */ 
/* 1143 */     for (int i = 0; i < advisedFields.length; i++)
/*      */     {
/* 1145 */       Field f = advisedFields[i];
/* 1146 */       if (f.equals(field))
/*      */       {
/* 1148 */         return field;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1153 */     throw new NoSuchFieldException();
/*      */   }
/*      */ 
/*      */   private Object invokeOriginalChainIfExists(Invocation invocation, Constructor constructor, Object[] args)
/*      */     throws Throwable
/*      */   {
/* 1166 */     if ((invocation instanceof MethodCalledByConstructorInvocation))
/*      */     {
/* 1168 */       MethodCalledByConstructorInvocation inv = (MethodCalledByConstructorInvocation)invocation;
/* 1169 */       Constructor callingCon = inv.getCalling();
/* 1170 */       Class callingClass = callingCon.getDeclaringClass();
/* 1171 */       if (isAdvised(callingClass))
/*      */       {
/* 1173 */         ClassAdvisor advisor = AspectManager.instance().getAdvisor(callingClass);
/* 1174 */         if (advisor != null)
/*      */         {
/* 1176 */           int index = advisor.getConstructorIndex(callingCon);
/* 1177 */           if (index >= 0)
/*      */           {
/* 1179 */             HashMap calledClassesMap = advisor.getConCalledByConInterceptors()[index];
/* 1180 */             if (calledClassesMap != null)
/*      */             {
/* 1182 */               TLongObjectHashMap calledCons = (TLongObjectHashMap)calledClassesMap.get(constructor.getDeclaringClass().getName());
/* 1183 */               if (calledCons != null)
/*      */               {
/* 1185 */                 long calledHash = MethodHashing.constructorHash(constructor);
/* 1186 */                 ConByConInfo info = (ConByConInfo)calledCons.get(calledHash);
/*      */ 
/* 1188 */                 if ((info != null) && (info.hasAdvices()))
/*      */                 {
/* 1190 */                   return advisor.invokeConCalledByCon(info, inv.getCallingObject(), args);
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 1198 */     else if ((invocation instanceof MethodCalledByMethodInvocation))
/*      */     {
/* 1200 */       MethodCalledByMethodInvocation inv = (MethodCalledByMethodInvocation)invocation;
/* 1201 */       Method callingMethod = inv.getCallingMethod();
/* 1202 */       if (isAdvised(callingMethod.getDeclaringClass()))
/*      */       {
/* 1204 */         ClassAdvisor advisor = AspectManager.instance().getAdvisor(callingMethod.getDeclaringClass());
/* 1205 */         if (advisor != null)
/*      */         {
/* 1207 */           long callingMethodHash = MethodHashing.calculateHash(callingMethod);
/* 1208 */           long calledHash = MethodHashing.constructorHash(constructor);
/*      */ 
/* 1210 */           HashMap calledClassesMap = (HashMap)advisor.getConCalledByMethodInterceptors().get(callingMethodHash);
/* 1211 */           if (calledClassesMap != null)
/*      */           {
/* 1213 */             TLongObjectHashMap calledCons = (TLongObjectHashMap)calledClassesMap.get(constructor.getDeclaringClass().getName());
/* 1214 */             if (calledCons != null)
/*      */             {
/* 1217 */               ConByMethodInfo info = (ConByMethodInfo)calledCons.get(calledHash);
/*      */ 
/* 1219 */               if ((info != null) && (info.hasAdvices()))
/*      */               {
/* 1222 */                 return advisor.invokeConCalledByMethod(info, inv.getCallingObject(), args);
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1231 */     Class calledClass = constructor.getDeclaringClass();
/* 1232 */     if (isAdvised(calledClass))
/*      */     {
/* 1234 */       ClassAdvisor advisor = AspectManager.instance().getAdvisor(constructor.getDeclaringClass());
/*      */ 
/* 1236 */       if ((advisor != null) && (advisor.hasAspects()))
/*      */       {
/* 1238 */         int index = advisor.getConstructorIndex(constructor);
/* 1239 */         if (index >= 0)
/*      */         {
/* 1241 */           ConstructorInfo jp = advisor.getConstructorInfos()[index];
/* 1242 */           return jp.getWrapper().invoke(null, args);
/*      */         }
/*      */       }
/*      */     }
/* 1246 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   private Object invokeOriginalChainIfExists(Invocation invocation, Field field, Object targetObject)
/*      */     throws Throwable
/*      */   {
/* 1261 */     ClassAdvisor advisor = AspectManager.instance().getAdvisor(field.getDeclaringClass());
/*      */ 
/* 1263 */     Class calledClass = field.getDeclaringClass();
/* 1264 */     if (isAdvised(calledClass))
/*      */     {
/* 1266 */       if ((advisor != null) && (advisor.hasAspects()))
/*      */       {
/* 1268 */         int index = advisor.getFieldIndex(field);
/* 1269 */         if (index >= 0)
/*      */         {
/* 1271 */           FieldInfo jp = advisor.getFieldReadInfos()[index];
/* 1272 */           return jp.getWrapper().invoke(null, new Object[] { targetObject });
/*      */         }
/*      */       }
/*      */     }
/* 1276 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   private Object invokeOriginalChainIfExists(Invocation invocation, Field field, Object targetObject, Object value)
/*      */     throws Throwable
/*      */   {
/* 1290 */     ClassAdvisor advisor = AspectManager.instance().getAdvisor(field.getDeclaringClass());
/*      */ 
/* 1292 */     Class calledClass = field.getDeclaringClass();
/* 1293 */     if (isAdvised(calledClass))
/*      */     {
/* 1295 */       if ((advisor != null) && (advisor.hasAspects()))
/*      */       {
/* 1297 */         int index = advisor.getFieldIndex(field);
/* 1298 */         if (index >= 0)
/*      */         {
/* 1300 */           FieldInfo jp = advisor.getFieldWriteInfos()[index];
/* 1301 */           return jp.getWrapper().invoke(null, new Object[] { targetObject, value });
/*      */         }
/*      */       }
/*      */     }
/* 1305 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   private Object invokeOriginalChainIfExists(Invocation invocation, Method method, Object targetObject, Object[] args)
/*      */     throws Throwable
/*      */   {
/* 1317 */     if ((invocation instanceof MethodCalledByConstructorInvocation))
/*      */     {
/* 1319 */       MethodCalledByConstructorInvocation inv = (MethodCalledByConstructorInvocation)invocation;
/* 1320 */       Constructor callingCon = inv.getCalling();
/* 1321 */       Class callingClass = callingCon.getDeclaringClass();
/* 1322 */       if (isAdvised(callingClass))
/*      */       {
/* 1324 */         ClassAdvisor advisor = AspectManager.instance().getAdvisor(callingClass);
/* 1325 */         if (advisor != null)
/*      */         {
/* 1327 */           int index = advisor.getConstructorIndex(callingCon);
/* 1328 */           if (index >= 0)
/*      */           {
/* 1330 */             HashMap calledClassesMap = advisor.getMethodCalledByConInterceptors()[index];
/* 1331 */             if (calledClassesMap != null)
/*      */             {
/* 1333 */               TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClassesMap.get(method.getDeclaringClass().getName());
/* 1334 */               if (calledMethods != null)
/*      */               {
/* 1336 */                 long calledHash = MethodHashing.calculateHash(method);
/*      */ 
/* 1338 */                 MethodByConInfo info = (MethodByConInfo)calledMethods.get(calledHash);
/*      */ 
/* 1340 */                 if ((info != null) && (info.hasAdvices()))
/*      */                 {
/* 1343 */                   return advisor.invokeConstructorCaller(info, inv.getCallingObject(), targetObject, args);
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 1351 */     else if ((invocation instanceof MethodCalledByMethodInvocation))
/*      */     {
/* 1353 */       MethodCalledByMethodInvocation inv = (MethodCalledByMethodInvocation)invocation;
/* 1354 */       Method callingMethod = inv.getCallingMethod();
/* 1355 */       if (isAdvised(callingMethod.getDeclaringClass()))
/*      */       {
/* 1357 */         ClassAdvisor advisor = AspectManager.instance().getAdvisor(callingMethod.getDeclaringClass());
/* 1358 */         if (advisor != null)
/*      */         {
/* 1360 */           long callingMethodHash = MethodHashing.calculateHash(callingMethod);
/* 1361 */           long calledHash = MethodHashing.calculateHash(method);
/*      */ 
/* 1363 */           HashMap calledClassesMap = (HashMap)advisor.getMethodCalledByMethodInterceptors().get(callingMethodHash);
/* 1364 */           if (calledClassesMap != null)
/*      */           {
/* 1366 */             TLongObjectHashMap calledMethods = (TLongObjectHashMap)calledClassesMap.get(method.getDeclaringClass().getName());
/* 1367 */             if (calledMethods != null)
/*      */             {
/* 1370 */               MethodByMethodInfo info = (MethodByMethodInfo)calledMethods.get(calledHash);
/*      */ 
/* 1372 */               if ((info != null) && (info.hasAdvices()))
/*      */               {
/* 1375 */                 return advisor.invokeCaller(info, inv.getCallingObject(), targetObject, args);
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1385 */     return invocation.invokeNext();
/*      */   }
/*      */ 
/*      */   private boolean isAdvised(Class clazz)
/*      */   {
/* 1390 */     Class[] interfaces = clazz.getInterfaces();
/*      */ 
/* 1392 */     for (int i = 0; i < interfaces.length; i++)
/*      */     {
/* 1394 */       if (interfaces[i].equals(Advised.class))
/*      */       {
/* 1396 */         return true;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1401 */     Class superClass = clazz.getSuperclass();
/* 1402 */     if (superClass != null)
/*      */     {
/* 1404 */       return isAdvised(superClass);
/*      */     }
/*      */ 
/* 1407 */     return false;
/*      */   }
/*      */ 
/*      */   private static Method[] getDeclaredMethods(Class clazz)
/*      */   {
/* 1587 */     if (System.getSecurityManager() == null)
/*      */     {
/* 1589 */       return SecurityAction.NON_PRIVILEGED.getDeclaredMethods(clazz);
/*      */     }
/*      */ 
/* 1593 */     return SecurityAction.PRIVILEGED.getDeclaredMethods(clazz);
/*      */   }
/*      */ 
/*      */   private static Field[] getDeclaredFields(Class clazz)
/*      */   {
/* 1599 */     if (System.getSecurityManager() == null)
/*      */     {
/* 1601 */       return SecurityAction.NON_PRIVILEGED.getDeclaredFields(clazz);
/*      */     }
/*      */ 
/* 1605 */     return SecurityAction.PRIVILEGED.getDeclaredFields(clazz);
/*      */   }
/*      */ 
/*      */   private static Class[] getDeclaredClasses(Class clazz)
/*      */   {
/* 1611 */     if (System.getSecurityManager() == null)
/*      */     {
/* 1613 */       return SecurityAction.NON_PRIVILEGED.getDeclaredClasses(clazz);
/*      */     }
/*      */ 
/* 1617 */     return SecurityAction.PRIVILEGED.getDeclaredClasses(clazz);
/*      */   }
/*      */ 
/*      */   private static Field getDeclaredField(Class clazz, String name)
/*      */     throws NoSuchFieldException
/*      */   {
/* 1623 */     if (System.getSecurityManager() == null)
/*      */     {
/* 1625 */       return SecurityAction.NON_PRIVILEGED.getDeclaredField(clazz, name);
/*      */     }
/*      */ 
/* 1629 */     return SecurityAction.PRIVILEGED.getDeclaredField(clazz, name);
/*      */   }
/*      */ 
/*      */   private static Method getDeclaredMethod(Class clazz, String name, Class[] paramTypes)
/*      */     throws NoSuchMethodException
/*      */   {
/* 1635 */     if (System.getSecurityManager() == null)
/*      */     {
/* 1637 */       return SecurityAction.NON_PRIVILEGED.getDeclaredMethod(clazz, name, paramTypes);
/*      */     }
/*      */ 
/* 1641 */     return SecurityAction.PRIVILEGED.getDeclaredMethod(clazz, name, paramTypes);
/*      */   }
/*      */ 
/*      */   private static abstract interface SecurityAction
/*      */   {
/* 1478 */     public static final SecurityAction NON_PRIVILEGED = new SecurityAction()
/*      */     {
/*      */       public Field[] getDeclaredFields(Class clazz)
/*      */       {
/* 1482 */         return clazz.getDeclaredFields();
/*      */       }
/*      */ 
/*      */       public Method[] getDeclaredMethods(Class clazz)
/*      */       {
/* 1487 */         return clazz.getDeclaredMethods();
/*      */       }
/*      */ 
/*      */       public Class[] getDeclaredClasses(Class clazz)
/*      */       {
/* 1492 */         return clazz.getDeclaredClasses();
/*      */       }
/*      */ 
/*      */       public Field getDeclaredField(Class clazz, String name) throws NoSuchFieldException
/*      */       {
/* 1497 */         return clazz.getDeclaredField(name);
/*      */       }
/*      */ 
/*      */       public Method getDeclaredMethod(Class clazz, String name, Class[] paramTypes) throws NoSuchMethodException
/*      */       {
/* 1502 */         return clazz.getDeclaredMethod(name, paramTypes);
/*      */       }
/* 1478 */     };
/*      */ 
/* 1507 */     public static final SecurityAction PRIVILEGED = new SecurityAction()
/*      */     {
/*      */       public Field[] getDeclaredFields(Class clazz)
/*      */       {
/* 1511 */         return (Field[])(Field[])AccessController.doPrivileged(new PrivilegedAction(clazz)
/*      */         {
/*      */           public Object run() {
/* 1514 */             return this.val$clazz.getDeclaredFields();
/*      */           }
/*      */         });
/*      */       }
/*      */ 
/*      */       public Method[] getDeclaredMethods(Class clazz) {
/* 1521 */         return (Method[])(Method[])AccessController.doPrivileged(new PrivilegedAction(clazz)
/*      */         {
/*      */           public Object run() {
/* 1524 */             return this.val$clazz.getDeclaredMethods();
/*      */           }
/*      */         });
/*      */       }
/*      */ 
/*      */       public Class[] getDeclaredClasses(Class clazz) {
/* 1531 */         return (Class[])(Class[])AccessController.doPrivileged(new PrivilegedAction(clazz)
/*      */         {
/*      */           public Object run() {
/* 1534 */             return this.val$clazz.getDeclaredClasses();
/*      */           } } );
/*      */       }
/*      */ 
/*      */       public Field getDeclaredField(Class clazz, String name) throws NoSuchFieldException {
/*      */         Exception ex;
/*      */         try {
/* 1543 */           return (Field)AccessController.doPrivileged(new PrivilegedExceptionAction(clazz, name)
/*      */           {
/*      */             public Object run() throws Exception {
/* 1546 */               return this.val$clazz.getDeclaredField(this.val$name);
/*      */             }
/*      */           });
/*      */         }
/*      */         catch (PrivilegedActionException e) {
/* 1552 */           ex = e.getException();
/* 1553 */           if ((ex instanceof NoSuchFieldException))
/*      */           {
/* 1555 */             throw ((NoSuchFieldException)ex);
/*      */           }
/*      */         }
/* 1557 */         throw new RuntimeException(ex);
/*      */       }
/*      */ 
/*      */       public Method getDeclaredMethod(Class clazz, String name, Class[] paramTypes) throws NoSuchMethodException
/*      */       {
/*      */         Exception ex;
/*      */         try {
/* 1565 */           return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(clazz, name, paramTypes)
/*      */           {
/*      */             public Object run() throws Exception {
/* 1568 */               return this.val$clazz.getDeclaredMethod(this.val$name, this.val$paramTypes);
/*      */             }
/*      */           });
/*      */         }
/*      */         catch (PrivilegedActionException e) {
/* 1574 */           ex = e.getException();
/* 1575 */           if ((ex instanceof NoSuchMethodException))
/*      */           {
/* 1577 */             throw ((NoSuchMethodException)ex);
/*      */           }
/*      */         }
/* 1579 */         throw new RuntimeException(ex);
/*      */       }
/* 1507 */     };
/*      */ 
/*      */     public abstract Method[] getDeclaredMethods(Class paramClass);
/*      */ 
/*      */     public abstract Field[] getDeclaredFields(Class paramClass);
/*      */ 
/*      */     public abstract Class[] getDeclaredClasses(Class paramClass);
/*      */ 
/*      */     public abstract Field getDeclaredField(Class paramClass, String paramString)
/*      */       throws NoSuchFieldException;
/*      */ 
/*      */     public abstract Method getDeclaredMethod(Class paramClass, String paramString, Class[] paramArrayOfClass)
/*      */       throws NoSuchMethodException;
/*      */   }
/*      */ 
/*      */   class GetMethodsAlreadyFound
/*      */   {
/* 1415 */     HashMap methodMap = new HashMap();
/*      */ 
/*      */     GetMethodsAlreadyFound() {
/*      */     }
/* 1419 */     public void addMethod(Method m) { String methodName = m.getName();
/* 1420 */       ArrayList methods = (ArrayList)this.methodMap.get(methodName);
/*      */ 
/* 1422 */       if (methods == null)
/*      */       {
/* 1424 */         methods = new ArrayList();
/* 1425 */         this.methodMap.put(methodName, methods);
/*      */       }
/*      */ 
/* 1428 */       methods.add(m);
/*      */     }
/*      */ 
/*      */     public boolean existsMethod(Method method)
/*      */     {
/* 1433 */       ArrayList methods = (ArrayList)this.methodMap.get(method.getName());
/*      */ 
/* 1435 */       if (methods == null)
/*      */       {
/* 1437 */         return false;
/*      */       }
/*      */ 
/* 1440 */       Class[] methodParamTypes = method.getParameterTypes();
/*      */ 
/* 1442 */       for (Iterator it = methods.iterator(); it.hasNext(); )
/*      */       {
/* 1444 */         Method found = (Method)it.next();
/* 1445 */         Class[] foundParamTypes = found.getParameterTypes();
/*      */ 
/* 1447 */         if (methodParamTypes.length == foundParamTypes.length)
/*      */         {
/* 1450 */           boolean same = true;
/* 1451 */           for (int i = 0; i < methodParamTypes.length; i++)
/*      */           {
/* 1453 */             if (methodParamTypes[i].equals(foundParamTypes[i]))
/*      */               continue;
/* 1455 */             same = false;
/*      */           }
/*      */ 
/* 1459 */           if (same)
/*      */           {
/* 1461 */             return true;
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 1466 */       return false;
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.reflection.ReflectionAspect
 * JD-Core Version:    0.6.0
 */