/*    */ package org.jboss.aop.proxy.container;
/*    */ 
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ 
/*    */ class SecurityActions
/*    */ {
/*    */   static ClassLoader getContextClassLoader()
/*    */   {
/* 48 */     if (System.getSecurityManager() == null) {
/* 49 */       return Thread.currentThread().getContextClassLoader();
/*    */     }
/* 51 */     return (ClassLoader)AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
/*    */   }
/*    */ 
/*    */   public static class GetContextClassLoaderAction
/*    */     implements PrivilegedAction<ClassLoader>
/*    */   {
/* 38 */     public static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();
/*    */ 
/*    */     public ClassLoader run()
/*    */     {
/* 42 */       return Thread.currentThread().getContextClassLoader();
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.container.SecurityActions
 * JD-Core Version:    0.6.0
 */