/*     */ package org.jboss.aop.proxy.container;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.Arrays;
/*     */ import java.util.Comparator;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ 
/*     */ public class ContainerProxyCacheKey
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 8758283842273747310L;
/*  39 */   private static final WeakReference[] EMTPY_WR_ARRAY = new WeakReference[0];
/*  40 */   private static final AOPProxyFactoryMixin[] EMPTY_MIXIN_ARRAY = new AOPProxyFactoryMixin[0];
/*     */   private String managerFqn;
/*     */   private WeakReference clazzRef;
/*  44 */   private WeakReference[] addedInterfaces = EMTPY_WR_ARRAY;
/*     */   private MetaData metaData;
/*  48 */   private AOPProxyFactoryMixin[] addedMixins = EMPTY_MIXIN_ARRAY;
/*  49 */   private int hashcode = 0;
/*     */ 
/*     */   public ContainerProxyCacheKey(String managerFqn, Class clazz)
/*     */   {
/*  53 */     this.clazzRef = new WeakReference(clazz);
/*  54 */     this.managerFqn = managerFqn;
/*     */   }
/*     */ 
/*     */   public ContainerProxyCacheKey(Class clazz)
/*     */   {
/*  59 */     this("/", clazz);
/*     */   }
/*     */ 
/*     */   public ContainerProxyCacheKey(String managerFqn, Class clazz, Class[] addedInterfaces, MetaData metaData)
/*     */   {
/*  64 */     this(managerFqn, clazz);
/*  65 */     this.addedInterfaces = ContainerCacheUtil.getSortedWeakReferenceForInterfaces(addedInterfaces);
/*  66 */     this.metaData = metaData;
/*     */   }
/*     */ 
/*     */   public ContainerProxyCacheKey(String managerFqn, Class clazz, Class[] addedInterfaces, AOPProxyFactoryMixin[] addedMixins, MetaData metaData)
/*     */   {
/*  71 */     this(managerFqn, clazz, addedInterfaces, metaData);
/*     */ 
/*  73 */     if (addedMixins != null)
/*     */     {
/*  75 */       this.addedMixins = addedMixins;
/*  76 */       Arrays.sort(this.addedMixins, MixinAlphabetical.singleton);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Class getClazz()
/*     */   {
/*  82 */     Class clazz = (Class)this.clazzRef.get();
/*  83 */     return clazz;
/*     */   }
/*     */ 
/*     */   public String getManagerFQN()
/*     */   {
/*  88 */     return this.managerFqn;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  93 */     if (this == obj)
/*     */     {
/*  95 */       return true;
/*     */     }
/*     */ 
/*  98 */     if (obj.getClass() != ContainerProxyCacheKey.class)
/*     */     {
/* 100 */       return false;
/*     */     }
/*     */ 
/* 103 */     ContainerProxyCacheKey other = (ContainerProxyCacheKey)obj;
/*     */ 
/* 105 */     if (!this.managerFqn.equals(other.managerFqn))
/*     */     {
/* 107 */       return false;
/*     */     }
/* 109 */     if (!compareMetadataContext(other))
/*     */     {
/* 111 */       return false;
/*     */     }
/* 113 */     if (!compareClass(other))
/*     */     {
/* 115 */       return false;
/*     */     }
/* 117 */     if (!compareAddedInterfaces(other))
/*     */     {
/* 119 */       return false;
/*     */     }
/*     */ 
/* 123 */     return compareAddedMixins(other);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 131 */     if (this.hashcode == 0)
/*     */     {
/* 134 */       Class clazz = (Class)this.clazzRef.get();
/* 135 */       StringBuffer sb = new StringBuffer();
/* 136 */       sb.append(this.managerFqn);
/* 137 */       if (clazz != null)
/*     */       {
/* 139 */         sb.append(clazz.getName());
/*     */       }
/*     */ 
/* 142 */       if (this.addedInterfaces != null)
/*     */       {
/* 144 */         for (int i = 0; i < this.addedInterfaces.length; i++)
/*     */         {
/* 146 */           sb.append(";");
/* 147 */           sb.append(((Class)this.addedInterfaces[i].get()).getName());
/*     */         }
/*     */       }
/*     */ 
/* 151 */       this.hashcode = sb.toString().hashCode();
/*     */ 
/* 153 */       if (this.metaData != null)
/*     */       {
/* 155 */         this.hashcode += this.metaData.hashCode();
/*     */       }
/*     */     }
/*     */ 
/* 159 */     return this.hashcode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 164 */     StringBuffer buf = new StringBuffer("ContainerProxyCache");
/* 165 */     buf.append(((Class)this.clazzRef.get()).getName());
/* 166 */     buf.append(";interfaces=");
/* 167 */     if (this.addedInterfaces == null)
/*     */     {
/* 169 */       buf.append("null");
/*     */     }
/*     */     else
/*     */     {
/* 173 */       buf.append(Arrays.asList(this.addedInterfaces));
/*     */     }
/* 175 */     buf.append(";mixins=");
/* 176 */     if (this.addedMixins == null)
/*     */     {
/* 178 */       buf.append("null");
/*     */     }
/*     */     else
/*     */     {
/* 182 */       buf.append(Arrays.asList(this.addedMixins));
/*     */     }
/* 184 */     return buf.toString();
/*     */   }
/*     */ 
/*     */   private boolean compareMetadataContext(ContainerProxyCacheKey other)
/*     */   {
/* 189 */     if ((this.metaData != null) || (other.metaData != null))
/*     */     {
/* 192 */       if ((this.metaData != null) && (other.metaData != null))
/*     */       {
/* 194 */         if (!this.metaData.equals(other.metaData))
/*     */         {
/* 196 */           return false;
/*     */         }
/*     */       }
/*     */       else
/*     */       {
/* 201 */         return false;
/*     */       }
/*     */     }
/* 203 */     return true;
/*     */   }
/*     */ 
/*     */   private boolean compareClass(ContainerProxyCacheKey other)
/*     */   {
/* 208 */     return ContainerCacheUtil.compareClassRefs(this.clazzRef, other.clazzRef);
/*     */   }
/*     */ 
/*     */   private boolean compareAddedInterfaces(ContainerProxyCacheKey other)
/*     */   {
/* 213 */     return ContainerCacheUtil.compareInterfaceRefs(this.addedInterfaces, other.addedInterfaces);
/*     */   }
/*     */ 
/*     */   private boolean compareAddedMixins(ContainerProxyCacheKey other)
/*     */   {
/* 218 */     if (((this.addedMixins == null) && (other.addedMixins != null)) || ((this.addedMixins == null) && (other.addedMixins != null)))
/*     */     {
/* 221 */       return false;
/*     */     }
/*     */ 
/* 224 */     if ((this.addedMixins != null) && (other.addedMixins != null))
/*     */     {
/* 226 */       if (this.addedMixins.length != other.addedMixins.length)
/*     */       {
/* 228 */         return false;
/*     */       }
/*     */ 
/* 231 */       for (int i = 0; i < this.addedMixins.length; i++)
/*     */       {
/* 233 */         if (!this.addedMixins[i].equals(other.addedMixins[i]))
/*     */         {
/* 235 */           return false;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 240 */     return true;
/*     */   }
/*     */ 
/*     */   static class MixinAlphabetical implements Comparator
/*     */   {
/* 245 */     static MixinAlphabetical singleton = new MixinAlphabetical();
/*     */ 
/*     */     public int compare(Object o1, Object o2)
/*     */     {
/* 249 */       String name1 = ((AOPProxyFactoryMixin)o1).getMixin().getName();
/* 250 */       String name2 = ((AOPProxyFactoryMixin)o2).getMixin().getName();
/* 251 */       return name1.compareTo(name2);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.container.ContainerProxyCacheKey
 * JD-Core Version:    0.6.0
 */