/*     */ package org.jboss.aop.proxy.container;
/*     */ 
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.metadata.spi.MetaData;
/*     */ 
/*     */ public class AOPProxyFactoryParameters
/*     */ {
/*     */   private Class proxiedClass;
/*     */   private Object target;
/*     */   private MetaData metaData;
/*     */   private boolean metaDataHasInstanceLevelData;
/*     */   private Class[] interfaces;
/*     */   private AOPProxyFactoryMixin[] mixins;
/*     */   private boolean objectAsSuperClass;
/*     */   private SimpleMetaData simpleMetaData;
/*     */   private ContainerCache containerCache;
/*     */   private Ctor ctor;
/*     */ 
/*     */   public AOPProxyFactoryParameters()
/*     */   {
/*     */   }
/*     */ 
/*     */   public AOPProxyFactoryParameters(Class proxiedClass, Object target, Class[] interfaces, AOPProxyFactoryMixin[] mixins, MetaData metaData, boolean metaDataHasInstanceLevelData, boolean objectAsSuperClass, SimpleMetaData simpleMetaData, ContainerCache containerCache, Class[] ctorSignature, Object[] ctorArguments)
/*     */   {
/*  62 */     this.proxiedClass = proxiedClass;
/*  63 */     this.target = target;
/*  64 */     this.interfaces = interfaces;
/*  65 */     this.mixins = mixins;
/*  66 */     this.metaData = metaData;
/*  67 */     this.metaDataHasInstanceLevelData = metaDataHasInstanceLevelData;
/*  68 */     this.objectAsSuperClass = objectAsSuperClass;
/*  69 */     this.simpleMetaData = simpleMetaData;
/*  70 */     this.containerCache = containerCache;
/*  71 */     setCtor(ctorSignature, ctorArguments);
/*     */   }
/*     */ 
/*     */   public Class[] getInterfaces()
/*     */   {
/*  76 */     return this.interfaces;
/*     */   }
/*     */ 
/*     */   public void setInterfaces(Class[] interfaces)
/*     */   {
/*  81 */     this.interfaces = interfaces;
/*     */   }
/*     */ 
/*     */   public MetaData getMetaData()
/*     */   {
/*  86 */     return this.metaData;
/*     */   }
/*     */ 
/*     */   public void setMetaData(MetaData metaData)
/*     */   {
/*  91 */     this.metaData = metaData;
/*     */   }
/*     */ 
/*     */   public boolean isObjectAsSuperClass()
/*     */   {
/*  96 */     return this.objectAsSuperClass;
/*     */   }
/*     */ 
/*     */   public void setObjectAsSuperClass(boolean objectAsSuperClass)
/*     */   {
/* 101 */     this.objectAsSuperClass = objectAsSuperClass;
/*     */   }
/*     */ 
/*     */   public Class getProxiedClass()
/*     */   {
/* 106 */     return this.proxiedClass;
/*     */   }
/*     */ 
/*     */   public void setProxiedClass(Class proxiedClass)
/*     */   {
/* 111 */     this.proxiedClass = proxiedClass;
/*     */   }
/*     */ 
/*     */   public SimpleMetaData getSimpleMetaData()
/*     */   {
/* 116 */     return this.simpleMetaData;
/*     */   }
/*     */ 
/*     */   public void setSimpleMetaData(SimpleMetaData simpleMetaData)
/*     */   {
/* 121 */     this.simpleMetaData = simpleMetaData;
/*     */   }
/*     */ 
/*     */   public Object getTarget()
/*     */   {
/* 126 */     return this.target;
/*     */   }
/*     */ 
/*     */   public void setTarget(Object target)
/*     */   {
/* 131 */     this.target = target;
/*     */   }
/*     */ 
/*     */   public AOPProxyFactoryMixin[] getMixins()
/*     */   {
/* 136 */     return this.mixins;
/*     */   }
/*     */ 
/*     */   public void setMixins(AOPProxyFactoryMixin[] mixins)
/*     */   {
/* 141 */     this.mixins = mixins;
/*     */   }
/*     */ 
/*     */   public ContainerCache getContainerCache()
/*     */   {
/* 146 */     return this.containerCache;
/*     */   }
/*     */ 
/*     */   public void setContainerCache(ContainerCache containerCache)
/*     */   {
/* 151 */     this.containerCache = containerCache;
/*     */   }
/*     */ 
/*     */   public Ctor getCtor()
/*     */   {
/* 156 */     return this.ctor;
/*     */   }
/*     */ 
/*     */   public boolean getMetaDataHasInstanceLevelData()
/*     */   {
/* 161 */     return this.metaDataHasInstanceLevelData;
/*     */   }
/*     */ 
/*     */   public void setMetaDataHasInstanceLevelData(boolean metaDataHasInstanceLevelData)
/*     */   {
/* 166 */     this.metaDataHasInstanceLevelData = metaDataHasInstanceLevelData;
/*     */   }
/*     */ 
/*     */   public void setCtor(Class[] ctorSignature, Object[] ctorArguments)
/*     */   {
/* 171 */     boolean haveSig = (ctorSignature != null) && (ctorSignature.length > 0);
/* 172 */     boolean haveArgs = (ctorArguments != null) && (ctorArguments.length > 0);
/*     */ 
/* 174 */     if ((haveSig) && (haveArgs))
/*     */     {
/* 176 */       this.ctor = new Ctor(ctorSignature, ctorArguments);
/*     */     }
/* 178 */     else if ((!haveSig) && (!haveArgs))
/*     */     {
/* 180 */       this.ctor = null;
/*     */     }
/*     */     else
/*     */     {
/* 184 */       throw new RuntimeException("If specifying either constructor arguments or signature, you must specify the other");
/*     */     }
/*     */   }
/*     */ 
/*     */   public static class Ctor {
/*     */     Class[] signature;
/*     */     Object[] arguments;
/*     */ 
/*     */     public Ctor(Class[] signature, Object[] arguments) {
/* 195 */       this.signature = signature;
/* 196 */       this.arguments = arguments;
/*     */     }
/*     */ 
/*     */     public Object[] getArguments()
/*     */     {
/* 201 */       return this.arguments;
/*     */     }
/*     */ 
/*     */     public Class[] getSignature()
/*     */     {
/* 206 */       return this.signature;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.container.AOPProxyFactoryParameters
 * JD-Core Version:    0.6.0
 */