/*     */ package org.jboss.aop.proxy.container;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ 
/*     */ public class AOPProxyFactoryMixin
/*     */ {
/*     */   private String construction;
/*     */   private WeakReference mixinClassRef;
/*     */   private WeakReference[] interfaceClassRefs;
/*     */   private int hashcode;
/*     */ 
/*     */   public AOPProxyFactoryMixin(Class mixin, Class[] interfaces)
/*     */   {
/*  35 */     this.mixinClassRef = new WeakReference(mixin);
/*  36 */     this.interfaceClassRefs = ContainerCacheUtil.getSortedWeakReferenceForInterfaces(interfaces);
/*     */   }
/*     */ 
/*     */   public AOPProxyFactoryMixin(Class mixin, Class[] interfaces, String parameters)
/*     */   {
/*  41 */     this(mixin, interfaces);
/*  42 */     StringBuffer construction = new StringBuffer(" new ");
/*  43 */     construction.append(mixin.getName());
/*     */ 
/*  45 */     if (!parameters.startsWith("("))
/*     */     {
/*  47 */       construction.append("(");
/*     */     }
/*     */ 
/*  50 */     construction.append(parameters);
/*     */ 
/*  52 */     if (!parameters.endsWith(")"))
/*     */     {
/*  54 */       construction.append(")");
/*     */     }
/*  56 */     this.construction = construction.toString();
/*     */   }
/*     */ 
/*     */   public String getConstruction()
/*     */   {
/*  61 */     return this.construction;
/*     */   }
/*     */ 
/*     */   public Class[] getInterfaces()
/*     */   {
/*  67 */     if (this.interfaceClassRefs != null)
/*     */     {
/*  69 */       Class[] interfaces = new Class[this.interfaceClassRefs.length];
/*  70 */       for (int i = 0; i < interfaces.length; i++)
/*     */       {
/*  72 */         interfaces[i] = ((Class)this.interfaceClassRefs[i].get());
/*     */       }
/*  74 */       return interfaces;
/*     */     }
/*  76 */     return null;
/*     */   }
/*     */ 
/*     */   public Class getMixin()
/*     */   {
/*  81 */     return (Class)this.mixinClassRef.get();
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  86 */     if (this == obj)
/*     */     {
/*  88 */       return true;
/*     */     }
/*     */ 
/*  91 */     if (!(obj instanceof AOPProxyFactoryMixin))
/*     */     {
/*  93 */       return false;
/*     */     }
/*     */ 
/*  96 */     AOPProxyFactoryMixin other = (AOPProxyFactoryMixin)obj;
/*     */ 
/*  98 */     if (!compareConstruction(other))
/*     */     {
/* 100 */       return false;
/*     */     }
/* 102 */     if (!ContainerCacheUtil.compareClassRefs(this.mixinClassRef, other.mixinClassRef))
/*     */     {
/* 104 */       return false;
/*     */     }
/*     */ 
/* 108 */     return ContainerCacheUtil.compareInterfaceRefs(this.interfaceClassRefs, other.interfaceClassRefs);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 115 */     if (this.hashcode == 0)
/*     */     {
/* 118 */       Class clazz = (Class)this.mixinClassRef.get();
/* 119 */       StringBuffer sb = new StringBuffer();
/*     */ 
/* 121 */       if (clazz != null)
/*     */       {
/* 123 */         sb.append(clazz.getName());
/*     */       }
/*     */ 
/* 126 */       if (this.interfaceClassRefs != null)
/*     */       {
/* 128 */         for (int i = 0; i < this.interfaceClassRefs.length; i++)
/*     */         {
/* 130 */           sb.append(";");
/* 131 */           sb.append(((Class)this.interfaceClassRefs[i].get()).getName());
/*     */         }
/*     */       }
/* 134 */       this.hashcode = sb.toString().hashCode();
/* 135 */       if (this.construction != null)
/*     */       {
/* 137 */         this.hashcode += this.construction.hashCode();
/*     */       }
/*     */     }
/*     */ 
/* 141 */     return this.hashcode;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 146 */     return super.toString();
/*     */   }
/*     */ 
/*     */   private boolean compareConstruction(AOPProxyFactoryMixin other)
/*     */   {
/* 151 */     if ((this.construction == null) && (other.construction != null))
/*     */     {
/* 153 */       return false;
/*     */     }
/* 155 */     if ((this.construction != null) && (other.construction == null))
/*     */     {
/* 157 */       return false;
/*     */     }
/* 159 */     if (this.construction != null)
/*     */     {
/* 161 */       if (!this.construction.equals(other.construction))
/*     */       {
/* 163 */         return false;
/*     */       }
/*     */     }
/* 166 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.container.AOPProxyFactoryMixin
 * JD-Core Version:    0.6.0
 */