/*    */ package org.jboss.aop.proxy;
/*    */ 
/*    */ import java.lang.reflect.AccessibleObject;
/*    */ import java.security.AccessController;
/*    */ import java.security.PrivilegedAction;
/*    */ import java.security.PrivilegedActionException;
/*    */ import java.security.PrivilegedExceptionAction;
/*    */ 
/*    */ class SecurityActions
/*    */ {
/*    */   static void setAccessible(AccessibleObject accessibleObject)
/*    */   {
/* 74 */     if (System.getSecurityManager() == null)
/*    */     {
/* 76 */       SetAccessibleAction.NON_PRIVILEGED.setAccessible(accessibleObject);
/*    */     }
/*    */     else
/*    */     {
/* 80 */       SetAccessibleAction.PRIVILEGED.setAccessible(accessibleObject);
/*    */     }
/*    */   }
/*    */ 
/*    */   static ClassLoader getContextClassLoader()
/*    */   {
/* 96 */     if (System.getSecurityManager() == null) {
/* 97 */       return Thread.currentThread().getContextClassLoader();
/*    */     }
/* 99 */     return (ClassLoader)AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
/*    */   }
/*    */ 
/*    */   public static class GetContextClassLoaderAction
/*    */     implements PrivilegedAction<ClassLoader>
/*    */   {
/* 86 */     public static GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();
/*    */ 
/*    */     public ClassLoader run()
/*    */     {
/* 90 */       return Thread.currentThread().getContextClassLoader();
/*    */     }
/*    */   }
/*    */ 
/*    */   static abstract interface SetAccessibleAction
/*    */   {
/* 41 */     public static final SetAccessibleAction PRIVILEGED = new SetAccessibleAction()
/*    */     {
/*    */       public void setAccessible(AccessibleObject accessibleObject)
/*    */       {
/*    */         try
/*    */         {
/* 47 */           AccessController.doPrivileged(new PrivilegedExceptionAction(accessibleObject)
/*    */           {
/*    */             public Object run() throws Exception
/*    */             {
/* 51 */               this.val$accessibleObject.setAccessible(true);
/* 52 */               return null;
/*    */             }
/*    */           });
/*    */         }
/*    */         catch (PrivilegedActionException e) {
/* 58 */           throw new RuntimeException("Error setting " + accessibleObject + " as accessible ", e.getException());
/*    */         }
/*    */       }
/* 41 */     };
/*    */ 
/* 63 */     public static final SetAccessibleAction NON_PRIVILEGED = new SetAccessibleAction()
/*    */     {
/*    */       public void setAccessible(AccessibleObject accessibleObject)
/*    */       {
/* 67 */         accessibleObject.setAccessible(true);
/*    */       }
/* 63 */     };
/*    */ 
/*    */     public abstract void setAccessible(AccessibleObject paramAccessibleObject);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.SecurityActions
 * JD-Core Version:    0.6.0
 */