/*     */ package org.jboss.aop.proxy;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.security.ProtectionDomain;
/*     */ import java.util.HashSet;
/*     */ import java.util.Map;
/*     */ import javassist.ClassPool;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.CtNewMethod;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.ClassInstanceAdvisor;
/*     */ import org.jboss.aop.InstanceAdvisor;
/*     */ import org.jboss.aop.instrument.TransformerCommon;
/*     */ import org.jboss.aop.util.JavassistMethodHashing;
/*     */ import org.jboss.util.collection.WeakValueHashMap;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class ProxyFactory
/*     */ {
/*  51 */   private static long counter = 0L;
/*  52 */   private static WeakValueHashMap proxyCache = new WeakValueHashMap();
/*     */ 
/*     */   public static Proxy createInterfaceProxy(ClassLoader loader, Class[] interfaces, ProxyMixin[] mixins, InstanceAdvisor advisor) throws Exception
/*     */   {
/*  56 */     Class clazz = createProxyClass(loader, mixins, interfaces);
/*     */ 
/*  58 */     Proxy instance = (Proxy)clazz.newInstance();
/*  59 */     instance.instanceAdvisor = advisor;
/*  60 */     instance.mixins = mixins;
/*  61 */     instance.interfaces = interfaces;
/*  62 */     instance.guid = new GUID();
/*     */ 
/*  64 */     synchronized (proxyCache)
/*     */     {
/*  66 */       proxyCache.put(instance.guid, clazz);
/*     */     }
/*     */ 
/*  69 */     return instance;
/*     */   }
/*     */ 
/*     */   public static Class getProxyClass(GUID guid)
/*     */   {
/*  74 */     synchronized (proxyCache)
/*     */     {
/*  76 */       return (Class)proxyCache.get(guid);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Proxy createInterfaceProxy(GUID guid, ClassLoader loader, Class[] interfaces) throws Exception
/*     */   {
/*  82 */     return createInterfaceProxy(guid, loader, interfaces, null, new ClassInstanceAdvisor());
/*     */   }
/*     */ 
/*     */   public static Proxy createInterfaceProxy(GUID guid, ClassLoader loader, Class[] interfaces, ProxyMixin[] mixins, InstanceAdvisor advisor) throws Exception
/*     */   {
/*  87 */     Class clazz = getProxyClass(guid);
/*  88 */     boolean wasFound = true;
/*  89 */     if (clazz == null)
/*     */     {
/*  91 */       wasFound = false;
/*  92 */       clazz = createProxyClass(loader, mixins, interfaces);
/*     */     }
/*     */ 
/*  95 */     Proxy instance = (Proxy)clazz.newInstance();
/*  96 */     instance.instanceAdvisor = advisor;
/*  97 */     instance.mixins = mixins;
/*  98 */     instance.interfaces = interfaces;
/*  99 */     instance.guid = guid;
/*     */ 
/* 101 */     if (!wasFound)
/*     */     {
/* 103 */       synchronized (proxyCache)
/*     */       {
/* 105 */         proxyCache.put(guid, clazz);
/*     */       }
/*     */     }
/*     */ 
/* 109 */     return instance;
/*     */   }
/*     */ 
/*     */   private static Class createProxyClass(ClassLoader loader, ProxyMixin[] mixins, Class[] interfaces)
/*     */     throws Exception
/*     */   {
/* 115 */     CtClass proxy = createProxyCtClass(loader, mixins, interfaces);
/*     */ 
/* 117 */     int length = interfaces != null ? interfaces.length : 0;
/* 118 */     ProtectionDomain pd = null;
/* 119 */     for (int n = 0; (n < interfaces.length) && (pd == null); n++)
/*     */     {
/* 121 */       pd = interfaces[n].getProtectionDomain();
/*     */     }
/* 123 */     Class clazz = TransformerCommon.toClass(proxy, loader, pd);
/* 124 */     Map methodmap = ClassProxyFactory.getMethodMap(clazz);
/* 125 */     Field field = clazz.getDeclaredField("methodMap");
/* 126 */     SecurityActions.setAccessible(field);
/* 127 */     field.set(null, methodmap);
/* 128 */     return clazz;
/*     */   }
/*     */ 
/*     */   public static GUID generateProxyClass(ClassLoader loader, ProxyMixin[] mixins, Class[] interfaces) throws Exception
/*     */   {
/* 133 */     Class clazz = createProxyClass(loader, mixins, interfaces);
/* 134 */     GUID guid = new GUID();
/*     */ 
/* 136 */     synchronized (proxyCache)
/*     */     {
/* 138 */       proxyCache.put(guid, clazz);
/*     */     }
/*     */ 
/* 141 */     return guid;
/*     */   }
/*     */ 
/*     */   private static CtClass createProxyCtClass(ClassLoader loader, ProxyMixin[] mixins, Class[] interfaces)
/*     */     throws Exception
/*     */   {
/* 147 */     ClassPool pool = AspectManager.instance().findClassPool(loader);
/* 148 */     if (pool == null) throw new NullPointerException("Could not find ClassPool");
/*     */ 
/* 150 */     String classname = "AOPProxy$" + counter++;
/*     */ 
/* 152 */     CtClass base = pool.get("org.jboss.aop.proxy.Proxy");
/* 153 */     CtClass proxy = TransformerCommon.makeClass(pool, classname, base);
/* 154 */     proxy.addInterface(pool.get("org.jboss.aop.instrument.Untransformable"));
/* 155 */     CtClass map = pool.get("java.util.Map");
/* 156 */     CtField methodMap = new CtField(map, "methodMap", proxy);
/* 157 */     methodMap.setModifiers(10);
/* 158 */     proxy.addField(methodMap);
/* 159 */     CtMethod getMethodMap = CtNewMethod.getter("getMethodMap", methodMap);
/* 160 */     getMethodMap.setModifiers(1);
/* 161 */     proxy.addMethod(getMethodMap);
/*     */ 
/* 163 */     HashSet addedInterfaces = new HashSet();
/* 164 */     HashSet addedMethods = new HashSet();
/* 165 */     if (mixins != null)
/*     */     {
/* 167 */       for (int i = 0; i < mixins.length; i++)
/*     */       {
/* 169 */         HashSet mixinMethods = new HashSet();
/* 170 */         Class[] mixinf = mixins[i].getInterfaces();
/* 171 */         ClassPool mixPool = AspectManager.instance().findClassPool(mixins[i].getMixin().getClass().getClassLoader());
/* 172 */         CtClass mixClass = mixPool.get(mixins[i].getMixin().getClass().getName());
/* 173 */         for (int j = 0; j < mixinf.length; j++)
/*     */         {
/* 175 */           if (addedInterfaces.contains(mixinf[j].getName())) throw new Exception("2 mixins are implementing the same interfaces");
/* 176 */           ClassPool mixIntfPool = AspectManager.instance().findClassPool(mixinf[j].getClassLoader());
/* 177 */           CtClass intfClass = mixIntfPool.get(mixinf[j].getName());
/* 178 */           CtMethod[] methods = intfClass.getMethods();
/* 179 */           for (int m = 0; m < methods.length; m++)
/*     */           {
/* 181 */             if (!methods[m].getDeclaringClass().getName().equals("java.lang.Object")) {
/* 182 */               Long hash = new Long(JavassistMethodHashing.methodHash(methods[m]));
/* 183 */               if (!mixinMethods.contains(hash)) {
/* 184 */                 if (addedMethods.contains(hash)) throw new Exception("More than one mixin has same method");
/* 185 */                 mixinMethods.add(hash);
/* 186 */                 addedMethods.add(hash);
/* 187 */                 String returnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ";
/* 188 */                 String code = "{   " + mixClass.getName() + " mixin = (" + mixClass.getName() + ")mixins[" + i + "].getMixin();" + "   " + returnStr + " mixin." + methods[m].getName() + "($$);" + "}";
/*     */ 
/* 192 */                 CtMethod newMethod = CtNewMethod.make(methods[m].getReturnType(), methods[m].getName(), methods[m].getParameterTypes(), methods[m].getExceptionTypes(), code, proxy);
/* 193 */                 newMethod.setModifiers(1);
/* 194 */                 proxy.addMethod(newMethod);
/*     */               }
/*     */             }
/*     */           }
/* 197 */           proxy.addInterface(intfClass);
/* 198 */           addedInterfaces.add(intfClass.getName());
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 203 */     for (int i = 0; i < interfaces.length; i++)
/*     */     {
/* 205 */       if (!addedInterfaces.contains(interfaces[i].getName())) {
/* 206 */         ClassPool mixPool = AspectManager.instance().findClassPool(interfaces[i].getClassLoader());
/* 207 */         CtClass intfClass = mixPool.get(interfaces[i].getName());
/* 208 */         CtMethod[] methods = intfClass.getMethods();
/* 209 */         for (int m = 0; m < methods.length; m++)
/*     */         {
/* 211 */           if (!methods[m].getDeclaringClass().getName().equals("java.lang.Object")) {
/* 212 */             Long hash = new Long(JavassistMethodHashing.methodHash(methods[m]));
/* 213 */             if (!addedMethods.contains(hash)) {
/* 214 */               addedMethods.add(hash);
/* 215 */               String aopReturnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
/* 216 */               String args = "null";
/* 217 */               if (methods[m].getParameterTypes().length > 0) args = "$args";
/* 218 */               String code = "{       org.jboss.aop.advice.Interceptor[] aspects = instanceAdvisor.getInterceptors();     org.jboss.aop.MethodInfo mi = new org.jboss.aop.MethodInfo();     mi.setHash(" + hash.longValue() + "L);" + "    org.jboss.aop.proxy.ProxyMethodInvocation invocation = new org.jboss.aop.proxy.ProxyMethodInvocation(this, mi, aspects); " + "    invocation.setInstanceResolver(instanceAdvisor.getMetaData()); " + "    invocation.setArguments(" + args + "); " + "    " + aopReturnStr + " invocation.invokeNext(); " + "}";
/*     */ 
/* 227 */               CtMethod newMethod = CtNewMethod.make(methods[m].getReturnType(), methods[m].getName(), methods[m].getParameterTypes(), methods[m].getExceptionTypes(), code, proxy);
/* 228 */               newMethod.setModifiers(1);
/* 229 */               proxy.addMethod(newMethod);
/*     */             }
/*     */           }
/*     */         }
/* 231 */         proxy.addInterface(intfClass);
/*     */       }
/*     */     }
/* 233 */     return proxy;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.ProxyFactory
 * JD-Core Version:    0.6.0
 */