/*    */ package org.jboss.aop.proxy;
/*    */ 
/*    */ import java.io.ObjectStreamException;
/*    */ import java.io.Serializable;
/*    */ import org.jboss.aop.InstanceAdvisor;
/*    */ import org.jboss.util.id.GUID;
/*    */ 
/*    */ public class MarshalledInterfaceProxy
/*    */   implements Serializable
/*    */ {
/*    */   static final long serialVersionUID = -7939451715003985857L;
/*    */   private Class[] interfaces;
/*    */   private ProxyMixin[] mixins;
/*    */   private InstanceAdvisor advisor;
/*    */   private GUID guid;
/*    */ 
/*    */   protected MarshalledInterfaceProxy()
/*    */   {
/*    */   }
/*    */ 
/*    */   public MarshalledInterfaceProxy(GUID guid, Class[] intfs, ProxyMixin[] mixins, InstanceAdvisor advisor)
/*    */   {
/* 51 */     this.guid = guid;
/* 52 */     this.advisor = advisor;
/* 53 */     this.interfaces = intfs;
/* 54 */     this.mixins = mixins;
/*    */   }
/*    */ 
/*    */   public Object readResolve()
/*    */     throws ObjectStreamException
/*    */   {
/*    */     try
/*    */     {
/* 62 */       return ProxyFactory.createInterfaceProxy(this.guid, SecurityActions.getContextClassLoader(), this.interfaces, this.mixins, this.advisor);
/*    */     }
/*    */     catch (Exception e) {
/*    */     }
/* 66 */     throw new RuntimeException(e);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.proxy.MarshalledInterfaceProxy
 * JD-Core Version:    0.6.0
 */