/*     */ package org.jboss.aop.pointcut.ast;
/*     */ 
/*     */ import java.util.Stack;
/*     */ 
/*     */ class JJTTypeExpressionParserState
/*     */ {
/*     */   private Stack nodes;
/*     */   private Stack marks;
/*     */   private int sp;
/*     */   private int mk;
/*     */   private boolean node_created;
/*     */ 
/*     */   JJTTypeExpressionParserState()
/*     */   {
/*  34 */     this.nodes = new Stack();
/*  35 */     this.marks = new Stack();
/*  36 */     this.sp = 0;
/*  37 */     this.mk = 0;
/*     */   }
/*     */ 
/*     */   boolean nodeCreated()
/*     */   {
/*  44 */     return this.node_created;
/*     */   }
/*     */ 
/*     */   void reset()
/*     */   {
/*  50 */     this.nodes.removeAllElements();
/*  51 */     this.marks.removeAllElements();
/*  52 */     this.sp = 0;
/*  53 */     this.mk = 0;
/*     */   }
/*     */ 
/*     */   Node rootNode()
/*     */   {
/*  59 */     return (Node)this.nodes.elementAt(0);
/*     */   }
/*     */ 
/*     */   void pushNode(Node n)
/*     */   {
/*  64 */     this.nodes.push(n);
/*  65 */     this.sp += 1;
/*     */   }
/*     */ 
/*     */   Node popNode()
/*     */   {
/*  71 */     if (--this.sp < this.mk) {
/*  72 */       this.mk = ((Integer)this.marks.pop()).intValue();
/*     */     }
/*  74 */     return (Node)this.nodes.pop();
/*     */   }
/*     */ 
/*     */   Node peekNode()
/*     */   {
/*  79 */     return (Node)this.nodes.peek();
/*     */   }
/*     */ 
/*     */   int nodeArity()
/*     */   {
/*  85 */     return this.sp - this.mk;
/*     */   }
/*     */ 
/*     */   void clearNodeScope(Node n)
/*     */   {
/*  90 */     while (this.sp > this.mk) {
/*  91 */       popNode();
/*     */     }
/*  93 */     this.mk = ((Integer)this.marks.pop()).intValue();
/*     */   }
/*     */ 
/*     */   void openNodeScope(Node n)
/*     */   {
/*  98 */     this.marks.push(new Integer(this.mk));
/*  99 */     this.mk = this.sp;
/* 100 */     n.jjtOpen();
/*     */   }
/*     */ 
/*     */   void closeNodeScope(Node n, int num)
/*     */   {
/* 109 */     this.mk = ((Integer)this.marks.pop()).intValue();
/* 110 */     while (num-- > 0) {
/* 111 */       Node c = popNode();
/* 112 */       c.jjtSetParent(n);
/* 113 */       n.jjtAddChild(c, num);
/*     */     }
/* 115 */     n.jjtClose();
/* 116 */     pushNode(n);
/* 117 */     this.node_created = true;
/*     */   }
/*     */ 
/*     */   void closeNodeScope(Node n, boolean condition)
/*     */   {
/* 127 */     if (condition) {
/* 128 */       int a = nodeArity();
/* 129 */       this.mk = ((Integer)this.marks.pop()).intValue();
/* 130 */       while (a-- > 0) {
/* 131 */         Node c = popNode();
/* 132 */         c.jjtSetParent(n);
/* 133 */         n.jjtAddChild(c, a);
/*     */       }
/* 135 */       n.jjtClose();
/* 136 */       pushNode(n);
/* 137 */       this.node_created = true;
/*     */     } else {
/* 139 */       this.mk = ((Integer)this.marks.pop()).intValue();
/* 140 */       this.node_created = false;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ast.JJTTypeExpressionParserState
 * JD-Core Version:    0.6.0
 */