/*     */ package org.jboss.aop.pointcut.ast;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ 
/*     */ public class ASTMethod extends SimpleNode
/*     */ {
/*     */   String returnTypeExpr;
/*     */   ClassExpression returnType;
/*     */   String classExpr;
/*     */   ClassExpression clazz;
/*     */   String methodExpr;
/*     */   IdentifierExpression methodIdentifier;
/*  58 */   boolean anyParameters = false;
/*  59 */   boolean hasAnyZeroOrMoreParameters = false;
/*  60 */   ArrayList parameters = new ArrayList();
/*  61 */   ArrayList attributes = new ArrayList();
/*  62 */   ArrayList exceptions = new ArrayList();
/*     */ 
/*     */   public ASTMethod(int id)
/*     */   {
/*  31 */     super(id);
/*     */   }
/*     */ 
/*     */   public ASTMethod(PointcutExpressionParser p, int id)
/*     */   {
/*  36 */     super(p, id);
/*     */   }
/*     */ 
/*     */   public Object jjtAccept(PointcutExpressionParserVisitor visitor, Object data)
/*     */   {
/*  43 */     return visitor.visit(this, data);
/*     */   }
/*     */ 
/*     */   public Object jjtAccept(TypeExpressionParserVisitor visitor, Object data)
/*     */   {
/*  48 */     return visitor.visit(this, data);
/*     */   }
/*     */ 
/*     */   public void jjtAddChild(Node n, int i)
/*     */   {
/*  66 */     if ((n instanceof ASTAttribute)) { this.attributes.add(n);
/*  67 */     } else if ((n instanceof ASTException)) { this.exceptions.add(n);
/*  68 */     } else if ((n instanceof ASTAllParameter)) { this.anyParameters = true;
/*  69 */     } else if (((n instanceof ASTParameter)) && (!this.anyParameters))
/*     */     {
/*  71 */       this.parameters.add(0, n);
/*  72 */       if ((!this.hasAnyZeroOrMoreParameters) && (((ASTParameter)n).isAnyZeroOrMoreParameters()))
/*     */       {
/*  74 */         this.hasAnyZeroOrMoreParameters = true;
/*     */       }
/*     */     } else {
/*  77 */       super.jjtAddChild(n, i);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setMethodExpression(String expression) {
/*  81 */     this.methodExpr = expression;
/*  82 */     this.methodIdentifier = new IdentifierExpression(expression);
/*     */   }
/*     */ 
/*     */   public void setReturnTypeExpression(String exp)
/*     */   {
/*  87 */     this.returnTypeExpr = exp;
/*  88 */     this.returnType = new ClassExpression(exp);
/*     */   }
/*     */ 
/*     */   public void setClassExpression(String exp)
/*     */   {
/*  93 */     this.classExpr = exp;
/*  94 */     this.clazz = new ClassExpression(exp);
/*     */   }
/*     */ 
/*     */   public String getReturnTypeExpression()
/*     */   {
/*  99 */     return this.returnTypeExpr;
/*     */   }
/*     */ 
/*     */   public String getClassExpr()
/*     */   {
/* 104 */     return this.classExpr;
/*     */   }
/*     */ 
/*     */   public String getMethodExpr()
/*     */   {
/* 109 */     return this.methodExpr;
/*     */   }
/*     */ 
/*     */   public boolean isAnyParameters()
/*     */   {
/* 114 */     return this.anyParameters;
/*     */   }
/*     */ 
/*     */   public boolean hasAnyZeroOrMoreParameters()
/*     */   {
/* 119 */     return this.hasAnyZeroOrMoreParameters;
/*     */   }
/*     */ 
/*     */   public ArrayList getParameters()
/*     */   {
/* 124 */     return this.parameters;
/*     */   }
/*     */ 
/*     */   public ArrayList getExceptions()
/*     */   {
/* 129 */     return this.exceptions;
/*     */   }
/*     */ 
/*     */   public ArrayList getAttributes()
/*     */   {
/* 134 */     return this.attributes;
/*     */   }
/*     */ 
/*     */   public ClassExpression getReturnType()
/*     */   {
/* 139 */     return this.returnType;
/*     */   }
/*     */ 
/*     */   public ClassExpression getClazz()
/*     */   {
/* 144 */     return this.clazz;
/*     */   }
/*     */ 
/*     */   public IdentifierExpression getMethodIdentifier()
/*     */   {
/* 149 */     return this.methodIdentifier;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ast.ASTMethod
 * JD-Core Version:    0.6.0
 */