/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.CtBehavior;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithin;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithincode;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ 
/*     */ public class WithinMatcher extends MatcherHelper
/*     */ {
/*     */   CtBehavior behavior;
/*     */   Advisor advisor;
/*     */   AccessibleObject accessible;
/*     */ 
/*     */   public WithinMatcher(Advisor advisor, CtBehavior behavior, ASTStart start)
/*     */     throws NotFoundException
/*     */   {
/*  53 */     super(start, advisor.getManager());
/*  54 */     this.advisor = advisor;
/*  55 */     this.behavior = behavior;
/*     */   }
/*     */ 
/*     */   public WithinMatcher(Advisor advisor, AccessibleObject behavior, ASTStart start)
/*     */   {
/*  60 */     super(start, advisor.getManager());
/*  61 */     this.advisor = advisor;
/*  62 */     this.accessible = behavior;
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/*  67 */     throw new RuntimeException("NOT REACHABLE");
/*     */   }
/*     */ 
/*     */   public Class getDeclaringClass()
/*     */   {
/*  72 */     if ((this.accessible instanceof Constructor))
/*  73 */       return ((Constructor)this.accessible).getDeclaringClass();
/*  74 */     if ((this.accessible instanceof Method)) return ((Method)this.accessible).getDeclaringClass();
/*  75 */     return null;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithin node, Object data)
/*     */   {
/*  80 */     if (this.behavior != null)
/*     */     {
/*  82 */       if (!Util.matchesClassExpr(node.getClazz(), this.behavior.getDeclaringClass(), this.advisor)) return Boolean.FALSE;
/*     */ 
/*     */     }
/*  86 */     else if (!Util.matchesClassExpr(node.getClazz(), getDeclaringClass(), this.advisor)) return Boolean.FALSE;
/*     */ 
/*  88 */     return Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithincode node, Object data)
/*     */   {
/*  93 */     return node.jjtGetChild(0).jjtAccept(this, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTMethod node, Object data)
/*     */   {
/*  98 */     if (this.behavior != null)
/*     */     {
/* 100 */       if ((this.behavior instanceof CtConstructor)) return Boolean.FALSE;
/* 101 */       MethodMatcher matcher = new MethodMatcher(this.advisor, (CtMethod)this.behavior, null);
/* 102 */       return matcher.matches(node);
/*     */     }
/* 104 */     if ((this.accessible instanceof Constructor)) return Boolean.FALSE;
/* 105 */     MethodMatcher matcher = new MethodMatcher(this.advisor, (Method)this.accessible, null);
/* 106 */     return matcher.matches(node);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstructor node, Object data)
/*     */   {
/* 112 */     if (this.behavior != null)
/*     */     {
/*     */       try
/*     */       {
/* 116 */         if ((this.behavior instanceof CtMethod)) return Boolean.FALSE;
/* 117 */         ConstructorMatcher matcher = new ConstructorMatcher(this.advisor, (CtConstructor)this.behavior, null);
/* 118 */         return matcher.matches(node);
/*     */       }
/*     */       catch (NotFoundException e)
/*     */       {
/* 122 */         throw new RuntimeException(e);
/*     */       }
/*     */     }
/* 125 */     if ((this.accessible instanceof Method)) return Boolean.FALSE;
/* 126 */     ConstructorMatcher matcher = new ConstructorMatcher(this.advisor, (Constructor)this.accessible, null);
/* 127 */     return matcher.matches(node);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.WithinMatcher
 * JD-Core Version:    0.6.0
 */