/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.io.StringReader;
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.CtField;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.expr.MethodCall;
/*     */ import javassist.expr.NewExpr;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ParseException;
/*     */ import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
/*     */ 
/*     */ public class PointcutExpression
/*     */   implements Pointcut
/*     */ {
/*     */   protected String name;
/*     */   protected String expr;
/*     */   protected ASTStart ast;
/*     */   protected PointcutStats stats;
/*     */ 
/*     */   public PointcutExpression(String name, String expr)
/*     */     throws ParseException
/*     */   {
/*  57 */     this.name = name;
/*  58 */     this.expr = expr;
/*     */ 
/*  61 */     this.ast = new PointcutExpressionParser(new StringReader(expr)).Start();
/*     */   }
/*     */ 
/*     */   public void setManager(AspectManager manager)
/*     */   {
/*  66 */     if (this.stats == null)
/*     */     {
/*  68 */       this.stats = new PointcutStats(this.ast, manager);
/*  69 */       this.stats.matches();
/*     */     }
/*     */   }
/*     */ 
/*     */   public PointcutStats getStats()
/*     */   {
/*  75 */     return this.stats;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  80 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getExpr()
/*     */   {
/*  85 */     return this.expr;
/*     */   }
/*     */ 
/*     */   public boolean softMatch(Advisor advisor)
/*     */   {
/*  90 */     SoftClassMatcher matcher = new SoftClassMatcher(advisor, advisor.getName(), this.ast);
/*  91 */     return matcher.matches();
/*     */   }
/*     */ 
/*     */   public boolean matchesCall(Advisor callingAdvisor, MethodCall methodCall) throws NotFoundException
/*     */   {
/*  96 */     if ((this.stats == null) || (this.stats.isWithin()) || (this.stats.isWithincode()) || (this.stats.isCall()))
/*     */     {
/*  98 */       MethodCallMatcher matcher = new MethodCallMatcher(callingAdvisor, methodCall, this.ast);
/*  99 */       return matcher.matches();
/*     */     }
/* 101 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean matchesCall(Advisor callingAdvisor, NewExpr methodCall) throws NotFoundException
/*     */   {
/* 106 */     if ((this.stats == null) || (this.stats.isWithin()) || (this.stats.isWithincode()) || (this.stats.isCall()))
/*     */     {
/* 108 */       NewExprMatcher matcher = new NewExprMatcher(callingAdvisor, methodCall, this.ast);
/* 109 */       return matcher.matches();
/*     */     }
/* 111 */     return false;
/*     */   }
/*     */ 
/*     */   public PointcutMethodMatch matchesExecution(Advisor advisor, Method m)
/*     */   {
/* 116 */     if ((this.stats == null) || (this.stats.isExecution()))
/*     */     {
/* 118 */       ExecutionMethodMatcher matcher = new ExecutionMethodMatcher(advisor, m, this.ast);
/* 119 */       boolean match = matcher.matches();
/*     */ 
/* 121 */       if (match)
/*     */       {
/* 123 */         return new PointcutMethodMatch(match, matcher.getMatchedClass(), matcher.getMatchLevel(), matcher.isInstanceOf());
/*     */       }
/*     */     }
/* 126 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean matchesExecution(Advisor advisor, Constructor c)
/*     */   {
/* 131 */     if ((this.stats == null) || (this.stats.isExecution()))
/*     */     {
/* 133 */       ExecutionConstructorMatcher matcher = new ExecutionConstructorMatcher(advisor, c, this.ast);
/* 134 */       return matcher.matches();
/*     */     }
/* 136 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean matchesConstruction(Advisor advisor, Constructor c)
/*     */   {
/* 141 */     if ((this.stats == null) || (this.stats.isConstruction()))
/*     */     {
/* 143 */       ConstructionMatcher matcher = new ConstructionMatcher(advisor, c, this.ast);
/* 144 */       return matcher.matches();
/*     */     }
/* 146 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean matchesGet(Advisor advisor, Field f)
/*     */   {
/* 151 */     if ((this.stats == null) || (this.stats.isGet()))
/*     */     {
/* 153 */       FieldMatcher matcher = new FieldGetMatcher(advisor, f, this.ast);
/* 154 */       return matcher.matches();
/*     */     }
/* 156 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean matchesSet(Advisor advisor, Field f)
/*     */   {
/* 161 */     if ((this.stats == null) || (this.stats.isSet()))
/*     */     {
/* 163 */       FieldMatcher matcher = new FieldSetMatcher(advisor, f, this.ast);
/* 164 */       return matcher.matches();
/*     */     }
/* 166 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean matchesExecution(Advisor advisor, CtMethod m) throws NotFoundException
/*     */   {
/*     */     try
/*     */     {
/* 173 */       if ((this.stats == null) || (this.stats.isExecution()))
/*     */       {
/* 175 */         ExecutionMethodMatcher matcher = new ExecutionMethodMatcher(advisor, m, this.ast);
/* 176 */         boolean match = matcher.matches();
/* 177 */         return match;
/*     */       }
/* 179 */       return false;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/* 183 */     throw new RuntimeException("Error parsing " + this.expr, e);
/*     */   }
/*     */ 
/*     */   public boolean matchesExecution(Advisor advisor, CtConstructor c)
/*     */     throws NotFoundException
/*     */   {
/* 189 */     if ((this.stats == null) || (this.stats.isExecution()))
/*     */     {
/* 191 */       ExecutionConstructorMatcher matcher = new ExecutionConstructorMatcher(advisor, c, this.ast);
/* 192 */       return matcher.matches();
/*     */     }
/* 194 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean matchesConstruction(Advisor advisor, CtConstructor c) throws NotFoundException
/*     */   {
/* 199 */     if ((this.stats == null) || (this.stats.isConstruction()))
/*     */     {
/* 201 */       ConstructionMatcher matcher = new ConstructionMatcher(advisor, c, this.ast);
/* 202 */       return matcher.matches();
/*     */     }
/* 204 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean matchesGet(Advisor advisor, CtField f) throws NotFoundException
/*     */   {
/* 209 */     if ((this.stats == null) || (this.stats.isGet()))
/*     */     {
/* 211 */       FieldMatcher matcher = new FieldGetMatcher(advisor, f, this.ast);
/* 212 */       return matcher.matches();
/*     */     }
/* 214 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean matchesSet(Advisor advisor, CtField f) throws NotFoundException
/*     */   {
/* 219 */     if ((this.stats == null) || (this.stats.isSet()))
/*     */     {
/* 221 */       FieldMatcher matcher = new FieldSetMatcher(advisor, f, this.ast);
/* 222 */       return matcher.matches();
/*     */     }
/* 224 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean matchesCall(Advisor advisor, AccessibleObject within, Class calledClass, Method calledMethod)
/*     */   {
/* 229 */     if ((this.stats == null) || (this.stats.isWithin()) || (this.stats.isWithincode()) || (this.stats.isCall()))
/*     */     {
/* 231 */       CallMatcher matcher = new CallMatcher(advisor, within, calledClass, calledMethod, this.ast);
/* 232 */       return matcher.matches();
/*     */     }
/* 234 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean matchesCall(Advisor advisor, AccessibleObject within, Class calledClass, Constructor calledCon)
/*     */   {
/* 240 */     if ((this.stats == null) || (this.stats.isWithin()) || (this.stats.isWithincode()) || (this.stats.isCall()))
/*     */     {
/* 242 */       ConstructorCallMatcher matcher = new ConstructorCallMatcher(advisor, within, calledClass, calledCon, this.ast);
/* 243 */       return matcher.matches();
/*     */     }
/* 245 */     return false;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 250 */     return "Pointcut[name=" + this.name + "; expr=" + this.expr + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.PointcutExpression
 * JD-Core Version:    0.6.0
 */