package org.jboss.aop.pointcut;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.MethodCall;
import javassist.expr.NewExpr;
import org.jboss.aop.Advisor;

public abstract interface Pointcut
{
  public abstract String getName();

  public abstract boolean softMatch(Advisor paramAdvisor);

  public abstract boolean matchesExecution(Advisor paramAdvisor, CtMethod paramCtMethod)
    throws NotFoundException;

  public abstract boolean matchesExecution(Advisor paramAdvisor, CtConstructor paramCtConstructor)
    throws NotFoundException;

  public abstract boolean matchesConstruction(Advisor paramAdvisor, CtConstructor paramCtConstructor)
    throws NotFoundException;

  public abstract boolean matchesGet(Advisor paramAdvisor, CtField paramCtField)
    throws NotFoundException;

  public abstract boolean matchesSet(Advisor paramAdvisor, CtField paramCtField)
    throws NotFoundException;

  public abstract boolean matchesCall(Advisor paramAdvisor, MethodCall paramMethodCall)
    throws NotFoundException;

  public abstract boolean matchesCall(Advisor paramAdvisor, NewExpr paramNewExpr)
    throws NotFoundException;

  public abstract PointcutMethodMatch matchesExecution(Advisor paramAdvisor, Method paramMethod);

  public abstract boolean matchesExecution(Advisor paramAdvisor, Constructor paramConstructor);

  public abstract boolean matchesConstruction(Advisor paramAdvisor, Constructor paramConstructor);

  public abstract boolean matchesGet(Advisor paramAdvisor, Field paramField);

  public abstract boolean matchesSet(Advisor paramAdvisor, Field paramField);

  public abstract boolean matchesCall(Advisor paramAdvisor, AccessibleObject paramAccessibleObject, Class paramClass, Method paramMethod);

  public abstract boolean matchesCall(Advisor paramAdvisor, AccessibleObject paramAccessibleObject, Class paramClass, Constructor paramConstructor);

  public abstract String getExpr();
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.Pointcut
 * JD-Core Version:    0.6.0
 */