/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.expr.MethodCall;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.pointcut.ast.ASTCall;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithin;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithincode;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ import org.jboss.aop.pointcut.ast.IdentifierExpression;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ 
/*     */ public class MethodCallMatcher extends MatcherHelper
/*     */ {
/*     */   MethodCall call;
/*     */   Advisor advisor;
/*     */ 
/*     */   public MethodCallMatcher(Advisor advisor, MethodCall call, ASTStart start)
/*     */     throws NotFoundException
/*     */   {
/*  53 */     super(start, advisor.getManager());
/*  54 */     this.advisor = advisor;
/*  55 */     this.call = call;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCall node, Object data)
/*     */   {
/*     */     try
/*     */     {
/*  62 */       if (!(node.getBehavior() instanceof ASTMethod)) return Boolean.FALSE;
/*     */ 
/*  64 */       ASTMethod astMethod = (ASTMethod)node.getBehavior();
/*     */ 
/*  67 */       if (astMethod.getClazz().isSimple())
/*     */       {
/*  69 */         if (!astMethod.getClazz().matches(this.call.getClassName())) return Boolean.FALSE;
/*  70 */         if (!astMethod.getMethodIdentifier().isAnnotation())
/*     */         {
/*  72 */           if (!astMethod.getMethodIdentifier().matches(this.call.getMethodName())) return Boolean.FALSE;
/*     */         }
/*     */       }
/*  75 */       CtMethod calledMethod = this.call.getMethod();
/*  76 */       Advisor calledAdvisor = AspectManager.instance().getTempClassAdvisor(calledMethod.getDeclaringClass());
/*  77 */       MethodMatcher methodMatcher = new MethodMatcher(calledAdvisor, calledMethod, null);
/*  78 */       return methodMatcher.matches(astMethod);
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  82 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/*     */     try
/*     */     {
/*  90 */       Node n = node.jjtGetChild(0);
/*  91 */       CtMethod method = this.call.getMethod();
/*  92 */       if ((n instanceof ASTMethod))
/*     */       {
/*  94 */         return new Boolean(Util.has(method.getDeclaringClass(), (ASTMethod)n, this.advisor));
/*     */       }
/*     */ 
/*  98 */       return new Boolean(Util.has(method.getDeclaringClass(), (ASTConstructor)n, this.advisor));
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/*     */     }
/* 103 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/* 109 */     ASTField f = (ASTField)node.jjtGetChild(0);
/* 110 */     CtMethod method = null;
/*     */     try
/*     */     {
/* 113 */       method = this.call.getMethod();
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 117 */       throw new RuntimeException(e);
/*     */     }
/* 119 */     return new Boolean(Util.has(method.getDeclaringClass(), f, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithin node, Object data)
/*     */   {
/* 124 */     WithinMatcher within = null;
/*     */     try
/*     */     {
/* 127 */       within = new WithinMatcher(this.advisor, this.call.where(), null);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 131 */       throw new RuntimeException(e);
/*     */     }
/* 133 */     return node.jjtAccept(within, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithincode node, Object data)
/*     */   {
/* 138 */     WithinMatcher within = null;
/*     */     try
/*     */     {
/* 141 */       within = new WithinMatcher(this.advisor, this.call.where(), null);
/*     */     }
/*     */     catch (NotFoundException e)
/*     */     {
/* 145 */       throw new RuntimeException(e);
/*     */     }
/* 147 */     return node.jjtAccept(within, null);
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/*     */     try
/*     */     {
/* 154 */       return new Boolean(p.matchesCall(this.advisor, this.call));
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 158 */     throw new RuntimeException(e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.MethodCallMatcher
 * JD-Core Version:    0.6.0
 */