/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import java.util.ArrayList;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtField;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.metadata.FieldMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.pointcut.ast.ASTAll;
/*     */ import org.jboss.aop.pointcut.ast.ASTAttribute;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTFieldExecution;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ import org.jboss.aop.pointcut.ast.IdentifierExpression;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ 
/*     */ public class FieldMatcher extends MatcherHelper
/*     */ {
/*     */   protected Advisor advisor;
/*     */   protected String classname;
/*     */   protected String fieldName;
/*     */   protected int fieldModifiers;
/*     */   protected CtField ctField;
/*     */   protected Field refField;
/*     */ 
/*     */   public FieldMatcher(Advisor advisor, CtField field, ASTStart start)
/*     */     throws NotFoundException
/*     */   {
/*  57 */     super(start, advisor.getManager());
/*  58 */     this.advisor = advisor;
/*  59 */     this.classname = field.getDeclaringClass().getName();
/*  60 */     this.start = start;
/*  61 */     this.fieldName = field.getName();
/*  62 */     this.fieldModifiers = field.getModifiers();
/*  63 */     this.ctField = field;
/*     */   }
/*     */ 
/*     */   public FieldMatcher(Advisor advisor, Field field, ASTStart start)
/*     */   {
/*  68 */     super(start, advisor.getManager());
/*  69 */     this.advisor = advisor;
/*  70 */     this.classname = field.getDeclaringClass().getName();
/*  71 */     this.start = start;
/*  72 */     this.fieldName = field.getName();
/*  73 */     this.fieldModifiers = field.getModifiers();
/*  74 */     this.refField = field;
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/*  79 */     throw new RuntimeException("SHOULD NOT BE CALLED");
/*     */   }
/*     */ 
/*     */   public Object visit(ASTField node, Object data)
/*     */   {
/*  85 */     if (node.getAttributes().size() > 0)
/*     */     {
/*  87 */       for (int i = 0; i < node.getAttributes().size(); i++)
/*     */       {
/*  89 */         ASTAttribute attr = (ASTAttribute)node.getAttributes().get(i);
/*  90 */         if (!Util.matchModifiers(attr, this.fieldModifiers))
/*     */         {
/*  92 */           return Boolean.FALSE;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/*  99 */       ClassExpression type = node.getType();
/* 100 */       if (this.ctField != null)
/*     */       {
/* 102 */         if (!Util.matchesClassExpr(type, this.ctField.getType(), this.advisor)) return Boolean.FALSE;
/* 103 */         if (!Util.matchesClassExpr(node.getClazz(), this.ctField.getDeclaringClass(), this.advisor)) return Boolean.FALSE;
/*     */       }
/*     */       else
/*     */       {
/* 107 */         if (!Util.matchesClassExpr(type, this.refField.getType(), this.advisor)) return Boolean.FALSE;
/* 108 */         if (!Util.matchesClassExpr(node.getClazz(), this.refField.getDeclaringClass(), this.advisor)) return Boolean.FALSE;
/*     */       }
/*     */     }
/*     */     catch (NotFoundException nfe)
/*     */     {
/* 113 */       throw new RuntimeException(nfe);
/*     */     }
/*     */ 
/* 116 */     if (node.getFieldIdentifier().isAnnotation())
/*     */     {
/* 118 */       String sub = node.getFieldIdentifier().getOriginal().substring(1);
/* 119 */       if ((this.advisor.getFieldMetaData().hasTag(this.fieldName, sub)) || (this.advisor.getDefaultMetaData().hasTag(sub)))
/*     */       {
/* 121 */         return Boolean.TRUE;
/*     */       }
/*     */       try
/*     */       {
/* 125 */         if (this.ctField != null)
/*     */         {
/* 127 */           if (this.advisor.hasAnnotation(this.ctField, sub))
/*     */           {
/* 129 */             return Boolean.TRUE;
/*     */           }
/*     */ 
/*     */         }
/* 134 */         else if (this.advisor.hasAnnotation(this.refField, sub))
/*     */         {
/* 136 */           return Boolean.TRUE;
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 142 */         throw new RuntimeException(e);
/*     */       }
/*     */ 
/*     */     }
/* 147 */     else if (node.getFieldIdentifier().matches(this.fieldName))
/*     */     {
/* 149 */       return Boolean.TRUE;
/*     */     }
/*     */ 
/* 152 */     return Boolean.FALSE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTFieldExecution node, Object data)
/*     */   {
/* 157 */     return node.jjtGetChild(0).jjtAccept(this, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAll node, Object data)
/*     */   {
/* 162 */     if (node.getClazz().isAnnotation())
/*     */     {
/* 164 */       String sub = node.getClazz().getOriginal().substring(1);
/* 165 */       if (!this.advisor.getFieldMetaData().hasTag(this.fieldName, sub))
/*     */       {
/* 167 */         if (!this.advisor.getDefaultMetaData().hasTag(sub))
/*     */         {
/* 169 */           if (this.ctField != null)
/*     */           {
/* 171 */             if (!this.advisor.hasAnnotation(this.ctField, sub)) return Boolean.FALSE;
/*     */           }
/*     */           else
/*     */           {
/*     */             try
/*     */             {
/* 177 */               if (!this.advisor.hasAnnotation(this.refField, sub)) return Boolean.FALSE;
/*     */             }
/*     */             catch (Exception e)
/*     */             {
/* 181 */               throw new RuntimeException(e);
/*     */             }
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/* 187 */     else if (node.getClazz().isInstanceOf())
/*     */     {
/* 189 */       if (this.ctField != null)
/*     */       {
/* 191 */         if (!Util.subtypeOf(this.ctField.getDeclaringClass(), node.getClazz(), this.advisor)) return Boolean.FALSE;
/*     */       }
/* 193 */       else if (!Util.subtypeOf(this.refField.getDeclaringClass(), node.getClazz(), this.advisor)) return Boolean.FALSE;
/*     */ 
/*     */     }
/* 196 */     else if (node.getClazz().isTypedef())
/*     */     {
/* 198 */       if (this.ctField != null)
/*     */       {
/*     */         try
/*     */         {
/* 202 */           if (!Util.matchesTypedef(this.ctField.getDeclaringClass(), node.getClazz(), this.advisor)) return Boolean.FALSE;
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 206 */           throw new RuntimeException(e);
/*     */         }
/*     */       }
/* 209 */       else if (!Util.matchesTypedef(this.refField.getDeclaringClass(), node.getClazz(), this.advisor)) return Boolean.FALSE;
/*     */     }
/* 211 */     else if (!node.getClazz().matches(this.classname))
/*     */     {
/* 213 */       return Boolean.FALSE;
/*     */     }
/*     */ 
/* 216 */     return Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/* 221 */     ASTField f = (ASTField)node.jjtGetChild(0);
/* 222 */     if (this.ctField != null) {
/* 223 */       return new Boolean(Util.has(this.ctField.getDeclaringClass(), f, this.advisor));
/*     */     }
/* 225 */     return new Boolean(Util.has(this.refField.getDeclaringClass(), f, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/* 230 */     Node n = node.jjtGetChild(0);
/* 231 */     if ((n instanceof ASTMethod))
/*     */     {
/* 233 */       if (this.ctField != null)
/*     */       {
/* 235 */         return new Boolean(Util.has(this.ctField.getDeclaringClass(), (ASTMethod)n, this.advisor));
/*     */       }
/*     */ 
/* 239 */       return new Boolean(Util.has(this.refField.getDeclaringClass(), (ASTMethod)n, this.advisor));
/*     */     }
/*     */ 
/* 245 */     if (this.refField != null)
/*     */     {
/* 247 */       return new Boolean(Util.has(this.ctField.getDeclaringClass(), (ASTConstructor)n, this.advisor));
/*     */     }
/*     */ 
/* 251 */     return new Boolean(Util.has(this.refField.getDeclaringClass(), (ASTConstructor)n, this.advisor));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.FieldMatcher
 * JD-Core Version:    0.6.0
 */