/*    */ package org.jboss.aop.pointcut;
/*    */ 
/*    */ import java.lang.reflect.Field;
/*    */ import javassist.CtField;
/*    */ import javassist.NotFoundException;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.pointcut.ast.ASTGet;
/*    */ import org.jboss.aop.pointcut.ast.ASTStart;
/*    */ import org.jboss.aop.pointcut.ast.Node;
/*    */ 
/*    */ public class FieldGetMatcher extends FieldMatcher
/*    */ {
/*    */   private CtField ctField;
/*    */   private Field field;
/*    */ 
/*    */   public FieldGetMatcher(Advisor advisor, CtField field, ASTStart start)
/*    */     throws NotFoundException
/*    */   {
/* 45 */     super(advisor, field, start);
/* 46 */     this.ctField = field;
/*    */   }
/*    */ 
/*    */   public FieldGetMatcher(Advisor advisor, Field field, ASTStart start)
/*    */   {
/* 51 */     super(advisor, field, start);
/* 52 */     this.field = field;
/*    */   }
/*    */ 
/*    */   public Object visit(ASTGet node, Object data)
/*    */   {
/* 57 */     return node.jjtGetChild(0).jjtAccept(this, null);
/*    */   }
/*    */ 
/*    */   protected Boolean resolvePointcut(Pointcut p)
/*    */   {
/* 62 */     if (this.ctField != null)
/*    */     {
/*    */       try
/*    */       {
/* 66 */         return new Boolean(p.matchesGet(this.advisor, this.ctField));
/*    */       }
/*    */       catch (NotFoundException e)
/*    */       {
/* 70 */         throw new RuntimeException(e);
/*    */       }
/*    */ 
/*    */     }
/*    */ 
/* 75 */     return new Boolean(p.matchesGet(this.advisor, this.field));
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.FieldGetMatcher
 * JD-Core Version:    0.6.0
 */