/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import javassist.CtMethod;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTExecution;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ 
/*     */ public class ExecutionMethodMatcher extends MethodMatcher
/*     */ {
/*     */   public ExecutionMethodMatcher(Advisor advisor, CtMethod method, ASTStart start)
/*     */     throws NotFoundException
/*     */   {
/*  48 */     super(advisor, method, start);
/*     */   }
/*     */ 
/*     */   public ExecutionMethodMatcher(Advisor advisor, Method method, ASTStart start)
/*     */   {
/*  53 */     super(advisor, method, start);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTExecution node, Object data)
/*     */   {
/*  58 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/*     */     try
/*     */     {
/*  65 */       if (this.refMethod != null)
/*     */       {
/*  67 */         PointcutMethodMatch pmatch = p.matchesExecution(this.advisor, this.refMethod);
/*  68 */         if ((pmatch != null) && (pmatch.isMatch()))
/*     */         {
/*  70 */           this.matchedClass = pmatch.getMatchedClass();
/*  71 */           this.matchLevel = pmatch.getMatchLevel();
/*  72 */           this.isInstanceof = pmatch.isInstanceOf();
/*  73 */           return Boolean.TRUE;
/*     */         }
/*  75 */         return Boolean.FALSE;
/*     */       }
/*  77 */       return new Boolean(p.matchesExecution(this.advisor, this.ctMethod));
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/*  81 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/*  87 */     Node n = node.jjtGetChild(0);
/*  88 */     if ((n instanceof ASTMethod))
/*     */     {
/*  90 */       if (this.ctMethod != null)
/*     */       {
/*  92 */         return new Boolean(Util.has(this.ctMethod.getDeclaringClass(), (ASTMethod)n, this.advisor));
/*     */       }
/*     */ 
/*  96 */       return new Boolean(Util.has(this.refMethod.getDeclaringClass(), (ASTMethod)n, this.advisor));
/*     */     }
/*     */ 
/* 102 */     if (this.ctMethod != null)
/*     */     {
/* 104 */       return new Boolean(Util.has(this.ctMethod.getDeclaringClass(), (ASTConstructor)n, this.advisor));
/*     */     }
/*     */ 
/* 108 */     return new Boolean(Util.has(this.refMethod.getDeclaringClass(), (ASTConstructor)n, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/* 116 */     ASTField f = (ASTField)node.jjtGetChild(0);
/* 117 */     if (this.ctMethod != null)
/*     */     {
/* 119 */       return new Boolean(Util.has(this.ctMethod.getDeclaringClass(), f, this.advisor));
/*     */     }
/*     */ 
/* 123 */     return new Boolean(Util.has(this.refMethod.getDeclaringClass(), f, this.advisor));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ExecutionMethodMatcher
 * JD-Core Version:    0.6.0
 */