/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTExecution;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ 
/*     */ public class ExecutionConstructorMatcher extends ConstructorMatcher
/*     */ {
/*     */   public ExecutionConstructorMatcher(Advisor advisor, CtConstructor con, ASTStart start)
/*     */     throws NotFoundException
/*     */   {
/*  48 */     super(advisor, con, start);
/*     */   }
/*     */ 
/*     */   public ExecutionConstructorMatcher(Advisor advisor, Constructor con, ASTStart start)
/*     */   {
/*  53 */     super(advisor, con, start);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTExecution node, Object data)
/*     */   {
/*  58 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/*  63 */     Node n = node.jjtGetChild(0);
/*  64 */     if ((n instanceof ASTMethod))
/*     */     {
/*  66 */       if (this.ctCon != null)
/*     */       {
/*  68 */         return new Boolean(Util.has(this.ctCon.getDeclaringClass(), (ASTMethod)n, this.advisor));
/*     */       }
/*     */ 
/*  72 */       return new Boolean(Util.has(this.refCon.getDeclaringClass(), (ASTMethod)n, this.advisor));
/*     */     }
/*     */ 
/*  78 */     if (this.ctCon != null)
/*     */     {
/*  80 */       return new Boolean(Util.has(this.ctCon.getDeclaringClass(), (ASTConstructor)n, this.advisor));
/*     */     }
/*     */ 
/*  84 */     return new Boolean(Util.has(this.refCon.getDeclaringClass(), (ASTConstructor)n, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/*  92 */     ASTField f = (ASTField)node.jjtGetChild(0);
/*  93 */     if (this.ctCon != null)
/*     */     {
/*  95 */       return new Boolean(Util.has(this.ctCon.getDeclaringClass(), f, this.advisor));
/*     */     }
/*     */ 
/*  99 */     return new Boolean(Util.has(this.refCon.getDeclaringClass(), f, this.advisor));
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/*     */     try
/*     */     {
/* 108 */       if (this.refCon != null) return new Boolean(p.matchesExecution(this.advisor, this.refCon));
/* 109 */       return new Boolean(p.matchesExecution(this.advisor, this.ctCon));
/*     */     }
/*     */     catch (NotFoundException e) {
/*     */     }
/* 113 */     throw new RuntimeException(e);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ExecutionConstructorMatcher
 * JD-Core Version:    0.6.0
 */