/*    */ package org.jboss.aop.pointcut;
/*    */ 
/*    */ import javassist.CtClass;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*    */ import org.jboss.aop.pointcut.ast.ASTField;
/*    */ import org.jboss.aop.pointcut.ast.ASTHas;
/*    */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*    */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*    */ import org.jboss.aop.pointcut.ast.Node;
/*    */ 
/*    */ public class DeclareTypeMatcher extends TypeMatcher
/*    */ {
/*    */   public DeclareTypeMatcher(Advisor advisor, Class clazz)
/*    */   {
/* 46 */     super(advisor, clazz);
/*    */   }
/*    */ 
/*    */   public DeclareTypeMatcher(Advisor advisor, CtClass ctClass)
/*    */   {
/* 51 */     super(advisor, ctClass);
/*    */   }
/*    */ 
/*    */   public Object visit(ASTHas node, Object data)
/*    */   {
/* 56 */     Node n = node.jjtGetChild(0);
/* 57 */     if ((n instanceof ASTMethod))
/*    */     {
/* 59 */       boolean checkSuper = false;
/* 60 */       if (this.clazz != null) return new Boolean(Util.has(this.clazz, (ASTMethod)n, this.advisor, checkSuper));
/* 61 */       if (this.ctClass != null) return new Boolean(Util.has(this.ctClass, (ASTMethod)n, this.advisor, checkSuper));
/*    */ 
/*    */     }
/*    */     else
/*    */     {
/* 66 */       if (this.clazz != null) return new Boolean(Util.has(this.clazz, (ASTConstructor)n, this.advisor));
/* 67 */       if (this.ctClass != null) return new Boolean(Util.has(this.ctClass, (ASTConstructor)n, this.advisor));
/*    */     }
/* 69 */     return Boolean.FALSE;
/*    */   }
/*    */ 
/*    */   public Object visit(ASTHasField node, Object data)
/*    */   {
/* 74 */     boolean checkSuper = false;
/* 75 */     ASTField f = (ASTField)node.jjtGetChild(0);
/* 76 */     if (this.clazz != null) {
/* 77 */       return new Boolean(Util.has(this.clazz, f, this.advisor, checkSuper));
/*    */     }
/* 79 */     return new Boolean(Util.has(this.ctClass, f, this.advisor, checkSuper));
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.DeclareTypeMatcher
 * JD-Core Version:    0.6.0
 */