/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.io.StringReader;
/*     */ import javassist.CtClass;
/*     */ import javassist.NotFoundException;
/*     */ import javassist.expr.MethodCall;
/*     */ import javassist.expr.NewExpr;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ParseException;
/*     */ import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
/*     */ import org.jboss.aop.pointcut.ast.TypeExpressionParser;
/*     */ 
/*     */ public class DeclareDef
/*     */ {
/*     */   String name;
/*     */   String expr;
/*     */   boolean warning;
/*     */   String msg;
/*     */   ASTStart ast;
/*     */   boolean pointcut;
/*     */ 
/*     */   public DeclareDef(String name, String expr, boolean warning, String msg)
/*     */     throws ParseException
/*     */   {
/*  53 */     this.name = name;
/*  54 */     this.expr = expr;
/*  55 */     this.warning = warning;
/*  56 */     this.msg = msg;
/*     */     try
/*     */     {
/*  60 */       this.ast = new PointcutExpressionParser(new StringReader(expr)).Start();
/*  61 */       this.pointcut = true;
/*     */     }
/*     */     catch (ParseException pe)
/*     */     {
/*     */       try
/*     */       {
/*  67 */         this.ast = new TypeExpressionParser(new StringReader(expr)).Start();
/*     */       }
/*     */       catch (ParseException te)
/*     */       {
/*  71 */         StringBuffer sb = new StringBuffer("The expression '" + expr + "' resolves to neither a pointcut nor a type expression");
/*     */ 
/*  73 */         sb.append("\n\nPointcut parse error:\n");
/*  74 */         sb.append(pe.getMessage());
/*  75 */         sb.append("\n\nType expression parse error:\n");
/*  76 */         sb.append(te.getMessage());
/*  77 */         throw new ParseException(sb.toString());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public ASTStart getAst()
/*     */   {
/*  85 */     return this.ast;
/*     */   }
/*     */ 
/*     */   public String getExpr()
/*     */   {
/*  90 */     return this.expr;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  95 */     return this.name;
/*     */   }
/*     */ 
/*     */   public boolean getWarning()
/*     */   {
/* 100 */     return this.warning;
/*     */   }
/*     */ 
/*     */   public String getMsg()
/*     */   {
/* 105 */     return this.msg;
/*     */   }
/*     */ 
/*     */   public boolean isPointcut()
/*     */   {
/* 113 */     return this.pointcut;
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, CtClass clazz)
/*     */   {
/* 118 */     if (this.pointcut) return false;
/* 119 */     DeclareTypeMatcher matcher = new DeclareTypeMatcher(advisor, clazz);
/* 120 */     return ((Boolean)this.ast.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, Class clazz)
/*     */   {
/* 125 */     if (this.pointcut) return false;
/* 126 */     DeclareTypeMatcher matcher = new DeclareTypeMatcher(advisor, clazz);
/* 127 */     return ((Boolean)this.ast.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public boolean matchesCall(Advisor callingAdvisor, MethodCall methodCall) throws NotFoundException
/*     */   {
/* 132 */     if (!this.pointcut) return false;
/* 133 */     MethodCallMatcher matcher = new MethodCallMatcher(callingAdvisor, methodCall, this.ast);
/* 134 */     return matcher.matches();
/*     */   }
/*     */ 
/*     */   public boolean matchesCall(Advisor callingAdvisor, NewExpr methodCall) throws NotFoundException
/*     */   {
/* 139 */     if (!this.pointcut) return false;
/* 140 */     NewExprMatcher matcher = new NewExprMatcher(callingAdvisor, methodCall, this.ast);
/* 141 */     return matcher.matches();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.DeclareDef
 * JD-Core Version:    0.6.0
 */