/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.Constructor;
/*     */ import java.util.ArrayList;
/*     */ import javassist.CtClass;
/*     */ import javassist.CtConstructor;
/*     */ import javassist.NotFoundException;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.metadata.ConstructorMetaData;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.pointcut.ast.ASTAll;
/*     */ import org.jboss.aop.pointcut.ast.ASTAttribute;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ import org.jboss.aop.pointcut.ast.IdentifierExpression;
/*     */ 
/*     */ public class ConstructorMatcher extends MatcherHelper
/*     */ {
/*     */   protected Advisor advisor;
/*     */   protected CtConstructor ctCon;
/*     */   protected Constructor refCon;
/*     */   protected int conModifiers;
/*     */   protected String classname;
/*     */ 
/*     */   public ConstructorMatcher(Advisor advisor, CtConstructor con, ASTStart start)
/*     */     throws NotFoundException
/*     */   {
/*  51 */     super(start, advisor.getManager());
/*  52 */     this.advisor = advisor;
/*  53 */     this.start = start;
/*  54 */     this.conModifiers = con.getModifiers();
/*  55 */     this.classname = con.getDeclaringClass().getName();
/*  56 */     this.ctCon = con;
/*     */   }
/*     */ 
/*     */   public ConstructorMatcher(Advisor advisor, Constructor con, ASTStart start)
/*     */   {
/*  61 */     super(start, advisor.getManager());
/*  62 */     this.advisor = advisor;
/*  63 */     this.start = start;
/*  64 */     this.conModifiers = con.getModifiers();
/*  65 */     this.classname = con.getDeclaringClass().getName();
/*  66 */     this.refCon = con;
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/*  71 */     throw new RuntimeException("SHOULD NOT BE CALLED");
/*     */   }
/*     */ 
/*     */   public Object visit(ASTConstructor node, Object data)
/*     */   {
/*  76 */     return matches(node);
/*     */   }
/*     */ 
/*     */   public Boolean matches(ASTConstructor node)
/*     */   {
/*  81 */     if (node.getAttributes().size() > 0)
/*     */     {
/*  83 */       for (int i = 0; i < node.getAttributes().size(); i++)
/*     */       {
/*  85 */         ASTAttribute attr = (ASTAttribute)node.getAttributes().get(i);
/*  86 */         if (!Util.matchModifiers(attr, this.conModifiers)) return Boolean.FALSE;
/*     */       }
/*     */     }
/*     */ 
/*  90 */     if (this.ctCon != null)
/*     */     {
/*  92 */       if (!Util.matchesClassExpr(node.getClazz(), this.ctCon.getDeclaringClass(), this.advisor)) return Boolean.FALSE;
/*     */ 
/*     */     }
/*  96 */     else if (!Util.matchesClassExpr(node.getClazz(), this.refCon.getDeclaringClass(), this.advisor)) return Boolean.FALSE;
/*     */ 
/* 100 */     if (node.getConstructorAnnotation() != null)
/*     */     {
/* 102 */       String sub = node.getConstructorAnnotation().getOriginal().substring(1);
/* 103 */       if (this.ctCon != null)
/*     */       {
/* 105 */         if (!this.advisor.getConstructorMetaData().hasGroup(this.ctCon, sub))
/*     */         {
/* 107 */           if (!this.advisor.getDefaultMetaData().hasTag(sub))
/*     */           {
/* 109 */             if (!this.advisor.hasAnnotation(this.ctCon, sub)) return Boolean.FALSE;
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/* 115 */       else if (!this.advisor.getConstructorMetaData().hasTag(this.refCon, sub))
/*     */       {
/* 117 */         if (!this.advisor.getDefaultMetaData().hasTag(sub))
/*     */         {
/*     */           try
/*     */           {
/* 121 */             if (!this.advisor.hasAnnotation(this.refCon, sub)) return Boolean.FALSE;
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 125 */             throw new RuntimeException(e);
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 133 */     ArrayList nodeExceptions = node.getExceptions();
/* 134 */     if (nodeExceptions.size() > 0)
/*     */     {
/* 136 */       if (this.ctCon != null)
/*     */       {
/*     */         try
/*     */         {
/* 140 */           if (!Util.matchExceptions(nodeExceptions, this.ctCon.getExceptionTypes()))
/*     */           {
/* 142 */             return Boolean.FALSE;
/*     */           }
/*     */         }
/*     */         catch (NotFoundException e)
/*     */         {
/* 147 */           throw new RuntimeException(e);
/*     */         }
/*     */ 
/*     */       }
/* 152 */       else if (!Util.matchExceptions(nodeExceptions, this.refCon.getExceptionTypes()))
/*     */       {
/* 154 */         return Boolean.FALSE;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 159 */     if (this.ctCon != null)
/*     */     {
/* 161 */       if (!Util.matchesParameters(this.advisor, node, this.ctCon)) return Boolean.FALSE;
/*     */ 
/*     */     }
/* 165 */     else if (!Util.matchesParameters(this.advisor, node, this.refCon)) return Boolean.FALSE;
/*     */ 
/* 167 */     return Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAll node, Object data)
/*     */   {
/* 172 */     if (node.getClazz().isAnnotation())
/*     */     {
/* 174 */       String sub = node.getClazz().getOriginal().substring(1);
/* 175 */       if (this.ctCon != null)
/*     */       {
/* 177 */         if (!this.advisor.getConstructorMetaData().hasGroup(this.ctCon, sub))
/*     */         {
/* 179 */           if (!this.advisor.getDefaultMetaData().hasTag(sub))
/*     */           {
/* 181 */             if (!this.advisor.hasAnnotation(this.ctCon, sub))
/*     */             {
/* 183 */               return Boolean.FALSE;
/*     */             }
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/* 190 */       else if (!this.advisor.getConstructorMetaData().hasTag(this.refCon, sub))
/*     */       {
/* 192 */         if (!this.advisor.getDefaultMetaData().hasTag(sub))
/*     */         {
/*     */           try
/*     */           {
/* 196 */             if (!this.advisor.hasAnnotation(this.refCon, sub)) return Boolean.FALSE;
/*     */           }
/*     */           catch (Exception e)
/*     */           {
/* 200 */             throw new RuntimeException(e);
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/* 206 */     else if (node.getClazz().isInstanceOf())
/*     */     {
/* 208 */       if (this.ctCon != null)
/*     */       {
/* 210 */         if (!Util.subtypeOf(this.ctCon.getDeclaringClass(), node.getClazz(), this.advisor)) return Boolean.FALSE;
/*     */       }
/* 212 */       else if (!Util.subtypeOf(this.refCon.getDeclaringClass(), node.getClazz(), this.advisor)) return Boolean.FALSE;
/*     */ 
/*     */     }
/* 215 */     else if (node.getClazz().isTypedef())
/*     */     {
/* 217 */       if (this.ctCon != null)
/*     */       {
/*     */         try
/*     */         {
/* 221 */           if (!Util.matchesTypedef(this.ctCon.getDeclaringClass(), node.getClazz(), this.advisor)) return Boolean.FALSE;
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 225 */           throw new RuntimeException(e);
/*     */         }
/*     */       }
/* 228 */       else if (!Util.matchesTypedef(this.refCon.getDeclaringClass(), node.getClazz(), this.advisor)) return Boolean.FALSE;
/*     */     }
/* 230 */     else if (!node.getClazz().matches(this.classname))
/*     */     {
/* 232 */       return Boolean.FALSE;
/*     */     }
/*     */ 
/* 235 */     return Boolean.TRUE;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.ConstructorMatcher
 * JD-Core Version:    0.6.0
 */