/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.pointcut.ast.ASTCall;
/*     */ import org.jboss.aop.pointcut.ast.ASTConstructor;
/*     */ import org.jboss.aop.pointcut.ast.ASTField;
/*     */ import org.jboss.aop.pointcut.ast.ASTHas;
/*     */ import org.jboss.aop.pointcut.ast.ASTHasField;
/*     */ import org.jboss.aop.pointcut.ast.ASTMethod;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithin;
/*     */ import org.jboss.aop.pointcut.ast.ASTWithincode;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ 
/*     */ public class CallMatcher extends MatcherHelper
/*     */ {
/*     */   Advisor advisor;
/*     */   AccessibleObject within;
/*     */   Class calledClass;
/*     */   Method calledMethod;
/*     */ 
/*     */   public CallMatcher(Advisor advisor, AccessibleObject within, Class calledClass, Method calledMethod, ASTStart start)
/*     */   {
/*  55 */     super(start, advisor.getManager());
/*  56 */     this.advisor = advisor;
/*  57 */     this.within = within;
/*  58 */     this.calledClass = calledClass;
/*  59 */     this.calledMethod = calledMethod;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCall node, Object data)
/*     */   {
/*     */     try
/*     */     {
/*  66 */       if (!(node.getBehavior() instanceof ASTMethod)) return Boolean.FALSE;
/*  67 */       ASTMethod astMethod = (ASTMethod)node.getBehavior();
/*  68 */       Advisor calledAdvisor = AspectManager.instance().getTempClassAdvisorIfNotExist(this.calledClass);
/*  69 */       MethodMatcher methodMatcher = new MethodMatcher(calledAdvisor, this.calledMethod, null);
/*  70 */       if (!methodMatcher.matches(astMethod).booleanValue()) return Boolean.FALSE;
/*  71 */       return Boolean.TRUE;
/*     */     }
/*     */     catch (Exception e) {
/*     */     }
/*  75 */     throw new RuntimeException(e);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHas node, Object data)
/*     */   {
/*  81 */     Node n = node.jjtGetChild(0);
/*  82 */     if ((n instanceof ASTMethod))
/*     */     {
/*  84 */       return new Boolean(Util.has(this.calledClass, (ASTMethod)n, this.advisor));
/*     */     }
/*     */ 
/*  88 */     return new Boolean(Util.has(this.calledClass, (ASTConstructor)n, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTHasField node, Object data)
/*     */   {
/*  94 */     ASTField f = (ASTField)node.jjtGetChild(0);
/*  95 */     return new Boolean(Util.has(this.calledClass, f, this.advisor));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithin node, Object data)
/*     */   {
/* 100 */     WithinMatcher visitor = new WithinMatcher(this.advisor, this.within, null);
/* 101 */     return node.jjtAccept(visitor, null);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTWithincode node, Object data)
/*     */   {
/* 106 */     WithinMatcher visitor = new WithinMatcher(this.advisor, this.within, null);
/* 107 */     return node.jjtAccept(visitor, null);
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/* 112 */     return new Boolean(p.matchesCall(this.advisor, this.within, this.calledClass, this.calledMethod));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.CallMatcher
 * JD-Core Version:    0.6.0
 */