/*     */ package org.jboss.aop.pointcut;
/*     */ 
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.pointcut.ast.ASTAndCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlowBoolean;
/*     */ import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
/*     */ import org.jboss.aop.pointcut.ast.ASTCompositeCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTNotCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTOrCFlow;
/*     */ import org.jboss.aop.pointcut.ast.ASTSubCFlow;
/*     */ import org.jboss.aop.pointcut.ast.Node;
/*     */ 
/*     */ public class CFlowMatcher extends MatcherHelper
/*     */ {
/*     */   StackTraceElement[] stack;
/*     */   Invocation invocation;
/*     */ 
/*     */   public CFlowMatcher()
/*     */   {
/*  49 */     super(null, null);
/*     */   }
/*     */ 
/*     */   public boolean matches(ASTCFlowExpression expr, Invocation invocation)
/*     */   {
/*  54 */     this.invocation = invocation;
/*  55 */     Boolean rtn = (Boolean)expr.jjtAccept(this, null);
/*  56 */     return rtn.booleanValue();
/*     */   }
/*     */ 
/*     */   private StackTraceElement[] getStack()
/*     */   {
/*  61 */     this.stack = new Throwable().getStackTrace();
/*  62 */     return this.stack;
/*     */   }
/*     */ 
/*     */   protected Boolean resolvePointcut(Pointcut p)
/*     */   {
/*  67 */     throw new RuntimeException("SHOULD NOT BE REACHABLE");
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlowExpression node, Object data)
/*     */   {
/*  73 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlowBoolean node, Object data)
/*     */   {
/*  78 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTNotCFlow node, Object data)
/*     */   {
/*  83 */     Boolean bool = (Boolean)node.jjtGetChild(0).jjtAccept(this, data);
/*  84 */     boolean val = bool.booleanValue();
/*  85 */     return val ? Boolean.FALSE : Boolean.TRUE;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCompositeCFlow node, Object data)
/*     */   {
/*  90 */     return node.jjtGetChild(0).jjtAccept(this, data);
/*     */   }
/*     */ 
/*     */   public Object visit(ASTSubCFlow node, Object data)
/*     */   {
/*  95 */     for (int i = 0; i < node.jjtGetNumChildren(); i++)
/*     */     {
/*  97 */       data = node.jjtGetChild(i).jjtAccept(this, data);
/*     */     }
/*  99 */     return data;
/*     */   }
/*     */ 
/*     */   public Object visit(ASTAndCFlow node, Object left)
/*     */   {
/* 104 */     Node andChild = node.jjtGetChild(0);
/* 105 */     boolean val = ((Boolean)left).booleanValue();
/* 106 */     return new Boolean((val) && (((Boolean)andChild.jjtAccept(this, Boolean.FALSE)).booleanValue()));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTOrCFlow node, Object left)
/*     */   {
/* 111 */     Node orChild = node.jjtGetChild(0);
/* 112 */     boolean val = ((Boolean)left).booleanValue();
/* 113 */     return new Boolean((val) || (((Boolean)orChild.jjtAccept(this, Boolean.FALSE)).booleanValue()));
/*     */   }
/*     */ 
/*     */   public Object visit(ASTCFlow node, Object data)
/*     */   {
/* 118 */     AspectManager manager = null;
/* 119 */     if (this.invocation.getAdvisor() == null)
/* 120 */       manager = AspectManager.instance();
/*     */     else
/* 122 */       manager = this.invocation.getAdvisor().getManager();
/* 123 */     CFlowStack cflow = manager.getCFlowStack(node.getPointcutName());
/* 124 */     if (cflow != null) return new Boolean(cflow.matches(getStack()));
/*     */ 
/* 126 */     DynamicCFlow dcflow = manager.getDynamicCFlow(node.getPointcutName());
/* 127 */     return new Boolean(dcflow.shouldExecute(this.invocation));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.pointcut.CFlowMatcher
 * JD-Core Version:    0.6.0
 */