/*    */ package org.jboss.aop.microcontainer.lifecycle;
/*    */ 
/*    */ import java.util.LinkedHashMap;
/*    */ import java.util.Map;
/*    */ import org.jboss.aop.AspectManager;
/*    */ import org.jboss.aop.advice.AspectDefinition;
/*    */ 
/*    */ public class LifecycleManager
/*    */ {
/*    */   AspectManager manager;
/* 38 */   Map<String, AspectDefinition> lifecycles = new LinkedHashMap();
/* 39 */   Map<String, LifecycleCallbackBinding> lifecycleBindings = new LinkedHashMap();
/*    */ 
/*    */   public LifecycleManager(AspectManager manager)
/*    */   {
/* 43 */     this.manager = manager;
/*    */   }
/*    */ 
/*    */   public void addLifecycleDefinition(AspectDefinition def)
/*    */   {
/* 48 */     AspectDefinition old = (AspectDefinition)this.lifecycles.put(def.getName(), def);
/* 49 */     if (old != null)
/*    */     {
/* 51 */       old.undeploy();
/*    */     }
/*    */   }
/*    */ 
/*    */   public void removeLifecycleDefinition(String name)
/*    */   {
/* 57 */     this.lifecycles.remove(name);
/*    */   }
/*    */ 
/*    */   public void addLifecycleBinding(LifecycleCallbackBinding lifecycleBinding)
/*    */   {
/* 62 */     this.lifecycleBindings.put(lifecycleBinding.getName(), lifecycleBinding);
/*    */   }
/*    */ 
/*    */   public void removeLifecycleBinding(String name)
/*    */   {
/* 67 */     this.lifecycleBindings.remove(name);
/*    */   }
/*    */ 
/*    */   public Map<String, LifecycleCallbackBinding> getLifecycleBindings()
/*    */   {
/* 72 */     return this.lifecycleBindings;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.lifecycle.LifecycleManager
 * JD-Core Version:    0.6.0
 */