/*     */ package org.jboss.aop.microcontainer.lifecycle;
/*     */ 
/*     */ import java.io.StringReader;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.Advisor;
/*     */ import org.jboss.aop.pointcut.TypeMatcher;
/*     */ import org.jboss.aop.pointcut.Util;
/*     */ import org.jboss.aop.pointcut.ast.ASTStart;
/*     */ import org.jboss.aop.pointcut.ast.ClassExpression;
/*     */ import org.jboss.aop.pointcut.ast.TypeExpressionParser;
/*     */ 
/*     */ public class LifecycleCallbackBinding
/*     */ {
/*     */   protected String name;
/*     */   protected ClassExpression classes;
/*     */   protected ASTStart ast;
/*  61 */   List<LifecycleCallbackDefinition> lifecycleCallbackDefinitions = new ArrayList();
/*     */   Object controllerState;
/*     */ 
/*     */   public LifecycleCallbackBinding(String name, String classString, String typeExpression, Object controllerState)
/*     */     throws Exception
/*     */   {
/*  71 */     this.name = name;
/*     */ 
/*  73 */     if ((classString == null) && (typeExpression == null))
/*     */     {
/*  75 */       throw new RuntimeException("Need either classString or typeExpression");
/*     */     }
/*  77 */     if ((classString != null) && (typeExpression != null))
/*     */     {
/*  79 */       throw new RuntimeException("Should not use both classString and typeExpression");
/*     */     }
/*     */ 
/*  82 */     if (classString != null)
/*     */     {
/*  84 */       this.classes = new ClassExpression(classString);
/*     */     }
/*  86 */     else if (typeExpression != null)
/*     */     {
/*  88 */       this.ast = new TypeExpressionParser(new StringReader(typeExpression)).Start();
/*     */     }
/*     */ 
/*  91 */     this.controllerState = controllerState;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/*  96 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void addLifecycleCallback(String bean, String installMethod, String uninstallMethod)
/*     */   {
/* 101 */     this.lifecycleCallbackDefinitions.add(new LifecycleCallbackDefinition(bean, installMethod, uninstallMethod));
/*     */   }
/*     */ 
/*     */   public List<LifecycleCallbackDefinition> getLifecycleCallbacks()
/*     */   {
/* 106 */     return this.lifecycleCallbackDefinitions;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/* 111 */     if (obj == this) return true;
/* 112 */     if (!(obj instanceof LifecycleCallbackBinding)) return false;
/* 113 */     return ((LifecycleCallbackBinding)obj).getName().equals(this.name);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 118 */     return this.name.hashCode();
/*     */   }
/*     */ 
/*     */   public boolean matches(Advisor advisor, Class clazz)
/*     */   {
/* 123 */     if (this.classes != null)
/*     */     {
/* 125 */       return Util.matchesClassExpr(this.classes, clazz, advisor);
/*     */     }
/*     */ 
/* 129 */     TypeMatcher matcher = new TypeMatcher(advisor, clazz);
/* 130 */     return ((Boolean)this.ast.jjtAccept(matcher, null)).booleanValue();
/*     */   }
/*     */ 
/*     */   public Object getControllerState()
/*     */   {
/* 136 */     return this.controllerState;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.lifecycle.LifecycleCallbackBinding
 * JD-Core Version:    0.6.0
 */