/*    */ package org.jboss.aop.microcontainer.junit;
/*    */ 
/*    */ import org.jboss.dependency.plugins.AbstractController;
/*    */ import org.jboss.dependency.spi.Controller;
/*    */ import org.jboss.dependency.spi.ControllerContext;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.kernel.Kernel;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ 
/*    */ public class ScopingAOPMicrocontainerTestDelegate extends AOPMicrocontainerTestDelegate
/*    */ {
/*    */   public ScopingAOPMicrocontainerTestDelegate(Class clazz)
/*    */     throws Exception
/*    */   {
/* 41 */     super(clazz);
/*    */   }
/*    */ 
/*    */   protected KernelControllerContext getControllerContext(Object name, ControllerState state)
/*    */   {
/*    */     try
/*    */     {
/* 48 */       Controller controller = new TestController((AbstractController)this.kernel.getController());
/* 49 */       KernelControllerContext context = (KernelControllerContext)controller.getContext(name, state);
/* 50 */       if (context == null)
/* 51 */         throw new IllegalStateException("Bean not found " + name + " at state " + state);
/* 52 */       return context;
/*    */     }
/*    */     catch (Exception e) {
/*    */     }
/* 56 */     throw new Error(e);
/*    */   }
/*    */ 
/*    */   private class TestController extends AbstractController
/*    */   {
/*    */     private AbstractController delegate;
/*    */ 
/*    */     public TestController(AbstractController controller) throws Exception
/*    */     {
/* 66 */       this.delegate = controller;
/*    */     }
/*    */ 
/*    */     public ControllerContext getContext(Object name, ControllerState state)
/*    */     {
/* 71 */       return findContext(this.delegate, name, state);
/*    */     }
/*    */ 
/*    */     private ControllerContext findContext(AbstractController controller, Object name, ControllerState state)
/*    */     {
/* 76 */       ControllerContext context = controller.getContext(name, state);
/* 77 */       if (context != null)
/*    */       {
/* 79 */         return context;
/*    */       }
/*    */ 
/* 83 */       for (AbstractController childController : controller.getControllers())
/*    */       {
/* 85 */         ControllerContext ctx = findContext(childController, name, state);
/* 86 */         if (ctx != null) {
/* 87 */           return ctx;
/*    */         }
/*    */       }
/* 90 */       return null;
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.junit.ScopingAOPMicrocontainerTestDelegate
 * JD-Core Version:    0.6.0
 */