/*     */ package org.jboss.aop.microcontainer.junit;
/*     */ 
/*     */ import java.net.URL;
/*     */ import org.jboss.aop.AspectXmlLoader;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.test.AbstractTestDelegate;
/*     */ 
/*     */ public class AbstractProxyTestDelegate extends AbstractTestDelegate
/*     */ {
/*     */   public AbstractProxyTestDelegate(Class clazz)
/*     */     throws Exception
/*     */   {
/*  45 */     super(clazz);
/*     */   }
/*     */ 
/*     */   public void setUp() throws Exception
/*     */   {
/*  50 */     super.setUp();
/*     */ 
/*  52 */     this.log.debug("Security enabled: " + this.enableSecurity);
/*     */     try
/*     */     {
/*  56 */       deploy();
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/*  60 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  64 */       throw e;
/*     */     }
/*     */     catch (Error e)
/*     */     {
/*  68 */       throw e;
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/*  72 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void tearDown() throws Exception
/*     */   {
/*  78 */     super.tearDown();
/*  79 */     undeploy();
/*     */   }
/*     */ 
/*     */   protected void deploy()
/*     */     throws Exception
/*     */   {
/*  89 */     String testName = this.clazz.getName();
/*  90 */     testName = testName.replace('.', '/') + ".xml";
/*  91 */     URL url = this.clazz.getClassLoader().getResource(testName);
/*  92 */     if (url != null)
/*  93 */       deploy(url);
/*     */     else
/*  95 */       throw new RuntimeException("No test specific deployment " + testName);
/*     */   }
/*     */ 
/*     */   protected void undeploy()
/*     */   {
/* 103 */     String testName = this.clazz.getName();
/* 104 */     testName = testName.replace('.', '/') + ".xml";
/* 105 */     URL url = this.clazz.getClassLoader().getResource(testName);
/* 106 */     if (url != null)
/* 107 */       undeploy(url);
/*     */     else
/* 109 */       this.log.debug("No test specific deployment " + testName);
/*     */   }
/*     */ 
/*     */   protected URL getTestURL()
/*     */   {
/* 119 */     String testName = this.clazz.getName();
/* 120 */     testName = testName.replace('.', '/') + ".xml";
/* 121 */     return this.clazz.getClassLoader().getResource(testName);
/*     */   }
/*     */ 
/*     */   protected void deploy(URL url)
/*     */     throws Exception
/*     */   {
/* 132 */     this.log.debug("Deploying " + url);
/* 133 */     AspectXmlLoader.deployXML(url);
/*     */   }
/*     */ 
/*     */   protected void undeploy(URL url)
/*     */   {
/*     */     try
/*     */     {
/* 145 */       this.log.debug("Undeploying " + url);
/* 146 */       AspectXmlLoader.undeployXML(url);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 150 */       this.log.warn("Ignored error undeploying " + url, e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.junit.AbstractProxyTestDelegate
 * JD-Core Version:    0.6.0
 */