/*     */ package org.jboss.aop.microcontainer.junit;
/*     */ 
/*     */ import java.util.HashSet;
/*     */ import java.util.Set;
/*     */ import org.jboss.aop.metadata.SimpleMetaData;
/*     */ import org.jboss.aop.proxy.container.AOPProxyFactory;
/*     */ import org.jboss.aop.proxy.container.AOPProxyFactoryMixin;
/*     */ import org.jboss.aop.proxy.container.AOPProxyFactoryParameters;
/*     */ import org.jboss.aop.proxy.container.GeneratedAOPProxyFactory;
/*     */ import org.jboss.test.AbstractTestCaseWithSetup;
/*     */ import org.jboss.test.AbstractTestDelegate;
/*     */ 
/*     */ public abstract class AbstractProxyTest extends AbstractTestCaseWithSetup
/*     */ {
/*     */   protected AOPProxyFactory proxyFactory;
/*     */ 
/*     */   public static AbstractTestDelegate getDelegate(Class clazz)
/*     */     throws Exception
/*     */   {
/*  55 */     String property = System.getProperty("jboss.mc.secure", "false");
/*  56 */     boolean enableSecurity = Boolean.valueOf(property).booleanValue();
/*  57 */     AbstractProxyTestDelegate delegate = new AbstractProxyTestDelegate(clazz);
/*  58 */     delegate.enableSecurity = enableSecurity;
/*  59 */     return delegate;
/*     */   }
/*     */ 
/*     */   public AbstractProxyTest(String name)
/*     */   {
/*  69 */     super(name);
/*     */   }
/*     */ 
/*     */   protected void setUp() throws Exception
/*     */   {
/*  74 */     super.setUp();
/*  75 */     configureLogging();
/*  76 */     this.proxyFactory = new GeneratedAOPProxyFactory();
/*     */   }
/*     */ 
/*     */   protected Object createProxy(Object target)
/*     */     throws Exception
/*     */   {
/*  88 */     AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
/*  89 */     params.setProxiedClass(target.getClass());
/*  90 */     params.setTarget(target);
/*  91 */     return this.proxyFactory.createAdvisedProxy(params);
/*     */   }
/*     */ 
/*     */   protected Object assertCreateProxy(Object target, Class expected)
/*     */     throws Exception
/*     */   {
/* 104 */     Object proxy = createProxy(target);
/* 105 */     assertNotNull(proxy);
/* 106 */     assertTrue("Proxy " + proxy + " should implement " + expected.getName() + " interfaces=" + getInterfaces(proxy), expected.isInstance(proxy));
/* 107 */     return proxy;
/*     */   }
/*     */ 
/*     */   protected Object createProxy(Object target, Class[] interfaces)
/*     */     throws Exception
/*     */   {
/* 120 */     AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
/* 121 */     params.setProxiedClass(target.getClass());
/* 122 */     params.setInterfaces(interfaces);
/* 123 */     params.setTarget(target);
/* 124 */     return this.proxyFactory.createAdvisedProxy(params);
/*     */   }
/*     */ 
/*     */   protected Object createProxy(Object target, AOPProxyFactoryMixin[] mixins)
/*     */     throws Exception
/*     */   {
/* 137 */     AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
/* 138 */     params.setProxiedClass(target.getClass());
/* 139 */     params.setMixins(mixins);
/* 140 */     params.setTarget(target);
/* 141 */     return this.proxyFactory.createAdvisedProxy(params);
/*     */   }
/*     */ 
/*     */   protected Object createProxy(Object target, Class[] interfaces, AOPProxyFactoryMixin[] mixins)
/*     */     throws Exception
/*     */   {
/* 155 */     AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
/* 156 */     params.setProxiedClass(target.getClass());
/* 157 */     params.setInterfaces(interfaces);
/* 158 */     params.setMixins(mixins);
/* 159 */     params.setTarget(target);
/* 160 */     return this.proxyFactory.createAdvisedProxy(params);
/*     */   }
/*     */ 
/*     */   protected Object assertCreateProxy(Object target, AOPProxyFactoryMixin[] mixins, Class expected)
/*     */     throws Exception
/*     */   {
/* 173 */     Object proxy = createProxy(target, mixins);
/* 174 */     assertNotNull(proxy);
/* 175 */     assertTrue("Proxy " + proxy + " should implement " + expected.getName() + " interfaces=" + getInterfaces(proxy), expected.isInstance(proxy));
/* 176 */     return proxy;
/*     */   }
/*     */ 
/*     */   protected Object assertCreateProxy(Object target, Class[] interfaces, AOPProxyFactoryMixin[] mixins, Class[] expected)
/*     */     throws Exception
/*     */   {
/* 191 */     Object proxy = createProxy(target, interfaces, mixins);
/* 192 */     assertNotNull(proxy);
/* 193 */     for (int i = 0; i < expected.length; i++)
/*     */     {
/* 195 */       assertTrue("Proxy " + proxy + " should implement " + expected[i].getName() + " interfaces=" + getInterfaces(proxy), expected[i].isInstance(proxy));
/*     */     }
/* 197 */     return proxy;
/*     */   }
/*     */ 
/*     */   protected Object assertCreateProxy(Object target, Class[] interfaces, Class expected)
/*     */     throws Exception
/*     */   {
/* 211 */     Object proxy = createProxy(target, interfaces);
/* 212 */     assertNotNull(proxy);
/* 213 */     assertTrue("Proxy " + proxy + " should implement " + expected.getName() + " interfaces=" + getInterfaces(proxy), expected.isInstance(proxy));
/* 214 */     return proxy;
/*     */   }
/*     */ 
/*     */   protected Object createProxy(Object target, Class[] interfaces, SimpleMetaData metaData)
/*     */     throws Exception
/*     */   {
/* 228 */     AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
/* 229 */     params.setProxiedClass(target.getClass());
/* 230 */     params.setInterfaces(interfaces);
/* 231 */     params.setSimpleMetaData(metaData);
/* 232 */     params.setTarget(target);
/* 233 */     return this.proxyFactory.createAdvisedProxy(params);
/*     */   }
/*     */ 
/*     */   protected Object assertCreateProxy(Object target, Class[] interfaces, SimpleMetaData metaData, Class expected)
/*     */     throws Exception
/*     */   {
/* 248 */     Object proxy = createProxy(target, interfaces, metaData);
/* 249 */     assertNotNull(proxy);
/* 250 */     assertTrue("Proxy " + proxy + " should implement " + expected.getName() + " interfaces=" + getInterfaces(proxy), expected.isInstance(proxy));
/* 251 */     return proxy;
/*     */   }
/*     */ 
/*     */   protected Object createHollowProxy(Class[] interfaces, SimpleMetaData metaData)
/*     */     throws Exception
/*     */   {
/* 264 */     AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
/* 265 */     params.setInterfaces(interfaces);
/* 266 */     params.setSimpleMetaData(metaData);
/* 267 */     return this.proxyFactory.createAdvisedProxy(params);
/*     */   }
/*     */ 
/*     */   protected Object createHollowProxy(AOPProxyFactoryMixin[] mixins, SimpleMetaData metaData)
/*     */     throws Exception
/*     */   {
/* 280 */     AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
/* 281 */     params.setMixins(mixins);
/* 282 */     params.setSimpleMetaData(metaData);
/* 283 */     return this.proxyFactory.createAdvisedProxy(params);
/*     */   }
/*     */ 
/*     */   protected Object createHollowProxy(Class[] interfaces, AOPProxyFactoryMixin[] mixins, SimpleMetaData metaData)
/*     */     throws Exception
/*     */   {
/* 297 */     AOPProxyFactoryParameters params = new AOPProxyFactoryParameters();
/* 298 */     params.setInterfaces(interfaces);
/* 299 */     params.setMixins(mixins);
/* 300 */     params.setSimpleMetaData(metaData);
/* 301 */     return this.proxyFactory.createAdvisedProxy(params);
/*     */   }
/*     */ 
/*     */   protected Object assertCreateHollowProxy(Class[] interfaces, SimpleMetaData metaData, Class expected)
/*     */     throws Exception
/*     */   {
/* 315 */     Object proxy = createHollowProxy(interfaces, metaData);
/* 316 */     assertNotNull(proxy);
/* 317 */     assertTrue("Proxy " + proxy + " should implement " + expected.getName() + " interfaces=" + getInterfaces(proxy), expected.isInstance(proxy));
/* 318 */     return proxy;
/*     */   }
/*     */ 
/*     */   protected Object assertCreateHollowProxy(AOPProxyFactoryMixin[] mixins, SimpleMetaData metaData, Class expected)
/*     */     throws Exception
/*     */   {
/* 332 */     Object proxy = createHollowProxy(mixins, metaData);
/* 333 */     assertNotNull(proxy);
/* 334 */     assertTrue("Proxy " + proxy + " should implement " + expected.getName() + " interfaces=" + getInterfaces(proxy), expected.isInstance(proxy));
/* 335 */     return proxy;
/*     */   }
/*     */ 
/*     */   protected Object assertCreateHollowProxy(Class[] interfaces, AOPProxyFactoryMixin[] mixins, SimpleMetaData metaData, Class[] expected)
/*     */     throws Exception
/*     */   {
/* 350 */     Object proxy = createHollowProxy(interfaces, mixins, metaData);
/* 351 */     assertNotNull(proxy);
/* 352 */     for (int i = 0; i < expected.length; i++)
/*     */     {
/* 354 */       assertTrue("Proxy " + proxy + " should implement " + expected[i].getName() + " interfaces=" + getInterfaces(proxy), expected[i].isInstance(proxy));
/*     */     }
/* 356 */     return proxy;
/*     */   }
/*     */ 
/*     */   protected Set getInterfaces(Object object)
/*     */   {
/* 366 */     Set interfaces = new HashSet();
/* 367 */     addInterfaces(interfaces, object.getClass());
/* 368 */     return interfaces;
/*     */   }
/*     */ 
/*     */   protected void addInterfaces(Set<Class> interfaces, Class clazz)
/*     */   {
/* 379 */     Class[] intfs = clazz.getInterfaces();
/* 380 */     for (int i = 0; i < intfs.length; i++)
/* 381 */       interfaces.add(intfs[i]);
/* 382 */     Class superClass = clazz.getSuperclass();
/* 383 */     if (superClass != null)
/* 384 */       addInterfaces(interfaces, superClass);
/*     */   }
/*     */ 
/*     */   protected AbstractProxyTestDelegate getMCDelegate()
/*     */   {
/* 394 */     return (AbstractProxyTestDelegate)getDelegate();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.junit.AbstractProxyTest
 * JD-Core Version:    0.6.0
 */