/*    */ package org.jboss.aop.microcontainer.integration;
/*    */ 
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.classadapter.spi.DependencyBuilderListItem;
/*    */ import org.jboss.dependency.plugins.AbstractDependencyItem;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.dependency.spi.DependencyInfo;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ 
/*    */ class AspectDependencyBuilderListItem
/*    */   implements DependencyBuilderListItem<KernelControllerContext>
/*    */ {
/*    */   String dependencyName;
/*    */ 
/*    */   AspectDependencyBuilderListItem(String name)
/*    */   {
/* 41 */     this.dependencyName = name;
/*    */   }
/*    */ 
/*    */   public void addDependency(KernelControllerContext context)
/*    */   {
/* 46 */     BeanMetaData metaData = context.getBeanMetaData();
/* 47 */     AbstractDependencyItem dependency = new AbstractDependencyItem(metaData.getName(), this.dependencyName, ControllerState.INSTANTIATED, ControllerState.INSTALLED);
/* 48 */     DependencyInfo depends = context.getDependencyInfo();
/* 49 */     depends.addIDependOn(dependency);
/*    */   }
/*    */ 
/*    */   public boolean equals(Object o)
/*    */   {
/* 54 */     if ((o instanceof AspectDependencyBuilderListItem))
/*    */     {
/* 56 */       return this.dependencyName.equals(((AspectDependencyBuilderListItem)o).dependencyName);
/*    */     }
/* 58 */     return false;
/*    */   }
/*    */ 
/*    */   public int hashCode()
/*    */   {
/* 63 */     return this.dependencyName.hashCode();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.integration.AspectDependencyBuilderListItem
 * JD-Core Version:    0.6.0
 */