/*     */ package org.jboss.aop.microcontainer.beans.beanmetadatafactory;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.microcontainer.beans.Stack;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractListMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ 
/*     */ public class StackBeanMetaDataFactory extends AspectManagerAwareBeanMetaDataFactory
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*  41 */   private List<BaseInterceptorData> interceptors = new ArrayList();
/*     */ 
/*     */   public StackBeanMetaDataFactory()
/*     */   {
/*  46 */     setBeanClass("IGNORED");
/*     */   }
/*     */ 
/*     */   public List<BeanMetaData> getBeans()
/*     */   {
/*  52 */     ArrayList result = new ArrayList();
/*     */ 
/*  55 */     AbstractBeanMetaData stack = new AbstractBeanMetaData();
/*  56 */     stack.setName(this.name);
/*  57 */     BeanMetaDataUtil.setSimpleProperty(stack, "name", this.name);
/*  58 */     stack.setBean(Stack.class.getName());
/*     */ 
/*  60 */     this.util.setAspectManagerProperty(stack, "manager");
/*  61 */     result.add(stack);
/*     */     AbstractListMetaData almd;
/*     */     int i;
/*  63 */     if (this.interceptors.size() > 0)
/*     */     {
/*  65 */       almd = new AbstractListMetaData();
/*  66 */       i = 0;
/*  67 */       for (BaseInterceptorData interceptor : this.interceptors)
/*     */       {
/*  69 */         AbstractBeanMetaData bmd = new AbstractBeanMetaData(interceptor.getBeanClassName());
/*  70 */         String intName = this.name + "$" + i++;
/*  71 */         bmd.setName(intName);
/*  72 */         this.util.setAspectManagerProperty(bmd, "manager");
/*  73 */         BeanMetaDataUtil.setSimpleProperty(bmd, "forStack", Boolean.TRUE);
/*     */ 
/*  75 */         if ((interceptor instanceof AdviceData))
/*     */         {
/*  77 */           BeanMetaDataUtil.DependencyBuilder db = new BeanMetaDataUtil.DependencyBuilder(bmd, "aspect", interceptor.getRefName());
/*  78 */           BeanMetaDataUtil.setDependencyProperty(db);
/*  79 */           if (((AdviceData)interceptor).getAdviceMethod() != null)
/*     */           {
/*  81 */             BeanMetaDataUtil.setSimpleProperty(bmd, "aspectMethod", ((AdviceData)interceptor).getAdviceMethod());
/*     */           }
/*  83 */           BeanMetaDataUtil.setSimpleProperty(bmd, "type", ((AdviceData)interceptor).getType());
/*     */         }
/*     */         else
/*     */         {
/*  88 */           BeanMetaDataUtil.DependencyBuilder db = new BeanMetaDataUtil.DependencyBuilder(bmd, "stack", interceptor.getRefName());
/*  89 */           BeanMetaDataUtil.setDependencyProperty(db);
/*     */         }
/*  91 */         result.add(bmd);
/*  92 */         almd.add(new AbstractInjectionValueMetaData(intName));
/*  93 */         BeanMetaDataUtil.setSimpleProperty(stack, "advices", almd);
/*     */       }
/*     */     }
/*     */ 
/*  97 */     return result;
/*     */   }
/*     */ 
/*     */   public void addInterceptor(BaseInterceptorData interceptorData)
/*     */   {
/* 102 */     this.interceptors.add(interceptorData);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.beanmetadatafactory.StackBeanMetaDataFactory
 * JD-Core Version:    0.6.0
 */