/*     */ package org.jboss.aop.microcontainer.beans.beanmetadatafactory;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.aop.microcontainer.beans.LifecycleBinding;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.PropertyMetaData;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ 
/*     */ public abstract class LifecycleBeanMetaDataFactory extends AspectManagerAwareBeanMetaDataFactory
/*     */   implements BeanMetaDataFactory
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String classes;
/*     */   private String expr;
/*     */   private String installMethod;
/*     */   private String uninstallMethod;
/*  53 */   HashSet<PropertyMetaData> properties = new HashSet();
/*     */ 
/*     */   public void setClasses(String classes)
/*     */   {
/*  57 */     this.classes = classes;
/*     */   }
/*     */ 
/*     */   public void setExpr(String classes)
/*     */   {
/*  62 */     this.expr = classes;
/*     */   }
/*     */ 
/*     */   public void setInstallMethod(String installMethod)
/*     */   {
/*  67 */     this.installMethod = installMethod;
/*     */   }
/*     */ 
/*     */   public void setUninstallMethod(String uninstallMethod)
/*     */   {
/*  72 */     this.uninstallMethod = uninstallMethod;
/*     */   }
/*     */ 
/*     */   protected abstract ControllerState getState();
/*     */ 
/*     */   public List<BeanMetaData> getBeans() {
/*  79 */     ArrayList result = new ArrayList();
/*     */ 
/*  82 */     AbstractBeanMetaData lifecycle = new AbstractBeanMetaData();
/*  83 */     lifecycle.setName(this.name);
/*  84 */     lifecycle.setBean(getBeanClass());
/*  85 */     for (PropertyMetaData pmd : this.properties)
/*     */     {
/*  87 */       lifecycle.addProperty(pmd);
/*     */     }
/*  89 */     lifecycle.setDepends(getDepends());
/*  90 */     result.add(lifecycle);
/*     */ 
/*  93 */     String aspectBindingName = this.name + "$AspectBinding";
/*  94 */     AbstractBeanMetaData aspectBinding = new AbstractBeanMetaData();
/*  95 */     aspectBinding.setName(aspectBindingName);
/*  96 */     aspectBinding.setBean(LifecycleBinding.class.getName());
/*     */ 
/*  98 */     BeanMetaDataUtil.setSimpleProperty(aspectBinding, "callbackBean", this.name);
/*  99 */     this.util.setAspectManagerProperty(aspectBinding, "manager");
/* 100 */     if (this.expr != null)
/*     */     {
/* 102 */       BeanMetaDataUtil.setSimpleProperty(aspectBinding, "expr", this.expr);
/*     */     }
/* 104 */     else if (this.classes != null)
/*     */     {
/* 106 */       BeanMetaDataUtil.setSimpleProperty(aspectBinding, "classes", this.classes);
/*     */     }
/* 108 */     BeanMetaDataUtil.setSimpleProperty(aspectBinding, "state", getState());
/* 109 */     if (this.installMethod != null)
/*     */     {
/* 111 */       BeanMetaDataUtil.setSimpleProperty(aspectBinding, "installMethod", this.installMethod);
/*     */     }
/* 113 */     if (this.uninstallMethod != null)
/*     */     {
/* 115 */       BeanMetaDataUtil.setSimpleProperty(aspectBinding, "uninstallMethod", this.uninstallMethod);
/*     */     }
/* 117 */     result.add(aspectBinding);
/*     */ 
/* 119 */     return result;
/*     */   }
/*     */ 
/*     */   protected boolean hasInjectedBeans()
/*     */   {
/* 125 */     ArrayList dependencies = new ArrayList();
/* 126 */     getDependencies(dependencies, this);
/*     */ 
/* 128 */     for (AbstractDependencyValueMetaData dep : dependencies)
/*     */     {
/* 130 */       if (!((String)dep.getValue()).startsWith("jboss.kernel:service="))
/*     */       {
/* 132 */         return true;
/*     */       }
/*     */     }
/* 135 */     return false;
/*     */   }
/*     */ 
/*     */   private void getDependencies(ArrayList<AbstractDependencyValueMetaData> dependencies, MetaDataVisitorNode node)
/*     */   {
/* 140 */     Iterator children = node.getChildren();
/*     */ 
/* 142 */     if (children != null)
/*     */     {
/* 144 */       while (children.hasNext())
/*     */       {
/* 146 */         MetaDataVisitorNode child = (MetaDataVisitorNode)children.next();
/* 147 */         if ((child instanceof AbstractDependencyValueMetaData))
/*     */         {
/* 149 */           dependencies.add((AbstractDependencyValueMetaData)child);
/*     */         }
/* 151 */         getDependencies(dependencies, child);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void addBeanProperty(PropertyMetaData property)
/*     */   {
/* 159 */     this.properties.add(property);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.beanmetadatafactory.LifecycleBeanMetaDataFactory
 * JD-Core Version:    0.6.0
 */