/*     */ package org.jboss.aop.microcontainer.beans.beanmetadatafactory;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import java.util.StringTokenizer;
/*     */ import org.jboss.aop.microcontainer.beans.IntroductionBinding;
/*     */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractListMetaData;
/*     */ import org.jboss.beans.metadata.plugins.StringValueMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class IntroductionBeanMetaDataFactory extends AspectManagerAwareBeanMetaDataFactory
/*     */   implements BeanMetaDataFactory
/*     */ {
/*     */   private static final long serialVersionUID = 1L;
/*     */   private String clazz;
/*     */   private String expr;
/*     */   private String interfaces;
/*  51 */   private ArrayList<AbstractBeanMetaData> mixins = new ArrayList();
/*     */ 
/*     */   public IntroductionBeanMetaDataFactory()
/*     */   {
/*  55 */     setBeanClass("IGNORED");
/*     */   }
/*     */ 
/*     */   public String getClazz()
/*     */   {
/*  60 */     return this.clazz;
/*     */   }
/*     */ 
/*     */   public void setClazz(String clazz)
/*     */   {
/*  65 */     this.clazz = clazz;
/*     */   }
/*     */ 
/*     */   public String getExpr()
/*     */   {
/*  70 */     return this.expr;
/*     */   }
/*     */ 
/*     */   public void setExpr(String expr)
/*     */   {
/*  75 */     this.expr = expr;
/*     */   }
/*     */ 
/*     */   public String getInterfaces()
/*     */   {
/*  81 */     return this.interfaces;
/*     */   }
/*     */ 
/*     */   public void setInterfaces(String interfaces)
/*     */   {
/*  86 */     this.interfaces = interfaces;
/*     */   }
/*     */ 
/*     */   public void addMixinEntry(AbstractBeanMetaData mixin)
/*     */   {
/*  91 */     this.mixins.add(mixin);
/*     */   }
/*     */ 
/*     */   public List<BeanMetaData> getBeans()
/*     */   {
/*  97 */     ArrayList result = new ArrayList();
/*     */ 
/* 100 */     AbstractBeanMetaData introduction = new AbstractBeanMetaData(IntroductionBinding.class.getName());
/* 101 */     String name = getName();
/* 102 */     if (name == null)
/*     */     {
/* 104 */       name = GUID.asString();
/*     */     }
/* 106 */     introduction.setName(name);
/* 107 */     BeanMetaDataUtil.setSimpleProperty(introduction, "name", name);
/* 108 */     this.util.setAspectManagerProperty(introduction, "manager");
/* 109 */     if (this.clazz != null)
/*     */     {
/* 111 */       BeanMetaDataUtil.setSimpleProperty(introduction, "classes", this.clazz);
/*     */     }
/* 113 */     if (this.expr != null)
/*     */     {
/* 115 */       BeanMetaDataUtil.setSimpleProperty(introduction, "expr", this.expr);
/*     */     }
/*     */ 
/* 118 */     result.add(introduction);
/*     */ 
/* 120 */     if (this.interfaces != null)
/*     */     {
/* 122 */       addInterfaces(introduction, "interfaces", this.interfaces);
/*     */     }
/* 124 */     if (this.mixins != null)
/*     */     {
/* 126 */       addMixins(introduction, result);
/*     */     }
/*     */ 
/* 129 */     return result;
/*     */   }
/*     */ 
/*     */   public static void addInterfaces(AbstractBeanMetaData introduction, String propertyName, String interfaces)
/*     */   {
/* 134 */     AbstractListMetaData lmd = new AbstractListMetaData();
/* 135 */     lmd.setType(ArrayList.class.getName());
/* 136 */     lmd.setElementType(String.class.getName());
/* 137 */     BeanMetaDataUtil.setSimpleProperty(introduction, propertyName, lmd);
/*     */ 
/* 139 */     StringTokenizer tok = new StringTokenizer(interfaces, ",");
/* 140 */     while (tok.hasMoreTokens())
/*     */     {
/* 142 */       String token = tok.nextToken();
/* 143 */       lmd.add(new StringValueMetaData(token.trim()));
/*     */     }
/*     */   }
/*     */ 
/*     */   private void addMixins(AbstractBeanMetaData introduction, List<BeanMetaData> result)
/*     */   {
/* 149 */     AbstractListMetaData lmd = new AbstractListMetaData();
/* 150 */     lmd.setType(ArrayList.class.getName());
/* 151 */     BeanMetaDataUtil.setSimpleProperty(introduction, "mixins", lmd);
/* 152 */     int i = 0;
/* 153 */     for (AbstractBeanMetaData mixin : this.mixins)
/*     */     {
/* 155 */       String name = introduction.getName() + "$" + i++;
/* 156 */       mixin.setName(name);
/* 157 */       result.add(mixin);
/*     */ 
/* 159 */       lmd.add(new AbstractInjectionValueMetaData(name));
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.beanmetadatafactory.IntroductionBeanMetaDataFactory
 * JD-Core Version:    0.6.0
 */