/*    */ package org.jboss.aop.microcontainer.beans;
/*    */ 
/*    */ class SecurityActions
/*    */ {
/*    */   public static ClassLoader getContextClassLoader()
/*    */   {
/* 54 */     if (System.getSecurityManager() == null)
/*    */     {
/* 56 */       return GetContextClassLoaderAction.NOT_PRIVILEGED.getContextClassLoader();
/*    */     }
/*    */ 
/* 60 */     return GetContextClassLoaderAction.PRIVILEGED.getContextClassLoader();
/*    */   }
/*    */ 
/*    */   private static abstract interface GetContextClassLoaderAction
/*    */   {
/* 35 */     public static final GetContextClassLoaderAction PRIVILEGED = new GetContextClassLoaderAction()
/*    */     {
/*    */       public ClassLoader getContextClassLoader()
/*    */       {
/* 39 */         return null;
/*    */       }
/* 35 */     };
/*    */ 
/* 43 */     public static final GetContextClassLoaderAction NOT_PRIVILEGED = new GetContextClassLoaderAction()
/*    */     {
/*    */       public ClassLoader getContextClassLoader()
/*    */       {
/* 47 */         return Thread.currentThread().getContextClassLoader();
/*    */       }
/* 43 */     };
/*    */ 
/*    */     public abstract ClassLoader getContextClassLoader();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.SecurityActions
 * JD-Core Version:    0.6.0
 */