/*    */ package org.jboss.aop.microcontainer.beans;
/*    */ 
/*    */ import java.util.List;
/*    */ import org.jboss.aop.AspectManager;
/*    */ import org.jboss.util.id.GUID;
/*    */ 
/*    */ public class PrecedenceDef
/*    */ {
/*    */   private AspectManager manager;
/*    */   private List<PrecedenceDefEntry> entries;
/* 38 */   private String name = GUID.asString();
/*    */ 
/*    */   public AspectManager getManager()
/*    */   {
/* 42 */     return this.manager;
/*    */   }
/*    */ 
/*    */   public void setManager(AspectManager manager)
/*    */   {
/* 47 */     this.manager = manager;
/*    */   }
/*    */ 
/*    */   public List<PrecedenceDefEntry> getEntries()
/*    */   {
/* 52 */     return this.entries;
/*    */   }
/*    */ 
/*    */   public void setEntries(List<PrecedenceDefEntry> precedenceEntries)
/*    */   {
/* 57 */     this.entries = precedenceEntries;
/*    */   }
/*    */ 
/*    */   public String getName()
/*    */   {
/* 62 */     return this.name;
/*    */   }
/*    */ 
/*    */   public void setName(String name)
/*    */   {
/* 67 */     this.name = name;
/*    */   }
/*    */ 
/*    */   public void start()
/*    */   {
/* 72 */     if (this.manager == null)
/* 73 */       throw new IllegalArgumentException("Null manager");
/* 74 */     if (this.entries == null)
/* 75 */       throw new IllegalArgumentException("Null entries");
/* 76 */     if (this.entries.size() == 0) {
/* 77 */       throw new IllegalArgumentException("No entries");
/*    */     }
/* 79 */     org.jboss.aop.advice.PrecedenceDefEntry[] pentries = new org.jboss.aop.advice.PrecedenceDefEntry[this.entries.size()];
/* 80 */     int i = 0;
/* 81 */     for (PrecedenceDefEntry entry : this.entries)
/*    */     {
/* 83 */       pentries[(i++)] = new org.jboss.aop.advice.PrecedenceDefEntry(entry.getAspectName(), entry.getAspectMethod());
/*    */     }
/*    */ 
/* 86 */     this.manager.addPrecedence(new org.jboss.aop.advice.PrecedenceDef(this.name, pentries));
/*    */   }
/*    */ 
/*    */   public void stop()
/*    */   {
/* 91 */     this.manager.removePrecedence(this.name);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.aop.microcontainer.beans.PrecedenceDef
 * JD-Core Version:    0.6.0
 */